<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\PeriodoSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\bootstrap\Progress;
use yii\helpers\Url;
use kartik\widgets\ActiveForm;
use kartik\tabs\TabsX;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use backend\models\Periodo;
use backend\models\Grupo;

$this->title = Yii::t('app', 'Procesar');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Procesar'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

    $total = count($grupos);
    $avanza = 100 / $total;

?>  



<div class="row">
    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
        <?= Html::img('@web/images/sonic-tiempo.png', ['class'=>'img-responsive']); ?>
    </div>
    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
        <div class="row">
            <div class="col-lg-12 col-md-6 col-sm-6 col-xs-12">
                <p class='titulo'><?= Yii::t('app', '¿Deseas reprocesar los promedios y puestos de los estudiantes?') ?></p>
                <p class='observaciones'><?= Yii::t('app', 'Se procesara los promedios del estudiante, grupo, area por grupo, area por grado y por el colegio.') ?></p>
            </div>
        </div> 
        <div class="row">
            <div id="aplicar" class="col-lg-4 col-md-4 col-sm-4 col-xs-6">
                <?= Html::Button('Cerrar Periodo y Año Escolar', ['class' => 'btn btn-danger btn-block']); ?>
            </div>
        </div>     
        <div class="row" style="margin-top: 20px;">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div id="mensaje"></div>
                <?php
                    echo Progress::widget([
                        'percent' => 0,
                        'barOptions' => ['class' => 'progress-bar-info',],
                        'options' => ['id' => 'progBar', 'class' => 'active progress-striped', 'style' => 'display: none;']
                    ]);
                ?>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12 col-md-6 col-sm-6 col-xs-12">
                <div id="datos">
                    <ul class='list-group'>
                        <!--<li class='list-group-item active'>Grupos a reprocesar promedios y puestos...</li> -->
                            
                            <?php 

                                $datos = [];

                                foreach ($grupos as $grupo) 
                                { 
                                    $datos[] = $grupo->id;
                            ?>

                                    <li class='list-group-item'>
                                        <?= strtoupper($grupo->grupo) ?>
                                        <div id="<?= $grupo->id ?>" style='float:right;'>
                                            <i class='fas fa-clock text-info'></i>
                                        </div>
                                    </li>


                            <?php } ?>
                    </ul>
                </div>
            </div>
        </div>

        
    </div>     
</div>

        
        
      


<?

$out = array_values($datos);
$ids = json_encode($out);

$this->registerJs("

$(document).ready(function() {
    
    $('#aplicar').click(function() {

        var avanza = 0;
        periodo = $('#promedio-periodo').val();


        $('#progBar').slideDown().show();
        $('.progress-bar')[0].style.width = 0;

        //$('#aplicar').html(\"<h4 class='text-success'><i class='fa fa-clock'></i> Estamos trabajando en ello.</h4> \");

        ids = $ids;
        
        $.each(ids, function(indice, valor){    

            $('#'+valor).html(\"<div id='loading-wrapper-e'><div class='object-e' id='first_object_e'></div><div class='object-e' id='second_object_e'></div></div>\");

            $.ajax({
                type: 'POST',
                url: '". Url::to(['cerrar'])."',
                //timeout: 60000,

                data: {grupo : valor, periodo : periodo},
                success: function (data) {
                    $('#'+valor).html(\"<i class='fas fa-check text-success'></i>\");
                    
                    $('.progress-bar').css(\"width\", parseFloat($('.progress-bar')[0].style.width) + ".$avanza." + \"%\");
                    console.log(parseFloat($('.progress-bar')[0].style.width));
                        
                    if(parseInt($('.progress-bar')[0].style.width) >= 100)
                    {
                        $('.progress-bar').toggleClass(\"progress-bar-info \" + \"progress-bar-success\");    
                    }    
                    
                },
                error: function(request, status, err) {
                    if (status == 'timeout') {
                        //timeout -> reload the page and try again
                        $('#'+valor).html(\"<i class='fas fa-times text-danger'></i>\");
                        console.log('timeout');
                        //window.location.reload();
                    } else {
                        $('#'+valor).html(\"<span class='text-danger'>\"+ err + \"</span>\");
                        //another error occured  
                        //alert('error: ' + request + status + err);
                    }
                }
        
            });

        });
        
    });

});

");

?>
