<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\PeriodoSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\bootstrap\Progress;
use yii\helpers\Url;
use kartik\widgets\ActiveForm;
use kartik\tabs\TabsX;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use backend\models\Periodo;

$this->title = 'Cambiar Periodo';
$this->params['breadcrumbs'][] = ['label' => 'Periodos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;



?>  

    <?php $form = ActiveForm::begin([
        'type' => ActiveForm::TYPE_VERTICAL,
        'enableClientValidation' => false,
        'enableAjaxValidation' => true,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                    ]
    ]); ?>


<div class="row">
    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
        <?= Html::img('@web/images/sonic-tiempo.png', ['class'=>'img-responsive']); ?>
    </div>
    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
        <div class="row">
            <div class="col-lg-12 col-md-6 col-sm-6 col-xs-12">
                <p class='titulo'><?= Yii::t('app', '¿Deseas cambiar el periodo?') ?></p>
                <p class='observaciones'><?= Yii::t('app', 'Recuerda que los docentes que no hayan publicado sus calificaciones, nivelaciones, observaciones, asistencias o alguna información del periodo actual ya no podrán hacerlo.') ?></p>
            </div>
        </div> 
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    
                    <?= $form->field($model, 'periodo')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Periodo::find()->orderBy('id')->asArray()->all(), 'id', 'periodo'),
                        'pluginOptions' => [
                            'placeholder' => 'Seleccione el Periodo',
                            'allowClear' => true,
                        ],
                    ])->label(false) ?>
            </div>
            <div id="aplicar" class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <?= Html::Button('Cambiar Periodo', ['class' => 'btn btn-danger btn-block']); ?>
            </div>
        </div>     
        <div class="row" style="margin-top: 20px;">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div id="mensaje"></div>
                <?php
                    echo Progress::widget([
                        'percent' => 0,
                        'barOptions' => ['class' => 'progress-bar-info',],
                        'options' => ['id' => 'progBar', 'class' => 'active progress-striped', 'style' => 'display: none;']
                    ]);
                ?>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12 col-md-6 col-sm-6 col-xs-12">
                <p class='titulo'><?= Yii::t('app', '¿Deseas activar calificaciones y/o nivelaciones?') ?></p>
                <p class='observaciones'><?= Yii::t('app', 'Active los periodos a los cuales desea activar el módulo de nivelaciones.') ?></p>

                        <?= $form->errorSummary($model); ?>

            </div>
        </div> 
        
       <?php $form = ActiveForm::begin([
        'validateOnSubmit' => true,
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                    ]
        ]); ?>

                    
        <?php 
            
            $items = [];

            foreach ($periodos as $index => $periodo) 
            {
                $items[] = [
                            'label'=> $periodo->id == $model->periodo ? '<i class="fas fa-star"></i> Periodo '.$periodo->id : 'Periodo'.$periodo->id,
                            'content'=> '',
                            'content' => $this->render('_formSeleccionar', [
                                'form' => $form,
                                'model' => $periodo,
                                'index' => $index,
                            ]),
                            //'active' => false,
                            'active'=> $periodo->id == $model->periodo ? true : false,
                            //'linkOptions'=>['data-url'=>\yii\helpers\Url::to(['tabs','id' =>$p])],
                         ];
            }

        ?>
        


        <div class="row">
            <div class="col-lg-12 col-md-6 col-sm-6 col-xs-12">
                <?= TabsX::widget([
                    'items'=>$items,
                    'position'=>TabsX::POS_ABOVE,
                    'encodeLabels'=>false,
                    'pluginOptions' => [
                        'bordered' => true,
                        'sideways' => true,
                        'enableCache' => false,
                    ],
                ]); ?>
            </div>
        </div>
        <?php ActiveForm::end(); ?>

        
    </div>     
</div>

        
        
      


<?

$this->registerJs("

$(document).ready(function() {
    
    $('#aplicar').click(function() {
        periodo = $('#periodo-periodo').val();
        

        $('#progBar').slideDown().show();
        $('.progress-bar')[0].style.width = 0;

        $('#mensaje').html(\"<h4 class='text-success'><i class='fa fa-clock'></i> Estamos trabajando en ello.</h4> \");

        $.ajax({
            type: 'GET',
            url: '". Url::to(['seleccionar'])."',
            timeout: 20000,

            data: {periodo : periodo},
            success: function (data) {
                
                
                $('.progress-bar').css(\"width\", parseInt($('.progress-bar')[0].style.width) + 100 + \"%\");
                    
                if(parseInt($('.progress-bar')[0].style.width) >= 100)
                {
                    $('.progress-bar').toggleClass(\"progress-bar-info \" + \"progress-bar-success\");    
                } 

                $('#mensaje').html(\"<h4 class='text-success'><i class='fa fa-clock'></i> Se ha configurado el \"+ data + \"</h4> \");   
                window.location.reload();
                
            },
            error: function(request, status, err) {
                if (status == 'timeout') {
                    //timeout -> reload the page and try again
                        //$('#'+valor).html(\"<i class='fas fa-times text-danger'></i>\");
                    console.log('timeout');
                    //window.location.reload();
                } else {
                        //$('#'+valor).html(\"<span class='text-danger'>\"+ err + \"</span>\");
                    //another error occured  
                    //alert('error: ' + request + status + err);
                    console.log('error: ' + request + status + err);
                }
            }
    
        });        
    });

});

");

?>


<script type="text/javascript">
    setTimeout(function() {
        $("#flow_tabs").find("li.active a").click();
    },10)
</script>