<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use yii\helpers\Url;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Periodo */

$this->title = $model->periodo;
$this->params['breadcrumbs'][] = ['label' => 'Periodos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Actualizar', 'url' => 'update', 'id' => $model->id, 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'PDF', 'url' => 'pdf', 'id' => $model->id, 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Eliminar', 'url' => 'delete', 'id' => $model->id, 'icon' => '<i class="far fa-trash-alt"></i>', 'class' => 'danger'];

?>
<div class="periodo-view">

    <div class="row">
<?php 
    $gridColumn = [
        'periodo',
        [
            'columns' => [
                [
                    'attribute' => 'fecha_inicio',
                    'format' => 'RAW',
                ],   
                [
                    'attribute' => 'fecha_fin',
                    'format' => 'RAW',
                ],
            ],
        ],
        [
            'columns' => [
                [
                    'attribute' => 'autorizar_calificaciones',
                    'format' => 'RAW',
                    'value' => ($model->autorizar_calificaciones == 1) ? '<span class="label label-success">Si</span>' : '<span class="label label-danger">No</span>',
                ],
                [
                    'attribute' => 'calificaciones_inicio',
                    'format' => 'RAW',
                ],   
                [
                    'attribute' => 'calificaciones_fin',
                    'format' => 'RAW',
                ],
            ],
        ],
        [
            'columns' => [
                [
                    'attribute' => 'autorizar_nivelaciones',
                    'format' => 'RAW',
                    'value' => ($model->autorizar_nivelaciones == 1) ? '<span class="label label-success">Si</span>' : '<span class="label label-danger">No</span>',
                ],
                [
                    'attribute' => 'nivelaciones_inicio',
                    'format' => 'RAW',
                ],   
                [
                    'attribute' => 'nivelaciones_fin',
                    'format' => 'RAW',
                ],
            ],
        ],
        [
            'columns' => [
                [
                    'attribute' => 'habilitado',
                    'format' => 'RAW',
                    'value' => ($model->habilitado == 1) ? '<span class="label label-success">Habilitado</span>' : '<span class="label label-danger">Deshabilitado</span>',
                ],   
                [
                    'attribute' => 'estado',
                    'format' => 'RAW',
                    'value' => ($model->estado == 1) ? '<span class="label label-success">Activo</span>' : '<span class="label label-danger">Inactivo</span>',
                ],
            ],
        ],
        
    ];
    
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_DEFAULT,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]); 
?>
    </div>
</div>
