<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\Tercero;
use backend\models\Grado;
use backend\models\Asignatura;
use backend\models\Grupo;
use backend\models\Periodo;
use backend\models\Competencia;

?>
<div class="planaula-view">


    <div class="row">

<?php 
    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' => [
                [
                    'attribute'=>'docente',
                    'value'=>$model->docentes->nombre,
                    'valueColOptions'=>['style'=>'width:100%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Tercero::find()->asArray()->all(), 'id', 'primer_apellido'),
                    ],
                ],
                
            ],
        ], 
        [    
            'columns' => [ 
                [
                    'attribute'=>'semana_inicio', 
                    'format'=>'date',
                    'type'=>DetailView::INPUT_DATE,
                    'widgetOptions' => [
                        'pluginOptions'=>['autoclose' => true,
                                          'format' => 'yyyy-mm-dd',
                                          'todayHighlight' => true]
                    ],
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute'=>'semana_fin', 
                    'format'=>'date',
                    'type'=>DetailView::INPUT_DATE,
                    'widgetOptions' => [
                        'pluginOptions'=>['autoclose' => true,
                                          'format' => 'yyyy-mm-dd',
                                          'todayHighlight' => true]
                    ],
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
            ],
        ], 
        [    
            'columns' => [ 
                [
                    'attribute'=>'grado',
                    'value'=>$model->grados->grado,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Grado::find()->asArray()->all(), 'id', 'grado'),
                    ],
                ],
                [
                    'attribute'=>'grupo',
                    'value'=>$model->grupos->grupo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Grupo::find()->asArray()->all(), 'id', 'grupo'),
                    ],
                ],
            ],
        ],
        [    
            'columns' => [ 
                [
                    'attribute'=>'asignatura',
                    'value'=>$model->asignaturas->asignatura,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Asignatura::find()->asArray()->all(), 'id', 'asignatura'),
                    ],
                ],
                 [
                    'attribute'=>'periodo',
                    'value'=>$model->periodos->periodo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Periodo::find()->asArray()->all(), 'id', 'periodo'),
                    ],
                ],
            ],
        ],        
          
        [    
            'columns' => [ 
                [
                    'attribute'=>'competencia',
                    'value'=>$model->competencias->competencia,
                    'valueColOptions'=>['style'=>'width:80%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Competencia::find()->asArray()->all(), 'id', 'competencia'),
                    ],
                ],
                
            ],
        ],
        [    
            'columns' => [ 
                [
                    'attribute'=>'unidad',
                    'valueColOptions'=>['style'=>'width:10%'],
                    
                ],
                [
                    'attribute'=>'nombre_unidad',
                    'valueColOptions'=>['style'=>'width:20%'],
                ],
                [
                    'attribute'=>'horas',
                    'valueColOptions'=>['style'=>'width:10%'],
                    
                ],
            ],
        ],
        [
            'group'=>true,
            'rowOptions'=>['class'=>'info']
        ],         
        [    
            'columns' => [ 
                [
                    'attribute'=>'derechos',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],
            ],
        ],
        [    
            'columns' => [ 
                [
                    'attribute'=>'inicio',
                    'valueColOptions'=>['style'=>'width:80%'],
                    
                ],
            ],
        ],        
        [    
            'columns' => [ 
                [
                    'attribute'=>'desarrollo',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],
            ],
        ],
        [    
            'columns' => [ 
                [
                    'attribute'=>'cierre',
                    'valueColOptions'=>['style'=>'width:80%'],
                    
                ],
            ],
        ],        
        [    
            'columns' => [ 
                [
                    'attribute'=>'formativa',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],
            ],
        ],
        [    
            'columns' => [ 
                [
                    'attribute'=>'articulacion',
                    'valueColOptions'=>['style'=>'width:80%'],
                    
                ],
            ],
        ],        
         [    
            'columns' => [ 
                [
                    'attribute'=>'recursos',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],
            ],
        ],
         [    
            'columns' => [ 
                [
                    'attribute'=>'reflexion',
                    'valueColOptions'=>['style'=>'width:80%'],
                    
                ],
            ],
        ],        
         [    
            'columns' => [ 
                [
                    'attribute'=>'observaciones',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],
            ],
        ],
        [
            'group'=>true,
            'label'=>'Estado en el Sistema',
            'rowOptions'=>['class'=>'info']
        ],        
        [
            'attribute'=>'estado', 
            'format'=>'raw',
            'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>',
            'type'=>DetailView::INPUT_SWITCH,
            'widgetOptions' => [
                'pluginOptions' => [
                    'onText' => 'Activo',
                    'offText' => 'Inactivo',
                ]
        ],
        'valueColOptions'=>['style'=>'width:100%']
    ],        

    ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_SUCCESS,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]); 
?>

    </div>
</div>