<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;
use kartik\widgets\TouchSpin;
use kartik\daterange\DateRangePicker;
use dosamigos\tinymce\TinyMce;


use backend\models\Sede;
use backend\models\Tercero;
use backend\models\Grado;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Competencia;

$this->registerJs("

    $('#planaula-competencia').change(function(){
        
        $('#niveles').fadeOut(500);
        $('#niveles').html('');

        if(this.value!='')
        {    
            findNiveles(this.value);
        }
    });

    $('#planaula-competencia').change(function(){

        //$('#estandar').fadeOut(500);
        //$('#estandar').html('');
        $('#niveles').fadeOut(500);
        $('#niveles').html('');


        if(this.value!='')
        {    
            findNiveles(this.value);
        }

    });

$('#grado-id').change(function(){
            $('#niveles').fadeOut(500);
            $('#niveles').html('');
            $('#estandar').fadeOut(500);
            $('#estandar').html('');

});

$('#asignatura-id').change(function(){
            $('#niveles').fadeOut(500);
            $('#niveles').html('');
            $('#estandar').fadeOut(500);
            $('#estandar').html('');

});

    $('#planaula-periodo').change(function()
    {
        $('#niveles').fadeOut(500);
        $('#niveles').html('');
        $('#estandar').fadeOut(500);
        $('#estandar').html('');

        grado = $('#planaula-grado').val();
        asignatura = $('#planaula-asignatura').val();
        periodo = $('#planaula-periodo').val();
        
        if(grado != '' && asignatura != '' && periodo != '')
        {
            //alert(grado + ' ' + asignatura + ' ' + periodo);
            findEstandar(grado,asignatura,periodo);
        } 


    });

$('#planaula-metodo').change(function(){
    
    if(this.value == '0')
    {
        $('#guia').fadeOut(500);
        $('#adjunto').fadeOut(500);

        $('#estandar').fadeIn(500);
        $('#niveles').fadeIn(500);
        $('#unidad').fadeIn(500);
        $('#nombre_unidad').fadeIn(500);
        $('#horas').fadeIn(500);
        $('#derechos').fadeIn(500);
        $('#inicio').fadeIn(500);
        $('#desarrollo').fadeIn(500);
        $('#cierre').fadeIn(500);
        $('#formativa').fadeIn(500);
        $('#articulacion').fadeIn(500);
        $('#recursos').fadeIn(500);
        $('#reflexion').fadeIn(500);
        $('#observaciones').fadeIn(500);
    }
    else
    {
        $('#estandar').fadeOut(500);
        $('#niveles').fadeOut(500);
        $('#unidad').fadeOut(500);
        $('#nombre_unidad').fadeOut(500);
        $('#horas').fadeOut(500);
        $('#derechos').fadeOut(500);
        $('#inicio').fadeOut(500);
        $('#desarrollo').fadeOut(500);
        $('#cierre').fadeOut(500);
        $('#formativa').fadeOut(500);
        $('#articulacion').fadeOut(500);
        $('#recursos').fadeOut(500);
        $('#reflexion').fadeOut(500);
        $('#observaciones').fadeOut(500);

        $('#guia').fadeIn(500);
        $('#adjunto').fadeIn(500);
    }    
        $('#niveles').html('');

        if(this.value!='')
        {    
            findNiveles(this.value);
        }
    });

function findNiveles(id) {
            
            $.ajax({
                type: 'POST',
                url: '".Url::to(['publica/findniveles'])."',
                data: {test: id},
                success: function (test) {
                    if(test != '')
                    {
                        $('#niveles').fadeIn(500); 
                        //$('#niveles').append('<label>Niveles de Desempeño</label>');
                        $('#niveles').append(test);
                    }
                },
                error: function (exception) {
                    //alert(exception);
                }
            })
            ;
        }

function findEstandar(grado,asignatura,periodo) {
            
            $.ajax({
                type: 'POST',
                url: '".Url::to(['publica/findestandar'])."',
                data: {grado: grado, asignatura : asignatura, periodo:periodo},
                success: function (test) {
                    if(test != '')
                    {
                        $('#estandar').fadeIn(500); 
                        //$('#estandar').append('<label>Estandar</label>');
                        $('#estandar').html(test);
                    }
                },
                error: function (exception) {
                    //alert(exception);
                }
            })
            ;
        }        
");

?>
     <?php $form = ActiveForm::begin([
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                    ]
    ]); ?>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> <?= Yii::t('app', 'Información del Plan de Aula') ?></h3>
    </div>
    
        <?= $form->errorSummary($model); ?>

    <div class="panel-body" >

        <div class="col-sm-6">
            <?  
                if(Yii::$app->session->get('__tipo') == '2')
                {
                    $docente = Tercero::find()
                                ->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])
                                ->where(['id' => Yii::$app->session->get('__tercero'),'estado' => '5', 'tipo_tercero' => '2'])
                                ->orderBy('id')->asArray()->all();
                    $model->docente = Yii::$app->session->get('__tercero');
                }
                else
                {
                    $docente = Tercero::find()
                                ->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])
                                ->where(['estado' => '5', 'tipo_tercero' => '2'])
                                ->orderBy('id')->asArray()->all();
                }    

            ?>

             <?= $form->field($model, 'docente')->widget(Select2::classname(), [
                'data' => ArrayHelper::map($docente, 'id', 'nombre'),
                'options' => ['placeholder' => 'Seleccione...'],
                'hideSearch' => Yii::$app->session->get('__tipo') == '2' ? true : false,
                'pluginOptions' => [
                    'allowClear' => Yii::$app->session->get('__tipo') == '2' ? false : true,
                ],
            ]) ?>
        </div>   

        <div class="col-sm-6">
            <label>Fecha de Inicio y Fin</label>    
            
        <?php
            $addon = '<span class="input-group-addon">
                        <i class="glyphicon glyphicon-calendar"></i>
                    </span>';

            echo '<div class="input-group drp-container">';

            if ($model->isNewRecord)
            {
                date_default_timezone_set('America/Bogota');    
                $model->semana_inicio = date('Y-m-d', strtotime( 'monday this week' ) );
                $model->semana_fin = date('Y-m-d', strtotime( 'friday this week' ) );

                $model->rango = $model->semana_inicio." - ".$model->semana_fin;
            }    

            
            echo DateRangePicker::widget([
                'model'=>$model,
                'attribute' => 'rango',
                'useWithAddon'=>true,
                'autoUpdateOnInit'=>true,
                'convertFormat'=>true,
                'presetDropdown' => false,
                'startAttribute' => 'semana_inicio',
                'endAttribute' => 'semana_fin',
                'pluginOptions'=>[
                    'locale'=>[
                        'format' => 'Y-m-d',
                        'separator'=> ' al ',
                    ],
                    
                ]
            ]) . $addon;
            echo '</div>';
        ?>
    </div>

    <div style="clear:both"></div>

    <div class="col-sm-3">
        <?= $form->field($model, 'sede')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Sede::find()->orderBy('id')->asArray()->all(), 'id', 'sede'),
            'options' => ['placeholder' => 'Seleccione...'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]); ?>
    </div>
    <div class="col-sm-3">
        <?= $form->field($model, 'grado')->widget(Select2::classname(), [
            'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::getGradobyDocente(Yii::$app->session->get('__tercero')), 'id', 'grado'),
            'pluginOptions' => [
                'placeholder' => 'Seleccione...',
                'allowClear' => true,
            ],
        ]) ?>
    </div>
    <div class="col-sm-3">    
        <?= $form->field($model, 'grupo')->widget(DepDrop::classname(), [
            'type'=>DepDrop::TYPE_SELECT2,
            'data' => ArrayHelper::map(Grupo::find()->where(['=', 'grado', $model->grado])->orderBy('id')->asArray()->all(), 'id', 'grupo'),
            'options' => ['placeholder' => 'Seleccione...'],
            'select2Options' => ['pluginOptions' => ['multiple' => true]],
            'pluginOptions'=>[
                'placeholder'=>'Seleccione...',
                'depends'=>['planaula-sede','planaula-grado'],
                'url'=>Url::to(['publica/findgrupos']),
            ]
        ]);
        ?>  
    </div>

    <div class="col-sm-3">    
        <?= $form->field($model, 'asignatura')->widget(DepDrop::classname(), [
            'type'=>DepDrop::TYPE_SELECT2,
            'data' => ArrayHelper::map(Asignatura::find()->where(['=', 'grado', $model->grado])->orderBy('id')->asArray()->all(), 'id', 'asignatura'),
            //'options'=>['idasig' => 'id-asig', 'id'=>'asignatura-id'],
            'pluginOptions'=>[
                'placeholder'=>'Seleccione...',
                'depends'=>['planaula-grado','planaula-grupo'],
                'url'=>Url::to(['publica/findasignaturas']),
            ]
        ]);
        ?>  
    </div>

    <div style="clear:both"></div>

    <div class="col-sm-3"> 
        <?= $form->field($model, 'periodo')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Periodo::find()->where(['estado' => '1'])->orderBy('id')->asArray()->all(), 'id', 'periodo'),
            'pluginOptions' => [
                'placeholder' => 'Seleccione...',
                'allowClear' => true,
            ],
        ]) ?>
    </div>
    
    <div class="col-sm-6" id="competencia">
        <?= $form->field($model, 'competencia')->widget(DepDrop::classname(), [
            'type'=>DepDrop::TYPE_SELECT2,
            'data' => ArrayHelper::map(Competencia::find()->where(['=', 'asignatura', $model->asignatura])->andWhere(['=', 'periodo', $model->periodo])->orderBy('id')->asArray()->all(), 'id', 'competencia'),
            'pluginOptions'=>[
                'placeholder'=>'Seleccione...',
                'depends'=>['planaula-asignatura', 'planaula-periodo'],
                'url'=>Url::to(['publica/findcompetencias']),
            ]
        ]);
        ?> 
    </div>

    <div class="col-sm-3"> 
        <?= $form->field($model, 'metodo')->widget(Select2::classname(), [
            'data' => ['1' => 'Archivo', '0' =>'Manual'],
            'pluginOptions' => [
                'placeholder' => 'Seleccione...',
                'allowClear' => true,
            ],
        ]) ?>
    </div>
    
    <div style="clear:both;"></div>
    
    <div class="col-sm-12" id="guia" style="text-align: center; display:<?= $model->metodo == '1' ? 'block' : 'none'; ?>;">
        <?= Html::a('<i class="far fa-file-word" style="font-size:20px;"></i> '.Yii::t('app', 'Descargar Formato Guia Plan de Aula'), Url::toRoute('downloads/Plan_de_Aula.docx'), ['class' => 'btn btn-info', 'data-toggle' => 'tooltip', 'title' => Yii::t('app', 'Descargar Formato Guia Plan de Aula')]); ?>
    </div>

    <div style="clear:both;"></div>
    
    <div class="col-sm-12" id="adjunto" style="display:<?= $model->metodo == '1' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'adjunto')->widget(FileInput::classname(), [
            'options' => ['multiple'=>false],
            'pluginOptions'=>[
                //'uploadUrl' => Url::to(['/site/file-upload']),
                'allowedFileExtensions'=>['pdf','doc', 'docx'],
                'previewFileType' => 'any',
                'fadeInUpload' => false,
                'overwriteInitial' => false,
                'browseClass' => 'btn btn-primary',
                'uploadClass' => 'btn btn-success',
                'removeClass' => 'btn btn-danger',
                'removeIcon' => '<i class="glyphicon glyphicon-trash"></i>',
                ],
        ])->label('Adjuntos:'); ?> 
    </div>

    <div style="clear:both;"></div>

    <div id="estandar" class="col-sm-12" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;"></div>

    <div style="clear:both;"></div>

    <div id="niveles" class="col-sm-12" style="display:none;"></div>

    <div style="clear:both;"></div>
    
    <div class="col-sm-3" id="unidad" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">        
        
        <?= $form->field($model, 'unidad')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Unidad'],]);?>

    </div>    
    <div class="col-sm-6" id="nombre_unidad" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'nombre_unidad')->textInput(['maxlength' => true, 'placeholder' => 'Nombre Unidad']) ?>
    </div>    
    <div class="col-sm-3" id="horas" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'horas')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Horas'],]);?>
    </div>    

    <div style="clear:both"></div>

    <div class="col-sm-4" id="derechos" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'derechos')->textarea(['rows' => 6]) ?>
    </div>    
    <div class="col-sm-4" id="inicio" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'inicio')->textarea(['rows' => 6]) ?>
    </div>    
    <div class="col-sm-4" id="desarrollo" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'desarrollo')->textarea(['rows' => 6]) ?>
    </div>    

    <div style="clear:both"></div>

    <div class="col-sm-4" id="cierre" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'cierre')->textarea(['rows' => 6]) ?>
    </div>    
    <div class="col-sm-4" id="formativa" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'formativa')->textarea(['rows' => 6]) ?>
    </div>    
    <div class="col-sm-4" id="articulacion" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">     
        <?= $form->field($model, 'articulacion')->textarea(['rows' => 6]) ?>
    </div>    

    <div style="clear:both"></div>

    <div class="col-sm-4" id="recursos" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'recursos')->textarea(['rows' => 6]) ?>
    </div>    
    <div class="col-sm-4" id="reflexion" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'reflexion')->textarea(['rows' => 6]) ?>
    </div>    
    <div class="col-sm-4" id="observaciones" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'observaciones')->textarea(['rows' => 6]) ?>
    </div>    
        

    <? Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary', 'value'=>'Create', 'name'=>'submit']) ?>

    <?php ActiveForm::end(); ?>
    </div>
</div>
