<?php

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;
use kartik\popover\PopoverX;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\PlanaulaSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Planes de Aula';
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>

<div class="planaula-index">


    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>

        <?php 

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $asignaturas = \backend\models\Carga::find()->select(['asignatura.id as id', 'concat(asignatura.asignatura, " - " , grado.grado) as asignatura'])->joinWith(['asignaturas', 'asignaturas.grados'])->where(['docente' => Yii::$app->session->get('__tercero')])->asArray()->all();
        }
        else
        {
            $asignaturas = \backend\models\Carga::find()->select(['asignatura.id as id', 'asignatura.asignatura as asignatura'])->joinWith(['asignaturas'])->asArray()->all();   
        }

    $gridColumn = [
        ['class'=>'kartik\grid\SerialColumn', 'order'=>DynaGrid::ORDER_FIX_LEFT],
        [
            'class' => 'kartik\grid\ExpandRowColumn',
            'width' => '50px',
            'value' => function ($model, $key, $index, $column) {
                return GridView::ROW_COLLAPSED;
            },
            'detail' => function ($model, $key, $index, $column) {
                return Yii::$app->controller->renderPartial('_expand', ['model' => $model]);
            },
            'headerOptions' => ['class' => 'kartik-sheet-style'],
            'expandOneOnly' => true
        ],
        [
            'attribute' => 'docente',
            'label' => 'Docente',
            'width' => '250px',
            'value' => function($model){
                return $model->docentes->nombreinverso;
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['estado' => '5', 'tipo_tercero' => '2'])->asArray()->all(), 'id', 'nombre'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Docente', 'id' => 'grid-planaula-search-docente'],
            'visible' => Yii::$app->session->get('__tipo') == '2' ? false : true,
        ], 
        [
                'attribute' => 'semana_inicio',
                'label' => 'Semana Inicio',
                'filterType' => GridView::FILTER_DATE,
                'filterWidgetOptions' => [
                    'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true,'autoclose' => true,],
                ],
                'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-planaula-search-semana_inicio']
               
            ],
        [
                'attribute' => 'semana_fin',
                'label' => 'Semana Fin',
                'visible' => false,
                'filterType' => GridView::FILTER_DATE,
                'filterWidgetOptions' => [
                    'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true,'autoclose' => true,],
                ],
                'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-planaula-search-semana_inicio']
               
            ],     
        [
                'attribute' => 'grado',
                'label' => 'Grado',
                'value' => function($model){
                    return $model->grados->grado;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::getGradobyDocente(Yii::$app->session->get('__tercero')), 'id', 'grado'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-planaula-search-grado']
            ],
        [
                'attribute' => 'asignatura',
                'label' => 'Asignatura',
                'value' => function($model){
                    return $model->asignaturas->asignatura;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map($asignaturas, 'id', 'asignatura'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Asignatura', 'id' => 'grid-planaula-search-asignatura']
            ],
        [
                'attribute' => 'grupo',
                'label' => 'Grupo',
                'value' => function($model){
                    return $model->grupos->grupo;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->asArray()->all(), 'id', 'grupo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grupo', 'id' => 'grid-planaula-search-grupo']
            ],
        [   'attribute' => 'estandar',
            'visible' => false,
        ],    
        [
                'attribute' => 'periodo',
                'label' => 'Periodo',
                'value' => function($model){
                    return $model->periodos->periodo;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Periodo::find()->asArray()->all(), 'id', 'periodo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Periodo', 'id' => 'grid-planaula-search-periodo']
            ],
        [
                'attribute' => 'competencia',
                'label' => 'Competencia',
                'visible' => false,
                'value' => function($model){
                    return $model->competencias->competencia;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Competencia::find()->asArray()->all(), 'id', 'competencia'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Competencia', 'id' => 'grid-planaula-search-competencia']
            ],
        [
                'attribute' => 'unidad',
                'visible' => false,
        ],
        [
                'attribute' => 'nombre_unidad',
                'visible' => false,
                'width' => '300px',
        ],
        [
                'attribute' => 'horas',
                'visible' => false,
        ],
        [
                'attribute' => 'derechos',
                'visible' => false,
        ],
        [
                'attribute' => 'inicio',
                'visible' => false,
        ],
        [
                'attribute' => 'desarrollo',
                'visible' => false,
        ],
        [
                'attribute' => 'cierre',
                'visible' => false,
        ],
        [
                'attribute' => 'formativa',
                'visible' => false,
        ],
        [
                'attribute' => 'articulacion',
                'visible' => false,
        ],
        [
                'attribute' => 'recursos',
                'visible' => false,
        ],
        [
                'attribute' => 'reflexion',
                'visible' => false,
        ],
        [
                'attribute' => 'observaciones',
                'visible' => false,
        ],
        [
            'attribute' => 'adjunto',
            'label' => Yii::t('app', 'Adjunto'),
            'format' => 'raw',
            'value' => function($model){

                    if($model->metodo == '1')
                    {
                        $adjunto = json_decode(json_encode($model->adjunto),true);

                        //$adjunto["ObjectURL"]


                        $largo = strlen($adjunto["ObjectURL"]) - 46;
                        $archivo = substr($adjunto["ObjectURL"], 46, $largo);
                        $ext = substr($adjunto["ObjectURL"], -4);
                        
                        
                        switch ($ext) {
                            
                            case '.jpg':
                                    $icon = 'far fa-file-image';
                                break;

                            case '.png':
                                    $icon = 'far fa-file-image';
                                break; 

                            case '.gif':
                                    $icon = 'far fa-file-image';
                                break;       

                            case '.pdf':
                                    $icon = 'far fa-file-pdf';
                                break;
                            case '.xls':
                                    $icon = 'far fa-file-excel';
                                break;
                            case 'xlsx':
                                    $icon = 'far fa-file-excel';
                                break;
                            case '.csv':
                                    $icon = 'far fa-file-csv';
                                break;       
                            case 'docx':
                                    $icon = 'far fa-file-word';
                                break;
                            case '.doc':
                                    $icon = 'far fa-file-word';
                                break;
                            case 'pptx':
                                    $icon = 'far fa-file-powerpoint';
                                break;
                            case '.ppt':
                                    $icon = 'far fa-file-powerpoint';
                                break;
                                    
                            default:
                                    $icon = 'far fa-file';
                                break;
                        }
                            
                        return Html::a('<i class="'.$icon.'"></i> Descargar', Url::to($adjunto["ObjectURL"]), ['data-pjax'=>0, 'target' => '_blank', 'class' => 'btn btn-danger', 'title'=> urldecode($archivo)]);

                    }
                    else
                    {
                        return Html::a('<i class="far fa-file-pdf"></i> Descargar   ', ['pdf', 'id' => $model->id], ['class' => 'btn btn-xs btn-danger','title' => 'Descargar Plan de Aula','data-pjax' => '0']);
                    }

            }
        ],/*
        [
                'label' => '',
                'visible' => true,
                'format' => 'raw',
                'value' => function($model){
                    if($model->metodo == '1')
                    {
                        $archivo = unserialize($model->adjunto);
                        
                        return Html::a('<i class="fab fa-google-drive"></i> Descargar   ', Url::to('https://drive.google.com/open?id='.$archivo['id']), ['class' => 'btn btn-xs btn-primary', 'title' => 'Descargar Plan de Aula', 'target' => '_blank', 'data-pjax' => '0']);
                    }
                    else
                    {
                        return Html::a('<i class="far fa-file-pdf"></i> Descargar   ', ['pdf', 'id' => $model->id], ['class' => 'btn btn-xs btn-danger','title' => 'Descargar Plan de Aula','data-pjax' => '0']);
                    }
                },
                'hAlign'=>'center',
        ],*/
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle',
            'visible' => false
        ],
        [
            'class'=>'kartik\grid\ActionColumn',
        ],
    ]; 
    ?>
<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'plan-aula'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>


</div>
