<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;
use kartik\widgets\TouchSpin;
use kartik\daterange\DateRangePicker;

use backend\models\Sede;
use backend\models\Tercero;
use backend\models\Grado;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Competencia;


$this->registerJs("
    

$('#metodo-id').change(function(){
    
    if(this.value == '0')
    {
        $('#guia').fadeOut(500);
        $('#adjunto').fadeOut(500);
        $('#planmejoramiento-adjunto').value=''; 

        $('#tematica').fadeIn(500);
        $('#productivo').fadeIn(500);
        $('#cognitivo').fadeIn(500);
        $('#valorativo').fadeIn(500);
    }
    else
    {
        $('#tematica').fadeOut(500);
        $('#productivo').fadeOut(500);
        $('#cognitivo').fadeOut(500);
        $('#valorativo').fadeOut(500);
        $('#planmejoramiento-tematica').val('');  
        $('#planmejoramiento-productivo').val('');  
        $('#planmejoramiento-cognitivo').val('');  
        $('#planmejoramiento-valorativo').val('');

        $('#guia').fadeIn(500);
        $('#adjunto').fadeIn(500);
    }    
});


    $('#competencia-id').change(function()
    {
        $('#niveles').fadeOut(500);
        $('#niveles').html('');

        if(this.value!='')
        {    
            findNiveles(this.value);
        }
    });

    $('#competencia-id').change(function(){

        grado = $('#grado-id').val();
        asignatura = $('#asignatura-id').val();
        periodo = $('#periodo-id').val();
        
        //alert(grado+'-'+asignatura+'-'+periodo);

        //$('#estandar').fadeOut(500);
        //$('#estandar').html('');

        if(grado != '' && asignatura != '' && periodo != '')
        {
            //$('#estandar').fadeOut(500);
            //$('#estandar').html('');
            findEstandar(grado,asignatura,periodo);
        }    
    });

$('#grado-id').change(function(){
            $('#niveles').fadeOut(500);
            $('#niveles').html('');
            $('#estandar').fadeOut(500);
            $('#estandar').html('');

});

$('#asignatura-id').change(function(){
            $('#niveles').fadeOut(500);
            $('#niveles').html('');
            $('#estandar').fadeOut(500);
            $('#estandar').html('');

});

$('#periodo-id').change(function(){
            $('#niveles').fadeOut(500);
            $('#niveles').html('');
            $('#estandar').fadeOut(500);
            $('#estandar').html('');

});

function findNiveles(id) {
            
            $.ajax({
                type: 'POST',
                url: '".Url::to(['publica/findniveles'])."',
                data: {test: id},
                success: function (test) {
                    $('#niveles').fadeIn(500); 
                    $('#niveles').append('<label>Niveles de Desempeño</label>');
                    $('#niveles').append(test);

                },
                error: function (exception) {
                    //alert(exception);
                }
            })
            ;
        }

function findEstandar(grado,asignatura,periodo) {
            
            $('#estandar').fadeOut(500);
            $('#estandar').html('');
            
            $.ajax({
                type: 'POST',
                url: '".Url::to(['publica/findestandar'])."',
                data: {grado: grado, asignatura : asignatura, periodo:periodo},
                success: function (test) {
                    
                    $('#estandar').fadeIn(500); 
                    $('#estandar').append('<label>Estandar</label>');
                    $('#estandar').append(test);
                },
                error: function (exception) {
                    //alert(exception);
                }
            })
            ;
        }        
");

?>
     <?php $form = ActiveForm::begin([
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'enctype'=>'multipart/form-data', 
                      'id' => 'formulario']
    ]); ?>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> <?= Yii::t('app', 'Información del Plan de Mejoramiento') ?></h3>
    </div>
    
        <?= $form->errorSummary($model); ?>

    <div class="panel-body" >

        <div class="col-sm-6">
            <?  
                if(Yii::$app->session->get('__tipo') == '2')
                {
                    $docente = Tercero::find()
                                ->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])
                                ->where(['id' => Yii::$app->session->get('__tercero'),'estado' => '5', 'tipo_tercero' => '2'])
                                ->orderBy('id')->asArray()->all();
                    $model->docente = Yii::$app->session->get('__tercero');
                }
                else
                {
                    $docente = Tercero::find()
                                ->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])
                                ->where(['estado' => '5', 'tipo_tercero' => '2'])
                                ->orderBy('id')->asArray()->all();
                }    

            ?>

             <?= $form->field($model, 'docente')->widget(Select2::classname(), [
                'data' => ArrayHelper::map($docente, 'id', 'nombre'),
                'options' => ['placeholder' => 'Seleccione...'],
                'hideSearch' => Yii::$app->session->get('__tipo') == '2' ? true : false,
                'pluginOptions' => [
                    'allowClear' => Yii::$app->session->get('__tipo') == '2' ? false : true,
                ],
            ]) ?>
        </div>   

        <div class="col-sm-6">
            <label>Fecha de Inicio y Fin</label>    
            
        <?php
            $addon = '<span class="input-group-addon">
                        <i class="glyphicon glyphicon-calendar"></i>
                    </span>';

            echo '<div class="input-group drp-container">';

            if ($model->isNewRecord)
            {
                date_default_timezone_set('America/Bogota');    
                $model->fecha_inicio = date('Y-m-d', strtotime( 'monday this week' ) );
                $model->fecha_fin = date('Y-m-d', strtotime( 'friday this week' ) );

            }

            $model->rango = $model->fecha_inicio." - ".$model->fecha_fin;


            
            echo DateRangePicker::widget([
                'model'=>$model,
                'attribute' => 'rango',
                'useWithAddon'=>true,
                'autoUpdateOnInit'=>true,
                'convertFormat'=>true,
                'presetDropdown' => false,
                'startAttribute' => 'fecha_inicio',
                'endAttribute' => 'fecha_fin',
                'pluginOptions'=>[
                    'locale'=>[
                        'format' => 'Y-m-d',
                        'separator'=> ' al ',
                    ],
                    
                ]
            ]) . $addon;
            echo '</div>';
        ?>
    </div>

    <div style="clear:both"></div>

    <div class="col-sm-3">
        <?= $form->field($model, 'sede')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Sede::find()->orderBy('id')->asArray()->all(), 'id', 'sede'),
            'options' => ['id' => 'sede-id', 'placeholder' => 'Seleccione...'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]); ?>
    </div>
    <div class="col-sm-3">
        <?= $form->field($model, 'grado')->widget(Select2::classname(), [
            'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::getGradobyDocente(Yii::$app->session->get('__tercero')), 'id', 'grado'),
            'options' => ['id' => 'grado-id', 'placeholder' => 'Seleccione...'],
            'pluginOptions' => [
                'allowClear' => true,
            ],
        ]) ?>
    </div>
    <div class="col-sm-3">    
        <?= $form->field($model, 'grupo')->widget(DepDrop::classname(), [
            'type'=>DepDrop::TYPE_SELECT2,
            'data' => ArrayHelper::map(Grupo::find()->where(['=', 'grado', $model->grado])->orderBy('id')->asArray()->all(), 'id', 'grupo'),
            'options' => ['id' => 'grupo-id', 'placeholder' => 'Seleccione...'],
            'select2Options' => ['pluginOptions' => ['multiple' => true]],
            'pluginOptions'=>[
                'depends'=>['sede-id','grado-id'],
                'url'=>Url::to(['publica/findgrupos']),
            ]
        ]);
        ?>  
    </div>

    <div class="col-sm-3">    
        <?= $form->field($model, 'asignatura')->widget(DepDrop::classname(), [
            'type'=>DepDrop::TYPE_SELECT2,
            'data' => ArrayHelper::map(Asignatura::find()->where(['=', 'grado', $model->grado])->orderBy('id')->asArray()->all(), 'id', 'asignatura'),
            'options' => ['id' => 'asignatura-id', 'placeholder' => 'Seleccione...'],
            'pluginOptions'=>[
                'depends'=>['grado-id'],
                'url'=>Url::to(['publica/findasignaturas']),
            ]
        ]);
        ?>  
    </div>

    <div style="clear:both"></div>

    <div class="col-sm-3"> 
        <?= $form->field($model, 'periodo')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Periodo::find()->where(['estado' => '1'])->orderBy('id')->asArray()->all(), 'id', 'periodo'),
            'options' => ['id' => 'periodo-id', 'placeholder' => 'Seleccione...'],
            'pluginOptions' => [
                'placeholder' => 'Seleccione el Periodo',
                'allowClear' => true,
            ],
        ]) ?>
    </div>

    <div class="col-sm-6">
        <?= $form->field($model, 'competencia')->widget(DepDrop::classname(), [
            'type'=>DepDrop::TYPE_SELECT2,
            'data' => ArrayHelper::map(Competencia::find()->where(['=', 'asignatura', $model->asignatura])->andWhere(['=', 'periodo', $model->periodo])->orderBy('id')->asArray()->all(), 'id', 'competencia'),
            'options' => ['id' => 'competencia-id', 'placeholder' => 'Seleccione...'],
            'pluginOptions'=>[
                'depends'=>['asignatura-id', 'periodo-id'],
                'url'=>Url::to(['publica/findcompetencias']),
            ]
        ]);
        ?> 
    </div>

    <div class="col-sm-3"> 
        <?= $form->field($model, 'metodo')->widget(Select2::classname(), [
            'data' => ['1' => 'Archivo', '0' =>'Manual'],
            'options' => ['id' => 'metodo-id'],
            'pluginOptions' => [
                'placeholder' => 'Seleccione...',
                'allowClear' => true,
            ],
        ]) ?>
    </div>

    <div style="clear:both;"></div>

    <div id="estandar" class="col-sm-12" style="display:block;"></div>

    <div style="clear:both;"></div>

    <div id="niveles" class="col-sm-12" style="display:block;"></div>

    <div style="clear:both;"></div>
    
    <div class="col-sm-12" id="guia" style="text-align: center; display:<?= $model->metodo == '1' ? 'block' : 'none'; ?>;">
        <?= Html::a('<i class="far fa-file-word" style="font-size:20px;"></i> '.Yii::t('app', 'Descargar Formato Guia Plan de Aula'), Url::toRoute('downloads/Plan_de_Aula.docx'), ['class' => 'btn btn-info', 'data-toggle' => 'tooltip', 'title' => Yii::t('app', 'Descargar Formato Guia Plan de Aula')]); ?>
    </div>

    <div style="clear:both;"></div>
    
    <div class="col-sm-12" id="adjunto" style="display:<?= $model->metodo == '1' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'adjunto')->widget(FileInput::classname(), [
            'options' => ['multiple'=>false],
            'pluginOptions'=>[
                //'uploadUrl' => Url::to(['/site/file-upload']),
                'allowedFileExtensions'=>['pdf','doc', 'docx'],
                'previewFileType' => 'any',
                'fadeInUpload' => false,
                'overwriteInitial' => false,
                'browseClass' => 'btn btn-primary',
                'uploadClass' => 'btn btn-success',
                'removeClass' => 'btn btn-danger',
                'removeIcon' => '<i class="glyphicon glyphicon-trash"></i>',
                ],
        ])->label('Adjuntos:'); ?> 
    </div>

    <div style="clear:both;"></div>
 
    <div class="col-sm-6" id="tematica" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'tematica')->textarea(['rows' => 4]) ?>
    </div>    

    <div class="col-sm-6" id="productivo" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'productivo')->textarea(['rows' => 4]) ?>
    </div>    

    <div style="clear:both"></div>

    <div class="col-sm-6" id="cognitivo" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'cognitivo')->textarea(['rows' => 4]) ?>
    </div>    

    <div class="col-sm-6" id="valorativo" style="display:<?= $model->metodo == '0' ? 'block' : 'none'; ?>;">
        <?= $form->field($model, 'valorativo')->textarea(['rows' => 4]) ?>
    </div>    

     
        
    <div style="clear:both"></div>

    <div class="col-sm-12">
        <?= $form->field($model, 'observaciones')->textarea(['rows' => 4]) ?>
    </div>

    <div class="col-sm-12">     
        
        <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

        <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
            'size' => 'medium',
            'onColor' => 'success',
            'offColor' => 'danger',
            'onText'=>'Activo',
            'offText'=>'Inactivo'
        ]]) 
        ?>
    </div>

    <? Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary', 'value'=>'Create', 'name'=>'submit']) ?>

    <?php ActiveForm::end(); ?>
    </div>
</div>
