<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model backend\models\PlanmejoramientoSearch */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="form-planmejoramiento-search">

    <?php $form = ActiveForm::begin([
        'action' => ['index'],
        'method' => 'get',
    ]); ?>

    <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

    <?= $form->field($model, 'docente')->widget(\kartik\widgets\Select2::classname(), [
        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
        'options' => ['placeholder' => 'Choose Tercero'],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]); ?>

    <?= $form->field($model, 'fecha_inicio')->widget(\kartik\datecontrol\DateControl::classname(), [
        'type' => \kartik\datecontrol\DateControl::FORMAT_DATE,
        'saveFormat' => 'php:Y-m-d',
        'ajaxConversion' => true,
        'options' => [
            'pluginOptions' => [
                'placeholder' => 'Choose Fecha Inicio',
                'autoclose' => true
            ]
        ],
    ]); ?>

    <?= $form->field($model, 'fecha_fin')->widget(\kartik\datecontrol\DateControl::classname(), [
        'type' => \kartik\datecontrol\DateControl::FORMAT_DATE,
        'saveFormat' => 'php:Y-m-d',
        'ajaxConversion' => true,
        'options' => [
            'pluginOptions' => [
                'placeholder' => 'Choose Fecha Fin',
                'autoclose' => true
            ]
        ],
    ]); ?>

    <?= $form->field($model, 'grado')->widget(\kartik\widgets\Select2::classname(), [
        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->orderBy('id')->asArray()->all(), 'id', 'grado'),
        'options' => ['placeholder' => 'Choose Grado'],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]); ?>

    <?php /* echo $form->field($model, 'asignatura')->widget(\kartik\widgets\Select2::classname(), [
        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Asignatura::find()->orderBy('id')->asArray()->all(), 'id', 'asignatura'),
        'options' => ['placeholder' => 'Choose Asignatura'],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]); */ ?>

    <?php /* echo $form->field($model, 'grupo')->widget(\kartik\widgets\Select2::classname(), [
        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->orderBy('id')->asArray()->all(), 'id', 'grupo'),
        'options' => ['placeholder' => 'Choose Grupo'],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]); */ ?>

    <?php /* echo $form->field($model, 'periodo')->widget(\kartik\widgets\Select2::classname(), [
        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Periodo::find()->orderBy('id')->asArray()->all(), 'id', 'periodo'),
        'options' => ['placeholder' => 'Choose Periodo'],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]); */ ?>

    <?php /* echo $form->field($model, 'competencia')->widget(\kartik\widgets\Select2::classname(), [
        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Competencia::find()->orderBy('id')->asArray()->all(), 'id', 'competencia'),
        'options' => ['placeholder' => 'Choose Competencia'],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]); */ ?>

    <?php /* echo $form->field($model, 'tematica')->textarea(['rows' => 6]) */ ?>

    <?php /* echo $form->field($model, 'productivo')->textarea(['rows' => 6]) */ ?>

    <?php /* echo $form->field($model, 'cognitivo')->textarea(['rows' => 6]) */ ?>

    <?php /* echo $form->field($model, 'valorativo')->textarea(['rows' => 6]) */ ?>

    <?php /* echo $form->field($model, 'observaciones')->textarea(['rows' => 6]) */ ?>

    <?php /* echo $form->field($model, 'adjunto')->textInput(['maxlength' => true, 'placeholder' => 'Adjunto']) */ ?>

    <?php /* echo $form->field($model, 'estado')->textInput(['placeholder' => 'Estado']) */ ?>

    <div class="form-group">
        <?= Html::submitButton('Search', ['class' => 'btn btn-primary']) ?>
        <?= Html::resetButton('Reset', ['class' => 'btn btn-default']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
