<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\PlanmejoramientoSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;


$this->title = 'Plan de Mejoramiento';
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="planmejoramiento-index">

    
    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    
    <?php 

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $asignaturas = \backend\models\Carga::find()->select(['asignatura.id as id', 'concat(asignatura.asignatura, " - " , grado.grado) as asignatura'])->joinWith(['asignaturas', 'asignaturas.grados'])->where(['docente' => Yii::$app->session->get('__tercero')])->asArray()->all();
        }
        else
        {
            $asignaturas = \backend\models\Carga::find()->select(['asignatura.id as id', 'asignatura.asignatura as asignatura'])->joinWith(['asignaturas'])->asArray()->all();   
        }


    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'docente',
            'label' => 'Docente',
            'width' => '250px',
            'value' => function($model){                   
                return $model->docentes->nombreinverso;
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['estado' => '5', 'tipo_tercero' => '2'])->asArray()->all(), 'id', 'nombre'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-planmejoramiento-search-docente'],
            'visible' => Yii::$app->session->get('__tipo') == '2' ? false : true,
        ],
        [
            'attribute' => 'fecha_inicio',
            'label' => 'Fecha Inicio',
            'filterType' => GridView::FILTER_DATE,
            'filterWidgetOptions' => [
                'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true,'autoclose' => true,],
            ],
            'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-planaula-search-fecha_inicio']
           
        ],
        [
            'attribute' => 'fecha_fin',
            'label' => 'Fecha Fin',
            'visible' => false,
            'filterType' => GridView::FILTER_DATE,
            'filterWidgetOptions' => [
                'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true,'autoclose' => true,],
            ],
            'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-planaula-search-fecha_inicio']
           
        ],    
        [
            'attribute' => 'grado',
            'label' => 'Grado',
            'value' => function($model){                   
                return $model->grados->grado;                   
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::getGradobyDocente(Yii::$app->session->get('__tercero')), 'id', 'grado'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-planmejoramiento-search-grado']
        ],
        [
            'attribute' => 'asignatura',
            'label' => 'Asignatura',
            'value' => function($model){                   
                return $model->asignaturas->asignatura;                   
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map($asignaturas, 'id', 'asignatura'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Asignatura', 'id' => 'grid-planmejoramiento-search-asignatura']
        ],
        [
            'attribute' => 'grupo',
            'label' => 'Grupo',
            'value' => function($model){                   
                return $model->grupos->grupo;                   
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->asArray()->all(), 'id', 'grupo'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Grupo', 'id' => 'grid-planmejoramiento-search-grupo']
        ],
        [
            'attribute' => 'periodo',
            'label' => 'Periodo',
            'value' => function($model){                   
                return $model->periodos->periodo;                   
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Periodo::find()->asArray()->all(), 'id', 'periodo'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Periodo', 'id' => 'grid-planmejoramiento-search-periodo']
        ],
        [
            'attribute' => 'competencia',
            'label' => 'Competencia',
            'value' => function($model){                   
                return $model->competencias->competencia;                   
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Competencia::find()->asArray()->all(), 'id', 'competencia'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Competencia', 'id' => 'grid-planmejoramiento-search-competencia'],
            'visible' => false,
        ],
        [
            'attribute' => 'tematica',
            'visible' => false,
        ],
        [
            'attribute' => 'productivo',
            'visible' => false,
        ],
        [
            'attribute' => 'cognitivo',
            'visible' => false,
        ],
        [
            'attribute' => 'valorativo',
            'visible' => false,
        ],
        [
            'attribute' => 'observaciones',
            'visible' => false,
        ],
        [
            'attribute' => 'adjunto',
            'label' => Yii::t('app', 'Adjunto'),
            'format' => 'raw',
            'value' => function($model){

                    if($model->metodo == '1')
                    {
                        $adjunto = json_decode(json_encode($model->adjunto),true);

                        //$adjunto["ObjectURL"]


                        $largo = strlen($adjunto["ObjectURL"]) - 46;
                        $archivo = substr($adjunto["ObjectURL"], 46, $largo);
                        $ext = substr($adjunto["ObjectURL"], -4);
                        
                        
                        switch ($ext) {
                            
                            case '.jpg':
                                    $icon = 'far fa-file-image';
                                break;

                            case '.png':
                                    $icon = 'far fa-file-image';
                                break; 

                            case '.gif':
                                    $icon = 'far fa-file-image';
                                break;       

                            case '.pdf':
                                    $icon = 'far fa-file-pdf';
                                break;
                            case '.xls':
                                    $icon = 'far fa-file-excel';
                                break;
                            case 'xlsx':
                                    $icon = 'far fa-file-excel';
                                break;
                            case '.csv':
                                    $icon = 'far fa-file-csv';
                                break;       
                            case 'docx':
                                    $icon = 'far fa-file-word';
                                break;
                            case '.doc':
                                    $icon = 'far fa-file-word';
                                break;
                            case 'pptx':
                                    $icon = 'far fa-file-powerpoint';
                                break;
                            case '.ppt':
                                    $icon = 'far fa-file-powerpoint';
                                break;
                                    
                            default:
                                    $icon = 'far fa-file';
                                break;
                        }
                            
                        return Html::a('<i class="'.$icon.'"></i> Descargar', Url::to($adjunto["ObjectURL"]), ['data-pjax'=>0, 'target' => '_blank', 'class' => 'btn btn-danger', 'title'=> urldecode($archivo)]);

                    }
                    else
                    {
                        return Html::a('<i class="far fa-file-pdf"></i> Descargar   ', ['pdf', 'id' => $model->id], ['class' => 'btn btn-xs btn-danger','title' => 'Descargar Plan de Aula','data-pjax' => '0']);
                    }

            }
        ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle',
            'visible' => false
        ],  
        [
            'class'=>'kartik\grid\ActionColumn',
        ],
        ['class'=>'kartik\grid\CheckboxColumn',  'order'=>DynaGrid::ORDER_FIX_RIGHT],
    ]; 
    ?>

<?php
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'plan-mejoramiento'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>
</div>
