<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Planmejoramiento */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Planmejoramiento', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="planmejoramiento-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Planmejoramiento'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'docente0.id',
            'label' => 'Docente',
        ],
        'fecha_inicio',
        'fecha_fin',
        [
            'attribute' => 'grado0.grado',
            'label' => 'Grado',
        ],
        [
            'attribute' => 'asignatura0.asignatura',
            'label' => 'Asignatura',
        ],
        [
            'attribute' => 'grupo0.grupo',
            'label' => 'Grupo',
        ],
        [
            'attribute' => 'periodo0.periodo',
            'label' => 'Periodo',
        ],
        [
            'attribute' => 'competencia0.competencia',
            'label' => 'Competencia',
        ],
        'tematica:ntext',
        'productivo:ntext',
        'cognitivo:ntext',
        'valorativo:ntext',
        'observaciones:ntext',
        'adjunto',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    <div class="row">
        <h4>Tercero<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnTercero = [
        ['attribute' => 'id', 'visible' => false],
        'identificacion',
        'tipo',
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        'genero',
        'tipo_tercero',
        'fecha_nacimiento',
        'departamento_nacimiento',
        'municipio_nacimiento',
        'pais',
        'rh',
        'religion',
        'etnia',
        'eps',
        'direccion',
        'departamento_residencia',
        'municipio_residencia',
        'barrio',
        'fijo',
        'movil',
        'email',
        'foto',
        'firma',
        'estrato',
        'situacion',
        'codigo_desplazado',
        'departamento_desplazado',
        'municipio_desplazado',
        'codigo_sisben',
        'codigo_familia_accion',
        'capacidad',
        'medicamentos',
        'alergias',
        'discapacidad',
        'discapacidad_certificada',
        'subsidio',
        'recurso',
        'bienestar',
        'heroe',
        'fuerza_publica',
        'sector',
        'resguardo',
        'departamento_resguardo',
        'cabeza_familia',
        'activo',
        [
            'attribute' => 'estado0.id',
            'label' => 'Estado',
        ],
        'bloqueo',
    ];
    echo DetailView::widget([
        'model' => $model->docente0,
        'attributes' => $gridColumnTercero    ]);
    ?>
    <div class="row">
        <h4>Grado<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnGrado = [
        ['attribute' => 'id', 'visible' => false],
        'codigo',
        'tipo_calificacion',
        'calificacionxcompetencia',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->grado0,
        'attributes' => $gridColumnGrado    ]);
    ?>
    <div class="row">
        <h4>Grupo<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnGrupo = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'grado0.grado',
            'label' => 'Grado',
        ],
        'director',
        'jornada',
        'sede',
        'metodologia',
        'modalidad',
        'especialidad',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->grupo0,
        'attributes' => $gridColumnGrupo    ]);
    ?>
    <div class="row">
        <h4>Asignatura<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnAsignatura = [
        ['attribute' => 'id', 'visible' => false],
        'codigo',
        'intensidad',
        [
            'attribute' => 'grado0.grado',
            'label' => 'Grado',
        ],
        'area',
        'especialidad',
        'num_calificaciones_saber',
        'por_calificaciones_saber',
        'num_calificaciones_ser',
        'por_calificaciones_ser',
        'por_asig_area',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->asignatura0,
        'attributes' => $gridColumnAsignatura    ]);
    ?>
    <div class="row">
        <h4>Competencia<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnCompetencia = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'grado0.grado',
            'label' => 'Grado',
        ],
        [
            'attribute' => 'asignatura0.asignatura',
            'label' => 'Asignatura',
        ],
        [
            'attribute' => 'periodo0.periodo',
            'label' => 'Periodo',
        ],
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->competencia0,
        'attributes' => $gridColumnCompetencia    ]);
    ?>
    <div class="row">
        <h4>Periodo<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnPeriodo = [
        ['attribute' => 'id', 'visible' => false],
        'fecha_inicio',
        'fecha_fin',
        'habilitado',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->periodo0,
        'attributes' => $gridColumnPeriodo    ]);
    ?>
</div>
