<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\ColorInput;
use kartik\widgets\DateTimePicker;
use kartik\widgets\Select2;
use kartik\widgets\FileInput;
use kartik\widgets\TouchSpin;
use dosamigos\tinymce\TinyMce;

$this->registerCss("
    .tox .tox-editor-header
    {
        z-index: 0 !important;
    }
");

?>

<?php $form = ActiveForm::begin([
    //'validateOnSubmit' => true,
    'type' => ActiveForm::TYPE_VERTICAL,
    'options' => ['class' => 'main-task-form',
                  'id' => 'formulario',
                  'enctype'=>'multipart/form-data',
                ]
]); ?>

<div class="enlace-form">

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del PQRSD: <?= $model->id ?></h3>
    </div>

    <div class="panel-body" >

        <?= $form->errorSummary($model); ?>

        <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
        <?= $form->field($model, 'tercero', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

    <div class="col-sm-2">
        <label>Tipo</label><br>
        <?= $model->tipos->tipo ?>

        <?= $form->field($model, 'tipo', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
    </div>       

    <div class="col-sm-10">
        <label>Asunto</label><br>
        <?= $model->asunto ?>

        <?= $form->field($model, 'asunto', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
    </div>             

    <div class="col-sm-12">     
        <label>Mensaje</label><br>
        <?= $model->mensaje ?>

        <?= $form->field($model, 'mensaje', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

    </div>
    
    <div class="col-sm-12">
        <?php
            if ($model->adjunto_solicitud)
            {
                
                $adjuntos = explode(',', $model->adjunto_solicitud); 
                
                echo "<label>Total de Adjuntos: ".count($adjuntos)."</label><br>";

                foreach ($adjuntos as $adjunto) 
                { 
                    $archivo = unserialize($adjunto);
                    
                    echo '<a href="https://drive.google.com/open?id='.$archivo['id'].'" target="_blank">';
                    echo '<i class="fas fa-unlink text-primary"></i>&nbsp; &nbsp;'.$archivo["file"].'</a><br>';
                }
                
                
            }
            else
            {
                echo '<i class="fas fa-unlink text-danger"></i>';
            }
        ?>

        <?= $form->field($model, 'adjunto_solicitud', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
        

    </div>       
   
    <div class="col-sm-12"><hr></div>

    <div class="col-sm-12">     
        <?= $form->field($model, 'respuesta')->widget(TinyMce::className(), [
            'options' => ['rows' => 15],
            'language' => 'es',
            'clientOptions' => [
                'plugins' => [
                    "advlist autolink lists link charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media image table contextmenu paste"
                ],
                'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
            ]
        ])->label();?>
    </div>       

    <div class="col-sm-12">     

        <?= $form->field($model, 'adjunto_respuesta[]')->widget(FileInput::classname(), [
            'options' => ['multiple'=>true],
            'pluginOptions'=>[
                //'uploadUrl' => Url::to(['/site/file-upload']),
                //'allowedFileExtensions'=>['jpg', 'gif', 'png', 'bmp','pdf','doc', 'docx','xls'],
                'previewFileType' => 'any',
                'showUpload' => false,
                'overwriteInitial' => false,
                'browseClass' => 'btn btn-primary',
                'uploadClass' => 'btn btn-success',
                'removeClass' => 'btn btn-danger',
                'removeIcon' => '<i class="glyphicon glyphicon-trash"></i>',
                ],
        ])->label('Adjuntos:'); ?>

    </div>           

    <div class="col-sm-3">     
        
        <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
            'size' => 'medium',
            'onColor' => 'success',
            'offColor' => 'danger',
            'onText'=>'Resuelto',
            'offText'=>'Sin Resolver'
        ]]) 
        ?>
    </div>


    </div>
</div>

    <?php ActiveForm::end(); ?>

</div>