<?php 

use yii\helpers\Html;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;

/* @var $searchModel backend\models\MunicipioSearch */


$this->title = 'PQRSD';
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];


$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="pqrsd-index">

    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        [
            'attribute' => 'id', 
            'label' => Yii::t('app', 'PQRSD'),
            'value' => function($model){
                    return Html::a($model->id, ['pqrsd/view', 'id' => $model->id]);
            },
            'vAlign' => 'middle',
            'format' => 'raw',
            'headerOptions' => ['style' => 'width:5%'],
            'visible' => true,
        ],
        [
            'attribute' => 'tipo',
            'label' => Yii::t('app', 'Tipo'),
            'value' => function($model){
                if ($model->tipos)
                {
                    
                    return "<span class='badge' style='background-color: {$model->tipos->color}'> </span>  <code>" . $model->tipos->tipo . '</code>';
                }
                else
                {return NULL;}
            },
            'vAlign' => 'middle',
            'format' => 'raw',
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tipopqrsd::find()->asArray()->all(), 'id', 'tipo'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Tipo', 'id' => 'grid-pqrsd-search-tipo'],
            'headerOptions' => ['style' => 'width:10%'],
        ],
        [
            'attribute' => 'asunto',
            'label' => Yii::t('app', 'Asunto'),
            'value' => function($model){
                    return Html::a($model->asunto, ['pqrsd/view', 'id' => $model->id]);
            },
            'vAlign' => 'middle',
            'format' => 'raw',
        ],
        [
            'attribute' => 'tercero',
            'label' => Yii::t('app', 'Tercero'),
            'value' => function($model){
                if ($model->terceros)
                {return $model->terceros->nombre;}
                else
                {return NULL;}
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_nombre,' ', segundo_nombre,' ',primer_apellido,' ',segundo_apellido) as nombre")])->where(['estado' => '1', 'tipo_tercero' => '1'])->asArray()->all(), 'id', 'nombre'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-pqrsd-search-tercero'],
            'visible' => false,
        ],
        
        [
                'attribute' => 'mensaje',
                'label' => Yii::t('app', 'Mensaje'),
                'format' => 'raw',
                'value' => function($model){
                    return substr($model->mensaje, 0, 100);
                },
                'visible' => true,
        ],
        //'adjunto_solicitud',
        [
            'attribute'=>'adjunto_solicitud', 
            //'vAlign'=>'middle',
            'value' => function($model){
                if ($model->adjunto_solicitud)
                {
                    
                    $adjuntos = explode(',', $model->adjunto_solicitud); 
                    //$adjuntos_cantidad = count($adjuntos);

                    $html ='';

                    foreach ($adjuntos as $adjunto) 
                    { 
                        $archivo = unserialize($adjunto);
                        
                        $html .= '<a href="https://drive.google.com/open?id='.$archivo['id'].'" target="_blank">';
                        $html .= '<i class="fas fa-unlink text-primary"></i>&nbsp; &nbsp;'.$archivo["file"].'</a><br>';
                    }
                    
                    return $html;
                }
                else
                {
                    return '<i class="fas fa-unlink text-danger"></i>';
                }
            },
            'format' => 'raw',
            'visible' => true,
        ],
        [
                'attribute' => 'respuesta',
                'label' => Yii::t('app', 'Respuesta'),
                'format' => 'raw',
                'value' => function($model){
                    return substr($model->respuesta, 0, 100);
                },
                'visible' => true,
        ],
        [
            'attribute'=>'adjunto_respuesta', 
            //'vAlign'=>'middle',
            'value' => function($model){
                if ($model->adjunto_respuesta)
                {
                    
                    $adjuntos = explode(',', $model->adjunto_respuesta); 
                    //$adjuntos_cantidad = count($adjuntos);

                    $html ='';

                    foreach ($adjuntos as $adjunto) 
                    { 
                        $archivo = unserialize($adjunto);
                        
                        $html .= '<a href="https://drive.google.com/open?id='.$archivo['id'].'" target="_blank">';
                        $html .= '<i class="fas fa-unlink text-primary"></i>&nbsp; &nbsp;'.$archivo["file"].'</a><br>';
                    }
                    
                    return $html;
                }
                else
                {
                    return '<i class="fas fa-unlink text-danger"></i>';
                }
            },
            'format' => 'raw',
            'visible' => true,
        ],
        //'respuesta',
        //'adjunto_respuesta',
        //'visto',
        [
            'attribute' => 'creado_el',
            'label' => Yii::t('app', 'Creado'),
            'filterType' => GridView::FILTER_DATE,
            'filterWidgetOptions' => [
                'language' => 'es',
                'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true,'autoclose' => true],
            ],
            'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-observador-search-fecha']
           
        ],
        [
            'attribute' => 'actualizado_el',
            'label' => Yii::t('app', 'Actualizado'),
            'filterType' => GridView::FILTER_DATE,
            'filterWidgetOptions' => [
                'language' => 'es',
                'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true,'autoclose' => true],
            ],
            'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-observador-search-fecha']
           
        ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class'=>'kartik\grid\ActionColumn',
            'dropdown'=>false,
            'order'=>DynaGrid::ORDER_FIX_RIGHT,
        ],
    ]; 
    ?>


<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'pqrsd'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>
</div>
