<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Pqrsd */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Pqrsd'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="pqrsd-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Pqrsd').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'tercero0.id',
            'label' => Yii::t('app', 'Tercero'),
        ],
        'asunto',
        [
            'attribute' => 'tipo0.id',
            'label' => Yii::t('app', 'Tipo'),
        ],
        'mensaje:ntext',
        'adjunto_solicitud:ntext',
        'respuesta:ntext',
        'adjunto_respuesta:ntext',
        'visto',
        'visto_el',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    <div class="row">
        <h4>Tercero<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnTercero = [
        ['attribute' => 'id', 'visible' => false],
        'identificacion',
        [
            'attribute' => 'tipo0.id',
            'label' => Yii::t('app', 'Tipo'),
        ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        'genero',
        'tipo_tercero',
        'razon_social',
        'nit',
        'fecha_inscripcion',
        'departamento',
        'municipio',
        'pais',
        'direccion',
        'fijo',
        'movil',
        'email',
        'ciiu_1',
        'ciiu_2',
        'ciiu_3',
        'ciiu_4',
        'activo_corriente',
        'activo_total',
        'pasivo_corriente',
        'pasivo_total',
        'patrimonio',
        'utilidad_perdida',
        'gasto_intereses',
        'indice_liquidez',
        'indice_endeudamiento',
        'razon_cobertura',
        'rentabilidad_patrimonio',
        'rentabilidad_activo',
        'foto',
        'adjunto',
        'activo',
        [
            'attribute' => 'estado0.id',
            'label' => Yii::t('app', 'Estado'),
        ],
        'bloqueo',
    ];
    echo DetailView::widget([
        'model' => $model->tercero0,
        'attributes' => $gridColumnTercero    ]);
    ?>
    <div class="row">
        <h4>TipoPqrsd<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnTipoPqrsd = [
        ['attribute' => 'id', 'visible' => false],
        'color',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->tipo0,
        'attributes' => $gridColumnTipoPqrsd    ]);
    ?>
</div>
