<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Pqrsd */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Pqrsd'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="pqrsd-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Pqrsd').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'terceros.id',
            'label' => Yii::t('app', 'Tercero'),
        ],
        'asunto',
        [
            'attribute' => 'tipos.tipo',
            'label' => Yii::t('app', 'Tipo'),
        ],
        'mensaje:ntext',
        'adjunto_solicitud:ntext',
        'respuesta:ntext',
        'adjunto_respuesta:ntext',
        'visto',
        'visto_el',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    
</div>
