<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DateTimePicker;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use yii\helpers\Json;
//use mdm\admin\AnimateAsset;
use yii\web\YiiAsset;

use backend\models\Tercero;
use backend\models\Grado;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Momento;
use backend\models\ClaseObservacionObservador;
use backend\models\TipoobservacionObservador;
use dosamigos\tinymce\TinyMce;


$this->registerCss("
.glyphicon-refresh-animate {
    -animation: spin .7s infinite linear;
    -ms-animation: spin .7s infinite linear;
    -webkit-animation: spinw .7s infinite linear;
    -moz-animation: spinm .7s infinite linear;
}

@keyframes spin {
    from { transform: scale(1) rotate(0deg);}
    to { transform: scale(1) rotate(360deg);}
}
  
@-webkit-keyframes spinw {
    from { -webkit-transform: rotate(0deg);}
    to { -webkit-transform: rotate(360deg);}
}

@-moz-keyframes spinm {
    from { -moz-transform: rotate(0deg);}
    to { -moz-transform: rotate(360deg);}
}
");

//AnimateAsset::register($this);
//YiiAsset::register($this);

$opts = Json::htmlEncode([
    'estudiantes' => $estudiantes
]);
$this->registerJs("var _opts = {$opts};");
$this->registerJs($this->render('_bloquear_boletines.js'));

$animateIcon = ' <i class="glyphicon glyphicon-refresh glyphicon-refresh-animate"></i>';

$this->registerJs("
    
    $('#add').click(function() { return !$('#avaliable option:selected').remove().appendTo('#assigned'); });  
    $('#remove').click(function() { return !$('#assigned option:selected').remove().appendTo('#avaliable'); });
    
   // $('.submit').click(function() { $('#assigned option').prop('selected', 'selected'); });

");


//print_r($estudiantes);
//var_dump($estudiantes);
?>

<div class="row">
    
     <?php $form = ActiveForm::begin([
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                    ]
    ]); ?>
        
        <div class="col-sm-12">
            <div class="alert alert-info">
              <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
              <i class="fa fa-info-circle fa-lg"></i> <strong>Información!</strong> Seleccione uno o más estudiantes para bloquear la descarga del informe valorativo del estudiante, para seleccionarlo puede buscarlo por la casilla <em>Buscar estudiante</em> selecciona uno o más y haces click al botón verde para bloquear. Así mismo puedes desbloquear el estudiante con el botón rojo.
            </div>
        </div>


        

    <div class="col-sm-5">
        <label>Estudiantes</label>
        <div class="input-group">
            <input class="form-control search" data-target="avaliable"
                   placeholder="Buscar estudiante">
            <span class="input-group-btn">
                <?= Html::a('<span class="glyphicon glyphicon-refresh"></span>', ['refresh'], [
                    'class' => 'btn btn-default',
                    'id' => 'btn-refresh'
                ]) ?>
            </span>
        </div>
       
       <?= 
            $form->field($model, 'estudiantes[]')            
             ->dropDownList([],[
              'multiple'=>'multiple',
              'class'=>'form-control list',
              'data-target' => 'avaliable',
              'id' => 'avaliable',
              'size' => '13',
             ]             
            )->label(false);  
        ?>
    </div>
    <div class="col-sm-2">
        <br><br><center>
        <?= Html::a('<i class="fa fa-chevron-right"></i><i class="fa fa-chevron-right"></i>' . $animateIcon, ['assign'], [
            'class' => 'btn btn-success btn-assign',
            'data-target' => 'avaliable',
            'data-toggle' => 'tooltip',
            'id' => 'add',
            'title' => 'Agregar'
        ]) ?><br><br>
        <?= Html::a('<i class="fa fa-chevron-left"></i><i class="fa fa-chevron-left"></i>' . $animateIcon, ['remove'], [
            'class' => 'btn btn-danger btn-assign',
            'data-target' => 'assigned',
            'data-toggle' => 'tooltip',
            'id' => 'remove',
            'title' => 'Eliminar'
        ]) ?>
    </center>
    </div>
    <div class="col-sm-5">
        <label>Bloqueados</label>
        <div class="input-group">
            <input class="form-control search" data-target="assigned"
                   placeholder="Buscar estudiante bloqueado">
            <span class="input-group-btn">
                <?= Html::a('<span class="glyphicon glyphicon-refresh"></span>', false, [
                    'class' => 'btn btn-default',
                    'id' => 'btn-refresh'
                ]) ?>
            </span>
        </div>
        
        <?= 
            $form->field($model, 'bloqueados[]')            
             ->dropDownList([],[
              'multiple'=>'multiple',
              'class'=>'form-control list',
              'data-target' => 'assigned',
              'id' => 'assigned',
              'size' => '13',
             ]             
            )->label(false);  
        ?>

    </div>
 
    <?php ActiveForm::end(); ?>
</div>