<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\TouchSpin;
use kartik\widgets\SwitchInput;
//use kartik\widgets\DatePicker;
use kartik\daterange\DateRangePicker;

use backend\models\Sede;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Grado;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Competencia;


$this->title = 'Lanzar Reporte';
$this->params['breadcrumbs'][] = ['label' => 'Reportes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $model->reporte;


    $ver_parametros = !isset($ver_parametros) ? false :$ver_parametros;
    $rango_fechas = !isset($rango_fechas) ? false :$rango_fechas;
    $multiple_grado = !isset($multiple_grado) ? false : $multiple_grado;

?>


<div class="row">

    <div class="col-sm-2 hidden-xs">
        <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'position:fixed; z-index:0;']); ?>
    </div>    
    
    <div class="col-sm-10 col-xs-12">
    
        <div class="col-sm-12">
            <div class="form-group">
                <?php
                    if($model->reporte)
                        echo "<p class='titulo'>".$model->reporte."</p>";
                    
                    if($model->observaciones)
                        echo "<p class='observaciones'>".$model->observaciones."</p>";
                ?>
            </div>        
        </div>


        <?php $form = ActiveForm::begin(['id' => 'reportes-form', 'enableAjaxValidation' => true]); ?>
    
        <? $form->errorSummary($model); ?>
        
        <?php if($sede) { ?>

            <div class="col-sm-12 col-xs-12">
                <div class="form-group">
                    <?php $model->sede = 1; ?>
                    <?= $form->field($model, 'sede')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Sede::find()->orderBy('id')->asArray()->all(), 'id', 'sede'),
                        'options' => ['placeholder' => Yii::t('app', 'Seleccione la Sede')],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ])->label(false); ?>
                </div>
            </div>
        
        <?php } ?>

        <?php if($tercero) { ?>

            <div class="col-sm-12 col-xs-12">
                <div class="form-group">
                    <?php  
                        if(Yii::$app->session->get('__tipo') == '2')
                        {
                            $tercero = Tercero::find()
                                        ->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])
                                        ->andWhere(['id' => Yii::$app->session->get('__tercero')])
                                        ->andWhere(['tipo_tercero' => '2'])
                                        ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])
                                        ->asArray()
                                        ->all();

                            $model->tercero = Yii::$app->session->get('__tercero');
                        }
                        else
                        {
                            $tercero = Tercero::find()
                                        ->select(['tercero.id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])
                                        ->andWhere(['tipo_tercero' => '2'])
                                        ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])
                                        ->asArray()
                                        ->all();
                        }
                    ?>

                     <?= $form->field($model, 'tercero')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map($tercero, 'id', 'nombre'),
                        'options' => ['placeholder' => Yii::t('app', 'Seleccione el Docente')],
                        'hideSearch' => false,
                        'pluginOptions' => [
                            'allowClear' => true,
                        ],
                    ])->label(false) ?>
                </div>   
            </div>

        <?php } if($grado) { ?>

            <div class="col-sm-6 col-xs-12">
                    <div class="form-group">
                        <? $form->field($model, 'grado')->widget(Select2::classname(), [
                            'data' => ArrayHelper::map(Grado::find()->orderBy('id')->asArray()->all(), 'id', 'grado'),
                            'pluginOptions' => [
                                'placeholder' => 'Seleccione Grado',
                                'allowClear' => true,
                            ],
                        ])->label(false) ?>
                        
                        <?= $form->field($model, 'grado')->widget(DepDrop::classname(), [
                            'type'=>DepDrop::TYPE_SELECT2,
                            'data' => ArrayHelper::map(Grado::find()->where(['estado' => '1'])->orderBy('id')->asArray()->all(), 'id', 'grado'),
                            'options' => ['multiple' => $multiple_grado,'placeholder' => Yii::t('app', 'Seleccione el Grado')],
                            'pluginOptions'=>[
                                'depends'=>['lanzadorform-sede', 'lanzadorform-tercero'],
                                'url'=>Url::to(['publica/findgradosbydocente']),
                            ]
                        ])->label(false);
                        ?>
                    </div>
            </div>

        <?php } if($grupo) { ?>
            
            <div class="col-sm-6 col-xs-12">
                <div class="form-group">    
                    <?= $form->field($model, 'grupo')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data' => ArrayHelper::map(Grupo::find()->where(['=', 'grado', $model->grado])->orderBy('id')->asArray()->all(), 'id', 'grupo'),
                        'options' => ['placeholder' => Yii::t('app', 'Seleccione el Grupo')],
                        'pluginOptions'=>[
                            'depends'=>['lanzadorform-sede', 'lanzadorform-grado'],
                            'url'=>Url::to(['publica/findgrupos']),
                        ]
                    ])->label(false);
                    ?>  
                </div>
            </div>

        <?php } if($asignatura) { ?>

        <div class="col-sm-12 col-xs-12">
            <div class="form-group">    
                <?= $form->field($model, 'carga')->widget(DepDrop::classname(), [
                    'type'=>DepDrop::TYPE_SELECT2,
                    //'data' => ArrayHelper::map(Carga::find()->select(['carga.asignatura as id', 'CONCAT(asignatura.asignatura, " (", grupo.grupo,")") AS asignatura'])->joinWith(['asignaturas','grupos'])->where(['docente' => $model->tercero])->orderBy('id')->asArray()->all(), 'id', 'asignatura'),
                    'select2Options'=>[
                        'pluginOptions'=>[
                            'placeholder'=> Yii::t('app', 'Seleccione la(s) Asignatura(s)'),
                        ]
                    ],
                    'options' => [
                        'multiple' => true, 
                    ],
                    'pluginOptions'=>[
                        'depends'=>['lanzadordocenteform-tercero'],
                        'url'=>Url::to(['publica/findcargas']),
                    ]
                ])->label(false);
                ?>
            </div>
        </div>
        <?php } if($periodo) { ?>
            
        <?php

            $periodo = new Periodo();
            $model->periodo = $periodo->actual->id;

        ?>    

            <div class="col-sm-6 col-xs-12">
                <div class="form-group"> 
                    <?= $form->field($model, 'periodo')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Periodo::find()->where(['estado' => '1'])->andWhere(['<=','id', $periodo->actual->id])->orderBy('id')->asArray()->all(), 'id', 'periodo'),
                        'pluginOptions' => [
                            'placeholder' => Yii::t('app', 'Seleccione el Periodo'),
                            'allowClear' => true
                        ],
                    ])->label(false) ?>
                </div>
            </div>
        
        <?php } if($rango_fechas) { ?>

            <div class="col-sm-6">
                    <label>Fecha de Inicio y Fin</label>    
                    
                <?php
                    $addon = '<span class="input-group-addon">
                                <i class="glyphicon glyphicon-calendar"></i>
                            </span>';

                    echo '<div class="input-group drp-container">';

                    
                        date_default_timezone_set('America/Bogota');    
                        $model->fecha_inicio = date('Y-m-d', strtotime( 'monday this week' ) );
                        $model->fecha_fin = date('Y-m-d', strtotime( 'friday this week' ) );

                        $model->rango = $model->fecha_inicio." - ".$model->fecha_fin;
                    
                    
                    echo DateRangePicker::widget([
                        'model'=>$model,
                        'attribute' => 'rango',
                        'useWithAddon'=>true,
                        'autoUpdateOnInit'=>true,
                        'convertFormat'=>true,
                        'presetDropdown' => false,
                        'startAttribute' => 'fecha_inicio',
                        'endAttribute' => 'fecha_fin',
                        'pluginOptions'=>[
                            'locale'=>[
                                'format' => 'Y-m-d',
                                'separator'=> ' al ',
                            ],
                            
                        ]
                    ]) . $addon;
                    echo '</div>';
                ?>
            </div>
    
        <?php } ?> 


        <?php 
                $sede = Sede::find()->where(['principal' => 1])->one();

                $model->fecha = 1;
                $model->ver_estandar = $sede->ver_estandar;
                $model->ver_competencia = $sede->ver_competencia;
                $model->ver_niveles = $sede->ver_niveles;
                $model->ver_desempenos = $sede->ver_desempenos;
                $model->ver_frd = $sede->ver_frd;
                $model->ver_fecha = 1;
        ?>
            <div class="clear"></div>
            <div class="col-sm-12">
                <?= "<p class='titulo'>".Yii::t('app', 'Qué quieres ver?')."</p>"; ?>
            </div>

        <?php if($ver_estandar) { ?> 
            
            <div class="col-sm-3 col-xs-12">
                <?= $form->field($model, 'ver_estandar')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'small',
                    'onColor' => 'primary',
                    'offColor' => 'danger',
                    'onText' => Yii::t('app', 'Mostrar'),
                    'offText' => Yii::t('app', 'Ocultar')
                ]]);?> 
            </div>

        <?php } if($ver_competencia) { ?>             
            
            <div class="col-sm-3 col-xs-12">
                <?= $form->field($model, 'ver_competencia')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'small',
                    'onColor' => 'primary',
                    'offColor' => 'danger',
                    'onText' => Yii::t('app', 'Mostrar'),
                    'offText' => Yii::t('app', 'Ocultar')
                ]]);?> 
            </div>
        
        <?php } if($ver_niveles) { ?>             

            <div class="col-sm-3 col-xs-12">
                <?= $form->field($model, 'ver_niveles')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'small',
                    'onColor' => 'primary',
                    'offColor' => 'danger',
                    'onText' => Yii::t('app', 'Mostrar'),
                    'offText' => Yii::t('app', 'Ocultar')
                ]]);?> 
            </div> 

        <?php } if($ver_desempenos) { ?>              

            <div class="col-sm-3 col-xs-12">
                <?= $form->field($model, 'ver_desempenos')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'small',
                    'onColor' => 'primary',
                    'offColor' => 'danger',
                    'onText' => Yii::t('app', 'Mostrar'),
                    'offText' => Yii::t('app', 'Ocultar')
                ]]);?> 
            </div> 

        <?php } if($ver_frd) { ?>              

            <div class="col-sm-3 col-xs-12">
                <?= $form->field($model, 'ver_frd')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'small',
                    'onColor' => 'primary',
                    'offColor' => 'danger',
                    'onText' => Yii::t('app', 'Mostrar'),
                    'offText' => Yii::t('app', 'Ocultar')
                ]]);?> 
            </div>

        <?php } if($ver_fecha) { ?>            

            <div class="col-sm-3 col-xs-12">
                <?= $form->field($model, 'ver_fecha')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'small',
                    'onColor' => 'primary',
                    'offColor' => 'danger',
                    'onText' => Yii::t('app', 'Mostrar'),
                    'offText' => Yii::t('app', 'Ocultar')
                ]]);?> 
            </div>    
        
        <?php } if($ver_letrasonumeros) { ?>

            <div class="col-sm-3 col-xs-12">
                <?= $form->field($model, 'ver_letrasonumeros')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'small',
                    'onColor' => 'primary',
                    'offColor' => 'success',
                    'onText' => Yii::t('app', 'Letras'),
                    'offText' => Yii::t('app', 'Números')
                ]]);?> 
            </div>

        <?php } if($ver_parametros) {  ?> 
        
        <div class="clear"></div>

            <div class="col-sm-4 col-xs-12">
                <?php 
                    $model->ver_colores = 1; 
                    $model->fuente = 7; 
                    $model->alto = 4; 
                ?>
                <?= $form->field($model, 'ver_colores')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'small',
                    'onColor' => 'primary',
                    'offColor' => 'success',
                    'onText' => Yii::t('app', 'Con Colores'),
                    'offText' => Yii::t('app', 'Sin Colores')
                ]]);?> 
            </div>

            <div class="col-sm-4 col-xs-12">
                    <?= $form->field($model, 'fuente')->widget(TouchSpin::classname(), ['options' => ['class' => 'input-sm', 'placeholder' => 'Tamaño'],]);?>
            </div>

            <div class="col-sm-4 col-xs-12">
                    <?= $form->field($model, 'alto')->widget(TouchSpin::classname(), ['options' => ['class' => 'input-sm', 'placeholder' => 'Alto'],]);?>
            </div>
            
        <?php } ?> 


        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align:right; padding-top: 10px;">
            <?= Html::submitButton('<i class="fa fa-rocket" aria-hidden="true"></i> '.Yii::t('app', 'Generar'), ['class' => 'btn btn-warning']) ?>
            <?= Html::a('<i class="fa fa-times" aria-hidden="true"></i> '.Yii::t('app', 'Cancelar'), false , ['class'=> 'btn btn-danger', 'data-dismiss' => 'modal']) ?>        
        </div>

        <?php ActiveForm::end(); ?>

    </div>
</div>



