<?php


use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;


$this->title = 'Reportes';
$this->params['breadcrumbs'][] = ['label' => 'Reportes', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Buscar Reporte';

$this->registerJs("
	$(document).ready(function(){

	 load_data();

	 function load_data(query)
	 {
	 	$('#result').html('<div style=\'text-align:center;\'><img src=\'".Url::to('@web/images/loading.gif')."\' width=\'50px\' height=\'50px\'></div>');	
		
		  $.ajax({
		   url:'".Url::to(['buscar'])."',
		   method:'POST',
		   data:{query:query},
		   success:function(data)
		   {
		    $('#result').html(data);
		   }
		  });
	 }
	 
	 $('#authitem-reporte').keyup(function(){
		  var search = $(this).val();
		  if(search != '')
		  {
		   	load_data(search);
		  }
		  else
		  {
		   	load_data();
		  }
		 });
	});
");

?>
	 <?php $form = ActiveForm::begin([
	    'type' => ActiveForm::TYPE_VERTICAL,
	    'options' => ['class' => 'main-task-form',
	                  'id' => 'formulario',
	                ]
	]); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Listado de Reportes</h3>
    </div>

    <div style="display:none;" class="panel-body kv-alert-container">
        <?= $form->errorSummary($model); ?>
    </div>

    <div class="table-responsive" style="padding-top:10px">
        <div class="col-sm-12">
            <?= $form->field($model, 'reporte', [
    			'addon' => ['prepend' => ['content'=>'<i class="fas fa-search"></i>']],
				])->label(false); 
			?>
        </div>
        <div id="result" class="col-sm-12">
        	<?= "<div style='text-align:center;'><img src='".Url::to('@web/images/loading.gif')."' width='50px' height='50px'></div>"; ?>
		</div>        
    </div>        
</div>

    <?php ActiveForm::end(); ?>
