<?php


use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\web\JsExpression;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;
use kartik\widgets\TouchSpin;
use kartik\widgets\ColorInput;

use backend\models\Departamento;
use backend\models\Municipio;



/*
\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'Grupo', 
        'relID' => 'grupo', 
        'value' => \yii\helpers\Json::encode($model->grupos),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);*/

?>


   <?php $form = ActiveForm::begin([
        'validateOnSubmit' => true,
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                      'enctype'=>'multipart/form-data',
                    ]
    ]); ?>
    
<div class="row">
    <div class = "col-sm-12">
        <?= $form->errorSummary($model); ?>
    </div>
</div>

<?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

<div class="row gutter">
    <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
        <div class="thumbnail" style="padding:10px;">
            <?= Html::img('@web/images/'.$model->logo, ['class'=>'img-responsive']); ?>

            <h4 class="center-align-text text-primary" style="display:block;"><?= $model->sede ?></h4>
        </div>
        <div class="thumbnail" style="padding:20px;">
            <div class="row">
                <div class="col-sm-12">
                    <?= $form->field($model, 'activar_matriculas')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]]) 
                    ?>
                </div>
                <div class="col-sm-12">
                    <?= $form->field($model, 'bloquear_boletin')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]]) 
                    ?>
                </div>       
                <div class="col-sm-12">
                    <?= $form->field($model, 'autorizar_calificaciones')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]]) 
                    ?>    
                </div> 
                <div class="col-sm-12">
                    <?= $form->field($model, 'autorizar_nivelaciones')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]]) 
                    ?>    
                </div>       
                <div class="col-sm-12">
                    <?= $form->field($model, 'bloquear_estudiante')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]]) 
                    ?> 
                </div>
            </div>
        </div>
    </div>       


            
    <div class="col-lg-9 col-md-8 col-sm-12 col-xs-12">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#informacion"><?= Yii::t('app', 'Información') ?></a></li>
            <li class=""><a data-toggle="tab" href="#calificaciones"><?= Yii::t('app', 'Calificaciones') ?></a></li>
            <li class=""><a data-toggle="tab" href="#nivelaciones"><?= Yii::t('app', 'Nivelaciones') ?></a></li>
            <li class=""><a data-toggle="tab" href="#comportamiento"><?= Yii::t('app', 'Comportamiento') ?></a></li>
            <li class=""><a data-toggle="tab" href="#parametros"><?= Yii::t('app', 'Parámetros') ?></a></li>
            <li class=""><a data-toggle="tab" href="#reportes"><?= Yii::t('app', 'Reportes') ?></a></li>
            <li class=""><a data-toggle="tab" href="#pdf"><?= Yii::t('app', 'Encabezado y Pie de Página') ?></a></li>
            <li class=""><a data-toggle="tab" href="#carnet"><?= Yii::t('app', 'Carnet') ?></a></li>
        </ul>
        <div class="tab-content">

            <div id="informacion" class="tab-pane active">

                <div class="row">

                    <div class="col-sm-6">
                        <?= $form->field($model, 'sede')->textInput(['maxlength' => true, 'placeholder' => 'Sede']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'nit')->textInput(['maxlength' => true, 'placeholder' => 'Nit']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'vigencia')->textInput(['maxlength' => true, 'placeholder' => 'Vigencia']) ?>
                    </div>       
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($model, 'direccion')->textInput(['maxlength' => true, 'placeholder' => 'Dirección']) ?>
                    </div>      
                    <div class="col-sm-3">
                        <?= $form->field($model, 'departamento')->widget(Select2::classname(), [
                            'data' => ArrayHelper::map(Departamento::find()->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                            'options' => ['id'=>'dep-id',],
                            'pluginOptions' => [
                                'placeholder' => 'Seleccione el Departamento',
                                'allowClear' => true,
                            ],
                        ]) ?>

                    </div>
                    <div class="col-sm-3">

                        <?= $form->field($model, 'municipio')->widget(DepDrop::classname(), [
                            'type'=>DepDrop::TYPE_SELECT2,
                            'data' => ArrayHelper::map(Municipio::find()->where(['=', 'departamento', $model->departamento])->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                            'options'=>['id'=>'mun-id'],
                            'pluginOptions'=>[
                                'placeholder'=>'Seleccione el Municipio',
                                'depends'=>['dep-id'],
                                'url'=>Url::to(['findmunicipios']),
                            ]
                        ]);
                        ?>  
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($model, 'fijo')->textInput(['maxlength' => true, 'placeholder' => 'Fijo']) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($model, 'resolucion')->textInput(['maxlength' => true, 'placeholder' => 'Resolución']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'dane')->textInput(['maxlength' => true, 'placeholder' => 'Dane']) ?>
                    </div>    
                    <div class="col-sm-6">
                        <?= $form->field($model, 'slogan')->textInput(['maxlength' => true, 'placeholder' => 'Slogan']) ?>
                    </div>   
                </div>
                <div class="row">    
                    <div class="col-sm-3">
                        <?= $form->field($model, 'rector_nombre')->textInput(['maxlength' => true, 'placeholder' => 'Rector Nombre']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'rector_cc')->textInput(['maxlength' => true, 'placeholder' => 'Rector Cc']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'rector_expedida')->textInput(['maxlength' => true, 'placeholder' => 'Rector Expedida']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'rector_movil')->textInput(['maxlength' => true, 'placeholder' => 'Rector Movil']) ?>
                    </div> 
                </div>
                <div class="row">          
                    <div class="col-sm-3">
                        <?= $form->field($model, 'rector_email')->textInput(['maxlength' => true, 'placeholder' => 'Rector Email']) ?>
                    </div>       
                </div>
            </div>  <!-- FIN TAB 1  -->


            <div id="pdf" class="tab-pane">
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'pdf_header')->textarea(['rows' => 6]) ?>
                    </div>       
                    <div class="col-sm-12" style="padding-bottom: 20px;">
                        <label>Muestra</label>
                        <?= $model->pdf_header ?>
                    </div>
                    <div class="col-sm-12">
                        <?= $form->field($model, 'pdf_footer')->textarea(['rows' => 6]) ?>
                    </div>
                    <div class="col-sm-12" style="padding-bottom: 20px;">
                        <label>Muestra</label>
                        <?= $model->pdf_footer ?>
                    </div>       
                    <div class="col-sm-6">
                        <?= $form->field($model, 'pdf_marcadeagua')->widget(Select2::classname(), [
                            'data' => ['N' => 'Sin Marca', 'I' => 'Imágen', 'T' => 'Texto', 'B' => 'Borrador'],
                            'options' => ['placeholder' => 'Seleccione el Tipo de Marca de Agua'],
                            'pluginOptions' => [
                                'allowClear' => true
                            ],
                        ]); ?>
                    </div>       
                    <div class="col-sm-6">
                        <?= $form->field($model, 'pdf_marcadeagua_contenido')->textInput(['maxlength' => true, 'placeholder' => 'Pdf Marcadeagua Contenido']) ?>
                    </div>       
                </div>
            </div> 


            <div id="calificaciones" class="tab-pane">
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($model, 'tipo_calificacion')->widget(\kartik\widgets\Select2::classname(), [
                            'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tipocalificacion::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                            'options' => ['placeholder' => 'Seleccione el Tipo Calificación'],
                            'pluginOptions' => [
                                'allowClear' => true
                            ],
                        ]); ?>
                    </div>
                    <div class="col-sm-6">
                        <?= $form->field($model, 'calificacionxcompetencia')->widget(\kartik\widgets\Select2::classname(), [
                            'data' => ['1' => 'Por Asignatura','2' => 'Por Competencia'],
                            'options' => ['placeholder' => 'Seleccione'],
                            'pluginOptions' => [
                                'allowClear' => true
                            ],
                        ]); ?>
                    </div>
                    
                    <div class="col-sm-6">        
                        <?= $form->field($model, 'num_calificaciones_saber')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Número'],]);?>
                    </div> 

                    <div class="col-sm-6">        
                        <?= $form->field($model, 'por_calificaciones_saber')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Porcentaje'],]);?>
                    </div>

                    <div class="col-sm-6">        
                        <?= $form->field($model, 'num_calificaciones_ser')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Número'],]);?>
                    </div> 
                    
                    <div class="col-sm-6">        
                        <?= $form->field($model, 'por_calificaciones_ser')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Porcentaje'],]);?>
                    </div>
                    <div class="col-sm-6">
                        <?= $form->field($model, 'psi')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?>
                    </div>
                    <div class="col-sm-6">        
                        <?= $form->field($model, 'por_calificaciones_psi')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Porcentaje'],]);?>
                    </div>
                </div> 
            </div>

            <div id="nivelaciones" class="tab-pane">
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'nivelacionxcompetencia')->widget(\kartik\widgets\Select2::classname(), [
                            'data' => ['1' => 'Por Asignatura','2' => 'Por Competencia'],
                            'options' => ['placeholder' => 'Seleccione'],
                            'pluginOptions' => [
                                'allowClear' => true
                            ],
                        ]); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($model, 'nivelacion_no_nivelado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?> 
                    </div>
                    <div class="col-sm-6">
                        <?= $form->field($model, 'nivelacion_mayor_calificacion')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?> 
                    </div>
                </div> 
            </div>

            <div id="parametros" class="tab-pane">
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'compromiso_acudiente')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?>
                    </div> 
                    <div class="col-sm-4">
                        <?= $form->field($model, 'frd')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'onColor' => 'primary',
                            'offColor' => 'warning',
                            'onText'=>'Automáticas',
                            'offText'=>'Manual'
                        ]]) 
                        ?> 
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'fallas')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'onColor' => 'primary',
                            'offColor' => 'warning',
                            'onText'=>'Automáticas',
                            'offText'=>'Manual'
                        ]]) 
                        ?> 
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'entrada')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'onColor' => 'primary',
                            'offColor' => 'warning',
                            'onText'=>'Lista',
                            'offText'=>'Texto'
                        ]]) 
                        ?> 
                    </div>
                </div> 
            </div>


            <div id="reportes" class="tab-pane">
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($model, 'ver_estandar')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($model, 'ver_competencia')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'ver_niveles')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'ver_desempenos')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?>    
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'ver_frd')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?> 
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($model, 'ver_criterios')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?> 
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($model, 'ver_emoticones')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?> 
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($model, 'ver_puesto')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?> 
                    </div>
                </div> 
            </div>



            <div id="comportamiento" class="tab-pane">
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($model, 'activar_comportamiento')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($model, 'ver_comportamiento_nota')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'observaciones_generales')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'observaciones_especificas')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Si',
                            'offText'=>'No'
                        ]]) 
                        ?>    
                    </div>       
                </div> 
            </div> 


            <div id="carnet" class="tab-pane">
                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($model, 'orientacion')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'onColor' => 'primary',
                            'offColor' => 'warning',
                            'onText'=>'Horizontal',
                            'offText'=>'Vertical'
                        ]]) 
                        ?> 
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'color')->widget(ColorInput::classname(), ['options' => ['placeholder' => 'Select Color...'],]); ?>     
                    </div>
                    <div class="col-sm-12">
                        <?= $form->field($model, 'mensaje')->textarea(['rows' => 3]) ?>
                    </div>       
                </div>
            </div> 


        </div>         
    </div>   
</div>  

    <?php
   /* $forms = [
        [
            'label' => '<i class="glyphicon glyphicon-book"></i> ' . Html::encode('Grupo'),
            'content' => $this->render('_formGrupo', [
                'row' => \yii\helpers\ArrayHelper::toArray($model->grupos),
            ]),
        ],
    ];
    echo kartik\tabs\TabsX::widget([
        'items' => $forms,
        'position' => kartik\tabs\TabsX::POS_ABOVE,
        'encodeLabels' => false,
        'pluginOptions' => [
            'bordered' => true,
            'sideways' => true,
            'enableCache' => false,
        ],
    ]);
    */
    ?>
    <?php ActiveForm::end(); ?>

</div>
