<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\SedeSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;


$this->title = 'Sede';
$this->params['breadcrumbs'][] = $this->title;


$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];


$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="sede-index">

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        ['attribute' => 'nit', 'visible' => false],
        ['attribute' => 'sede', 'visible' => true],
        ['attribute' => 'direccion', 'visible' => false],
        ['attribute' => 'fijo', 'visible' => false],
        ['attribute' => 'resolucion', 'visible' => false],
        ['attribute' => 'dane', 'visible' => false],
        ['attribute' => 'rector_nombre', 'visible' => false],
        ['attribute' => 'rector_cc', 'visible' => false],
        ['attribute' => 'rector_expedida', 'visible' => false],
        ['attribute' => 'rector_movil', 'visible' => false],
        ['attribute' => 'rector_email:email', 'visible' => false],
        ['attribute' => 'logo', 'visible' => false],
        ['attribute' => 'vigencia', 'visible' => true],
        ['attribute' => 'pdf_header:ntext', 'visible' => false],
        ['attribute' => 'pdf_footer:ntext', 'visible' => false],
        ['attribute' => 'pdf_marcadeagua', 'visible' => false],
        ['attribute' => 'pdf_marcadeagua_contenido', 'visible' => false],
        [
            'attribute' => 'bloquear_boletin', 
            'label' => 'Bloquear Boletín',
            'visible' => true,
            'format' => 'RAW',
            'value' => function($model){
                return ($model->bloquear_boletin == '1') ? '<span class="label label-success">Si</span>' : '<span class="label label-danger">No</span>';
            },  
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => [0 => "No", 1 => "Si"],
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
                ],
            'filterInputOptions' => ['placeholder' => 'Buscar', 'id' => 'grid-sede-search-bloquear_boletin']  
        ],
        [
            'attribute' => 'compromiso_acudiente', 
            'label' => 'Compromiso Acudiente',
            'visible' => true,
            'format' => 'RAW',
            'value' => function($model){
                return ($model->compromiso_acudiente == '1') ? '<span class="label label-success">Si</span>' : '<span class="label label-danger">No</span>';
            },  
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => [0 => "No", 1 => "Si"],
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
                ],
            'filterInputOptions' => ['placeholder' => 'Buscar', 'id' => 'grid-sede-search-compromiso_acudiente']  
        ],
        [
            'attribute' => 'autorizar_calificaciones', 
            'label' => 'Autorizar Calificaciones',
            'visible' => true,
            'format' => 'RAW',
            'value' => function($model){
                return ($model->autorizar_calificaciones == '1') ? '<span class="label label-success">Si</span>' : '<span class="label label-danger">No</span>';
            },  
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => [0 => "No", 1 => "Si"],
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
                ],
            'filterInputOptions' => ['placeholder' => 'Buscar', 'id' => 'grid-sede-search-autorizar_calificaciones']  
        ],
        [
            'attribute' => 'autorizar_nivelaciones', 
            'label' => 'Autorizar Nivelaciones',
            'visible' => true,
            'format' => 'RAW',
            'value' => function($model){
                return ($model->autorizar_nivelaciones == '1') ? '<span class="label label-success">Si</span>' : '<span class="label label-danger">No</span>';
            },  
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => [0 => "No", 1 => "Si"],
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
                ],
            'filterInputOptions' => ['placeholder' => 'Buscar', 'id' => 'grid-sede-search-autorizar_nivelaciones']  
        ],
        [
            'attribute' => 'bloquear_estudiante', 
            'label' => 'Bloquear Estudiantes',
            'visible' => true,
            'format' => 'RAW',
            'value' => function($model){
                return ($model->bloquear_estudiante == '1') ? '<span class="label label-success">Si</span>' : '<span class="label label-danger">No</span>';
            },  
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => [0 => "No", 1 => "Si"],
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
                ],
            'filterInputOptions' => ['placeholder' => 'Buscar', 'id' => 'grid-sede-search-bloquear_estudiante']  
        ],
        [
            'attribute' => 'fallas', 
            'label' => 'Tipo de Fallas',
            'visible' => true,
            'format' => 'RAW',
            'value' => function($model){
                return ($model->fallas == '1') ? '<span class="label label-primary">Automáticas</span>' : '<span class="label label-warning">Manuales</span>';
            },  
            
        ],
        [
            'attribute' => 'entrada', 
            'label' => 'Tipo de Entrada',
            'visible' => true,
            'format' => 'RAW',
            'value' => function($model){
                return ($model->entrada == '1') ? '<span class="label label-primary">Lista</span>' : '<span class="label label-warning">Texto</span>';
            },  
            
        ],
        [
            'class' => 'yii\grid\ActionColumn',
            'template' => '{update}',
        ],
    ]; 
    ?>

<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'sede'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>

</div>
