<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Sede */

$this->title = $model->sede;
$this->params['breadcrumbs'][] = ['label' => 'Sede', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="sede-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Sede'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'nit',
        'sede',
        'direccion',
        'fijo',
        'resolucion',
        'dane',
        'rector_nombre',
        'rector_cc',
        'rector_expedida',
        'rector_movil',
        'rector_email:email',
        'logo',
        'vigencia',
        'pdf_header:ntext',
        'pdf_footer:ntext',
        'pdf_marcadeagua',
        'pdf_marcadeagua_contenido',
        'bloquear_boletin',
        'compromiso_acudiente',
        'autorizar_nivelaciones',
        'bloquear_estudiante',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    <div class="row">
<?php
/*
if($providerGrupo->totalCount){
    $gridColumnGrupo = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            [
                'attribute' => 'grados.grado',
                'label' => 'Grado'
            ],
            'grupo',
            [
                'attribute' => 'directores.id',
                'label' => 'Director'
            ],
            [
                'attribute' => 'jornadas.jornada',
                'label' => 'Jornada'
            ],
                        [
                'attribute' => 'metodologias.metodologia',
                'label' => 'Metodologia'
            ],
            [
                'attribute' => 'modalidades.modalidad',
                'label' => 'Modalidad'
            ],
            [
                'attribute' => 'especialidades.especialidad',
                'label' => 'Especialidad'
            ],
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerGrupo,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-grupo']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Grupo'),
        ],
        'export' => false,
        'columns' => $gridColumnGrupo
    ]);
}*/
?>

    </div>
</div>
