<?php

use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use kartik\widgets\Select2;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use backend\models\Tercero;
use backend\models\Academico;
use backend\models\Asistencia;
use yii\db\Expression;

$model = Tercero::findOne($tercero->tercero);

                  
$actual = Asistencia::find()
          ->select(['COUNT(estudiante) AS fallas'])
          ->where(['DATE(fecha)' => new Expression('CURDATE()')])
          ->orderby('estudiante')
          ->one();  
                  
?>
<div class="row">
  <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <div class="ibox ">
        <div class="ibox-title">
            <h5 class="text-success"><?= $model->nombreinverso; ?>&nbsp;<small>Acciones Rápidas</small></h5>
            <div class="ibox-tools">
                <a class="collapse-link">
                    <i class="fa fa-chevron-up"></i>
                </a>
                <a class="close-link">
                    <i class="fa fa-times"></i>
                </a>
            </div>
        </div>
        <div class="ibox-content">
            <div class="row">
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6">
      
                  <?= Html::img($model->foto ? '@web/uploads/thumbnail/sm-'.$model->foto : '@web/images/user.jpg', ['class'=>'foto-acciones img-circle img-responsive img-50']); ?>
                  
                  <h4 class="center-align-text"><?= $model->nombreinverso ?></h4>
                 
                  <!--<div class="progress m-t-xs full progress-small">
                      <div style="width: 65%" aria-valuemax="100" aria-valuemin="0" aria-valuenow="65" role="progressbar" class=" progress-bar progress-bar-success">
                          <span class="sr-only">35% Complete (success)</span>
                      </div>
                  </div>-->
                 
                  <p class="btn-stack center-align-text">
                  
                  <? 
                      echo "<label class='btn btn-xs btn-success'>".$model->estados->estado."</label>";

                      $data = Academico::find()->where(['estudiante' => $model->id])->one();

                      if ($data =='')
                      {
                          echo "<label class='btn btn-xs btn-danger'>Sin Grupo</label>";
                      }
                      else    
                      {
                          echo "<label class='btn btn-xs btn-info'>Grupo " .$data->grupos->grupo. "</label>";
                      }

                      if ($model->bloqueo == '0')
                      {
                          echo "<label class='btn btn-xs btn-info'>Sin Bloquear</label>";    
                      } 
                      else
                      {
                          echo "<label class='btn btn-xs btn-danger'>Bloqueado</label>";    
                      } 
                  ?>

                </div>
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6 b-r">
                  <ul class="todo-list m-t small-list">
                      <li>
                          <?= Html::a('<i class="fa fa-download text-info"></i> Hoja de Vida', ['tercero/hojadevida', 'id' => $model->id]); ?>
                      </li>
                      <li>
                          <?= Html::a('<i class="fa fa-user-times text-danger"></i> Reporte de Ausentismo <span class="time">'.$actual->fallas.' fallas</span>', ['pdf', 'id' => '1']); ?>
                      </li>
                      
                  </ul>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6">
                  <ul class="todo-list m-t small-list">
                      <li>
                          <?= Html::a('<i class="fa fa-download text-info"></i> Boletín de Notas', ['tercero/hojadevida', 'id' => $model->id]); ?>
                      </li>
                      <li>
                          <?= Html::a('<i class="fa fa-user-times text-danger"></i> Reporte de Ausentismo <span class="time">'.$actual->fallas.' fallas</span>', ['pdf', 'id' => '1']); ?>
                      </li> 
                  </ul>
                </div>
            </div>
        </div>
      </div>
    </div>
</div>

                
  

         
