<?php

use yii\helpers\Html;

$this->registerJs('
    $(function(){
        $("#ausentes").DataTable({
          "dom":"ftip",
          language: {
              search: "<i class=\"fas fa-search\"></i>",
              searchPlaceholder: "Buscar..."
          },
          "scrollY": "165px",
          "scrollCollapse": true,
          "paging": false,
          "bFilter": true,
          "bInfo" : false,
        });
    });
');
?>

<div class="row gutter">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="ibox ">
            <div class="ibox-title">
                <h5><i class="fas fa-users text-danger"></i> Ausentes Hoy&nbsp;<small></small></h5>
                <div class="ibox-tools">
                    <span class="label label-danger"><?= count($ausentes) ?></span>

                    <a class="collapse-link">
                        <i class="fa fa-chevron-up"></i>
                    </a>
                    <a class="fullscreen-link">
                        <i class="fas fa-expand-alt"></i>
                    </a>
                    <a class="close-link">
                        <i class="fa fa-times"></i>
                    </a>    
                </div>
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <table id="ausentes" class="table">
                            <thead>
                                <tr>
                                    <th><i class="far fa-camera-alt"></i></th>
                                    <th>Estudiante</th>
                                    <th><i class="far fa-users-class"></i></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    foreach($ausentes as $ausente)
                                    { 
                                ?>
                                        <tr>
                                            <td><?= Html::img($ausente->estudiantes->foto ? '@web/uploads/thumbnail/sm-'.$ausente->estudiantes->foto : '@web/images/user.jpg', ['class'=>'img-36 rounded-circle']); ?></td>
                                            <td><?= $ausente->estudiantes->nombre ?></td>
                                            <td><span class="label label-info"><?= $ausente->grupos->grupo ?></span></td>
                                        </tr>
                                                              
                                <?php } ?>  
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>