<?php

use yii\helpers\Html;


$this->registerJs('
    $(function(){
        $("#bloqueados").DataTable({
          language: {
              search: "<i class=\"fas fa-search\"></i>",
              searchPlaceholder: "Buscar..."
          },
          "scrollY": "165px",
          "scrollCollapse": true,
          "paging": true,
          "bFilter": true,
          "bInfo" : true,
        });
    });
');


?>

<div class="row gutter">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="ibox ">
            <div class="ibox-title">
                <h5><i class="fas fa-lock text-danger"></i> Estudiantes Bloqueados&nbsp;<small>Todos los Grupos</small></h5>
                <div class="ibox-tools">
                    <span class="label label-danger"><?= count($bloqueados) ?></span>    
                    <a class="collapse-link">
                        <i class="fa fa-chevron-up"></i>
                    </a>
                    <a class="fullscreen-link">
                        <i class="fa fa-expand-alt"></i>
                    </a>
                    <a class="print-link">
                        <i class="fa fa-print"></i>
                    </a>
                    <a class="close-link">
                        <i class="fa fa-times"></i>
                    </a>
                </div>
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <table id="bloqueados" class="table">
                            <thead>
                                <tr>
                                    <th><i class="far fa-camera-alt"></i></th>
                                    <th>Estudiante</th>
                                    <th>Grupo</th>
                                    <th>Celular</th>
                                    <th>E-Mail</th>                                    
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    foreach($bloqueados as $tercero)
                                    { 
                                ?>
                                        <tr>
                                            <td><?= Html::img($tercero->foto ? '@web/uploads/thumbnail/sm-'.$tercero->foto : '@web/images/user.jpg', ['class'=>'img-36 rounded-circle']); ?></td>
                                            <td><?= $tercero->nombre ?></td>
                                            <td><span class="label label-info"><?= $tercero->grupo->grupo ?></span></td>
                                            <td><?= $tercero->movil ?></td>
                                            <td><?= $tercero->email ?></td>
                                        </tr>
                                                              
                                <?php } ?>  
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>    

                
  

         
