<?php

use yii\helpers\Html;
use backend\models\Competencia;


$this->registerJs('
    $(function(){
        $("#competencias").DataTable({
          language: {
              search: "<i class=\"fas fa-search\"></i>",
              searchPlaceholder: "Buscar..."
          },
          "scrollY": "165px",
          "scrollCollapse": true,
          "paging": true,
          "bFilter": true,
          "bInfo" : true,
        });
    });
');


?>

<div class="row gutter">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="ibox ">
            <div class="ibox-title">
                <h5><i class="fas fa-circle text-danger"></i><i class="fas fa-circle text-warning"></i><i class="fas fa-circle text-success"></i> Semáforo de Control de Competencias &nbsp;<small>Periodo <?= $periodo->actual->id ?></small></h5>
                <div class="ibox-tools">
                    <span class="label label-info"><?= count($asignaturas) ?> Asignaturas</span>    
                    <a class="collapse-link">
                        <i class="fa fa-chevron-up"></i>
                    </a>
                    <!--<a class="fullscreen-link">
                        <i class="fa fa-expand-alt"></i>
                    </a>
                    <a class="print-link">
                        <i class="fa fa-print"></i>
                    </a>-->
                    <a class="close-link">
                        <i class="fa fa-times"></i>
                    </a>
                </div>
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <table id="competencias" class="table">
                            <thead>
                                <tr>
                                    <th><i class="fa fa-circle" aria-hidden="true"></i></th>
                                    <th>Grado</th>
                                    <th>Asignatura</th>
                                    <th>Competencias</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    foreach($asignaturas as $asignatura)
                                    { 

                                        $competencias = Competencia::find()
                                                            ->where(['grado' => $asignatura->grado])
                                                            ->andWhere(['asignatura' => $asignatura->id])
                                                            ->andWhere(['periodo' => $periodo->actual->id])
                                                            ->andWhere(['eliminado_por' => '0'])
                                                            ->count();
                                ?>
                                        <tr>
                                            <td><?= $competencias > 0 ? '<i class="fa fa-circle text-success" aria-hidden="true"></i>' : '<i class="fa fa-circle text-danger" aria-hidden="true"></i>' ?></td>
                                            <td><?= $asignatura->grados->grado ?></td>
                                            <td><?= $asignatura->asignatura ?></td>
                                            <td><?= $competencias > 0 ? '<span class="btn btn-xs btn-success">Con '.($competencias > 1 ? $competencias.' Competencias' : $competencias.' Competencia').'</span>' : '<span class="btn btn-xs btn-danger">Sin Competencia</span> '.Html::a('<i class="far fa-plus" aria-hidden="true"></i> Agregar Competencia', ['competencia/create', 'grado' => $asignatura->grado, 'asignatura' => $asignatura->id],['class' => 'btn btn-xs btn-primary']) ?></span></td>
                                            

                                        </tr>
                                                              
                                <?php } ?>  
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>    

                
  

         
