<?php
  
use yii\helpers\Html;
use yii\helpers\Url;



$ahora = Yii::$app->formatter->asTimestamp('now');
$final = Yii::$app->formatter->asTimestamp($periodo->actual->fecha_fin.' 23:59:59');


if($ahora < $final)
{
  $this->registerJs(
      '$("#countdown").countdown({  
      date: "'.$periodo->actual->fecha_fin.' 23:59:59",
      format: "on"
      }, 
      function() {
       //cambiar_periodo('.$periodo->actual->id.');
        $("#countdown").html("Hola");
       });
  ');

  $mensaje_periodo =  '<b>Periodo '.$periodo->actual->id.'</b>, Finaliza el '.$periodo->actual->fecha_fin;
}
else
{
  $this->registerJs('
    $("#countdown").html("<div style=\"padding-top: 8px;\"><a href=\"#\" onclick=\"cambiar_periodo('.$periodo->actual->id.')\" class=\"btn btn-block btn-warning\">Cambiar Periodo</a></div>");
  ');

  $mensaje_periodo =  '<b>Periodo '.$periodo->actual->id.'</b>, Finalizó '.Yii::$app->formatter->asRelativeTime($periodo->actual->fecha_fin);
}

?>

<script type="text/javascript">
    

    function cambiar_periodo(periodo)
    {

      swal({
          title: '¿Deseas cambiar el periodo?',
          text: 'El periodo ' + periodo + ' ha finalizado, puedes cambiarlo ahora...',
          type: 'warning',
          showCancelButton: true,
          confirmButtonClass: 'btn-warning',
          confirmButtonText: 'Si, estoy seguro!',
          cancelButtonText: 'No, Cancelar',
          closeOnConfirm: false,
          closeOnCancel: false
        },
        function(isConfirm) {
          if (isConfirm) 
          {
            $.ajax({
                    type: 'GET',
                    url: '<?= Url::to(["periodo/cambiar"]) ?>',
                    data: {periodo : periodo},
                    success: function (data) {
                        swal({
                            title: 'Enhorabuena!',
                            text: 'Se ha cambiado al periodo ' + data + ' satisfactoriamente, serás redirigido al panel nuevamente.',
                            type: 'success',
                            allowOutsideClick: false,
                            timer: 3000,
                        });

                        window.location.href = '<?= Url::to(["../admin"]) ?>';
                    }
            });  
          } 
          else 
          {
              swal({
                title: 'Cancelado!',
                text: 'Haz cancelado el cambio de periodo.',
                type: 'error',
                timer: 3000})
          }
      });
    }  

</script>


<div id="panel" class="panel panel-blue">
    <div class="panel-heading">
      <div class="row">
          <div class="col-lg-3 col-md-3 hidden-sm hidden-xs">
              <!--<i class="fa fa-graduation-cap"></i>-->
              <?= Html::img('@web/images/reloj.png', ['class'=>'zoom']); ?>
          </div>
          <!--Alumnos-->
          <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12 text-right">
              <ul id="countdown">
                <li><span class="days num">00</span>
                  <p class="timeDays desc">Días</p>
                </li>
                <li><span class="hours num">00</span>
                  <p class="timeHours desc">Horas</p>
                </li>
                <li><span class="minutes num">00</span>
                  <p class="timeMinutes desc">Minutos</p>
                </li>
                <li><span class="seconds num">00</span>
                  <p class="timeSeconds desc">Segundos</p>
                </li>
              </ul>
          </div>
      </div>
    </div>
    <a class="expand-link">
        <div class="panel-footer">
            <span class="pull-left"><?= $mensaje_periodo ?></span>
            <div class="clearfix"></div>
        </div>
    </a>    
</div>