    <?php

use yii\helpers\Html;
use backend\models\Grupo;
use backend\models\Tipotercero;



?>

<div class="row gutter">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="ibox ">
            <div class="ibox-title">
                <h5><i class="far fa-calendar-alt text-primary"></i> Eventos</h5>
                <div class="ibox-tools">
                    <a class="collapse-link">
                        <i class="fa fa-chevron-up"></i>
                    </a>
                    <a class="fullscreen-link">
                        <i class="fas fa-expand-alt"></i>
                    </a>
                    <a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="false">
                        <i class="fa fa-wrench"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-user" x-placement="bottom-start" style="position: absolute; top: 18px; left: 26px; will-change: top, left;">
                        <li><a href="#" class="dropdown-item">Config option 1</a>
                        </li>
                        <li><a href="#" class="dropdown-item">Config option 2</a>
                        </li>
                    </ul>
                    <a class="close-link">
                        <i class="fa fa-times"></i>
                    </a>
                </div>
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="events-container">
                                <?php

                                    Yii::$app->formatter->locale = 'es-ES';
                                    
                                    foreach($eventos as $evento)
                                    { 
                                ?>

                                        <!-- Evento -->
                                        <div class="cal-event">
                                            <div class="cal-event-tile" style="background-color: <?= $evento->color ?>;">
                                                <div class="cal-event-tile-date">
                                                    <?= Yii::$app->formatter->asDate($evento->fecha_inicio, 'php:j'); ?>
                                                </div>
                                                <div class="cal-event-tile-month">
                                                    <?= substr(Yii::$app->formatter->asDate($evento->fecha_inicio, 'php:M'),0,3); ?>
                                                </div>
                                            </div>
                                            <div class="cal-event-desc">
                                                <div class="cal-event-title">
                                                    <?= $evento->evento ?>
                                                </div>
                                                <div class="cal-event-time">
                                                    <?= Yii::$app->formatter->asTime($evento->fecha_inicio, 'php:H:i'); ?>
                                                    , hasta 
                                                    <?= Yii::$app->formatter->asDate($evento->fecha_fin, 'long'); ?>
                                                        
                                                </div>
                                                <div class="cal-event-location">
                                                    <div class="cal-event-location-content">
                                                        <?php 
                                                            if (isset($evento->grupo))
                                                            {
                                                                $grupos = explode(',',$evento->grupo); 

                                                                foreach ($grupos as $grupo) {
                                                                    //$grupo = Grupo::find()->where(['id' => $idgrupo])->one();
                                                                    echo '<span class="label label-info">'.$grupo.'</span>&nbsp';
                                                                }
                                                            }
                                                            else
                                                            {
                                                                echo '<span class="label label-default">Todos</span>&nbsp';
                                                            }
                                                        ?>

                                                        <?php 
                                                            if (isset($evento->tipo_tercero))
                                                            {
                                                                $tipos = explode(',',$evento->tipo_tercero); 

                                                                foreach ($tipos as $tipo) {
                                                                    $tipo = Tipotercero::findOne($tipo);
                                                                    echo '<span class="label label-default">'.$tipo->tipo.'</span>&nbsp';
                                                                }
                                                            }
                                                            else
                                                            {
                                                                echo '<span class="label label-default">Todos</span>';
                                                            }
                                                        ?>

                                                            
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                                              
                                <?php } ?>  
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



                
  

         
