<?php

use yii\helpers\Html;
use yii\web\View; 

$this->registerJs('
    $(function(){
        $("#huerfanos").DataTable({
          "dom":"ftip",
          language: {
              search: "<i class=\"fas fa-search\"></i>",
              searchPlaceholder: "Buscar..."
          },
          "scrollY": "165px",
          "scrollCollapse": true,
          "paging": false,
          "bFilter": true,
          "bInfo" : false,
        });
    });
');

?>

<div class="row gutter">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="ibox ">
            <div class="ibox-title">
                <h5><i class="fas fa-users text-danger"></i> Estudiantes &nbsp;<small>Sin Grupo</small></h5>
                <div class="ibox-tools">
                    <span class="label label-danger"><?= count($huerfanos) ?></span>

                    <a class="collapse-link">
                        <i class="fa fa-chevron-up"></i>
                    </a>
                    <a class="fullscreen-link">
                        <i class="fas fa-expand-alt"></i>
                    </a>
                    <a class="close-link">
                        <i class="fa fa-times"></i>
                    </a>    
                </div>
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <table id="huerfanos" class="table">
                            <thead>
                                <tr>
                                    <th></th>
                                    <th>Estudiante</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    foreach($huerfanos as $huerfano)
                                    { 
                                ?>
                                        <tr>
                                            <td><?= Html::img($huerfano->foto ? '@web/uploads/thumbnail/sm-'.$huerfano->foto : '@web/images/user.jpg', ['class'=>'img-36 rounded-circle']); ?></td>
                                            <td>
                                                <?= Html::a($huerfano->nombre,['/academico/create', 'tercero' => $huerfano->id]) ?>
                                            </td>
                                        </tr>
                                                              
                                <?php } ?>  
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>