<?php


use sjaakp\gcharts\ColumnChart;
use backend\models\Grupo;
use yii\helpers\ArrayHelper;


/*
$this->registerCss("
    svg {
      min-width:  800px;
      height: auto;
      overflow: visible !important;
    }
");
*/

?>

<div class="row gutter">
  <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <div class="ibox ">
        <div class="ibox-title">
            <h5><i class="fas fa-chart-bar text-info"></i> Estudiantes Matriculados</h5>
            <div class="ibox-tools">
                
                <span class="label label-success" style="font-size:18px;"><?= $total_matriculados ?></span>

                <a class="collapse-link">
                    <i class="fa fa-chevron-up"></i>
                </a>
                <a class="close-link">
                    <i class="fa fa-times"></i>
                </a>
            </div>
        </div>
        <div class="ibox-content">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <ul class="nav nav-tabs">
                        <li class="active"><a data-toggle="tab" href="#tab-1">Grupos</a></li>
                        <li><a data-toggle="tab" href="#tab-2">Grupos y Géneros</a></li>
                        <li><a data-toggle="tab" href="#tab-3">Géneros</a></li>
                        <li><a data-toggle="tab" href="#tab-4">Nacionalidad</a></li>
                        <li><a data-toggle="tab" href="#tab-5">Aprobados & Reprobados</a></li>
                    </ul>

                    <div class="tab-content">
                        <div id="tab-1" class="tab-pane active">

                            <?= \onmotion\apexcharts\ApexchartsWidget::widget([
                                    'type' => 'bar', // default area
                                    //'height' => '400', // default 350
                                    'width' => '100%', // default 100%
                                    'chartOptions' => [
                                        'chart' => [
                                            'toolbar' => [
                                                'show' => true,
                                                'autoSelected' => 'zoom',
                                            ],
                                            'zoom' => true,
                                        ],
                                        'xaxis' => [
                                            //'type' => 'datetime',
                                            'categories' => ArrayHelper::getColumn($matriculados,'grupo'),
                                        ],
                                        'yaxis' => [
                                            'title' => [
                                                'text' => 'Total de Matriculados'
                                            ]
                                        ],
                                        'plotOptions' => [
                                            'bar' => [
                                                'horizontal' => false,
                                                'distributed' => true,
                                                //'endingShape' => 'rounded'
                                            ],
                                        ],
                                        'dataLabels' => [
                                            'enabled' => true
                                        ],
                                        'stroke' => [
                                            'show' => true,
                                            //'width' => 2,
                                            'colors' => ['transparent']
                                        ],
                                        'legend' => [
                                            'verticalAlign' => 'bottom',
                                            'horizontalAlign' => 'left',
                                        ],
                                    ],
                                    'series' => [[
                                            'name' => 'Matriculados',
                                            'data' => ArrayHelper::getColumn($matriculados,'matriculados')
                                        ]],
                                ]);
                            ?>
                        </div>

                        <div id="tab-2" class="tab-pane">
                            <?= \onmotion\apexcharts\ApexchartsWidget::widget([
                                    'type' => 'bar', // default area
                                    //'height' => '400', // default 350
                                    'width' => '100%', // default 100%
                                    'chartOptions' => [
                                        'chart' => [
                                            'toolbar' => [
                                                'show' => true,
                                                'autoSelected' => 'zoom',
                                            ],
                                            'zoom' => [
                                                'enabled' => true
                                            ],
                                            'title' => [
                                                'text' => 'Estudiantes Matriculados por Grupos y Géneros'
                                            ],
                                            'stacked' => true,
                                        ],
                                        'colors' => ['#008ffb', '#ff4560'],
                                        'xaxis' => [
                                            //'type' => 'datetime',
                                            'categories' => ArrayHelper::getColumn($matriculadosxgeneroxgrupo,'grupo'),
                                        ],
                                        'yaxis' => [
                                            'title' => [
                                                'text' => 'Total de Matriculados'
                                            ]
                                        ],
                                        'plotOptions' => [
                                            'bar' => [
                                                'horizontal' => false,
                                                //'endingShape' => 'rounded'
                                            ],
                                        ],
                                        'dataLabels' => [
                                            'enabled' => true,
                                        ],
                                        'stroke' => [
                                            'show' => true,
                                            'width' => 2,
                                            'colors' => ['transparent']
                                        ],
                                        'legend' => [
                                            'verticalAlign' => 'bottom',
                                            'horizontalAlign' => 'left',
                                        ],
                                    ],
                                    'series' => [
                                        [
                                            'name' => 'Masculino',
                                            'data' => ArrayHelper::getColumn($matriculadosxgeneroxgrupo,'masculino'),
                                        ],
                                        [
                                            'name' => 'Femenino',
                                            'data' => ArrayHelper::getColumn($matriculadosxgeneroxgrupo,'femenino'),
                                        ],
                                    ],
                                ]);
                            ?>
                        </div>    
                        <div id="tab-3" class="tab-pane">
                            
                            <?= \onmotion\apexcharts\ApexchartsWidget::widget([
                                    'type' => 'bar', // default area
                                    //'height' => '400', // default 350
                                    'width' => '100%', // default 100%
                                    'chartOptions' => [
                                        'chart' => [
                                            'toolbar' => [
                                                'show' => true,
                                                'autoSelected' => 'zoom',
                                            ],
                                            'zoom' => [
                                                'enabled' => true
                                            ],
                                            'title' => [
                                                'text' => 'Estudiantes Matriculados Géneros'
                                            ],
                                            'stacked' => false,
                                        ],
                                        'colors' => ['#008ffb', '#ff4560'],
                                        'xaxis' => [
                                            //'type' => 'datetime',
                                            'categories' => ArrayHelper::getColumn($generos,'generos'),
                                        ],
                                        'yaxis' => [
                                            'title' => [
                                                'text' => 'Total de Matriculados'
                                            ]
                                        ],
                                        'plotOptions' => [
                                            'bar' => [
                                                'horizontal' => false,
                                                'columnWidth' => '45%',
                                                'distributed' => false,
                                                //'endingShape' => 'rounded'
                                            ],
                                        ],
                                        'dataLabels' => [
                                            'enabled' => true
                                        ],
                                        'stroke' => [
                                            'show' => true,
                                            //'width' => '98%',
                                            'colors' => ['transparent']
                                        ],
                                        'legend' => [
                                            'verticalAlign' => 'bottom',
                                            'horizontalAlign' => 'left',
                                        ],
                                    ],
                                    'series' => [
                                                    [
                                                        'name' => 'Masculino',
                                                        'data' => ArrayHelper::getColumn($generos,'masculino')
                                                    ],
                                                    [
                                                        'name' => 'Femenino',
                                                        'data' => ArrayHelper::getColumn($generos,'femenino')
                                                    ],
                                                ],
                                ]);
                            ?>
                        </div>    
                        <div id="tab-4" class="tab-pane">
                            <?= \onmotion\apexcharts\ApexchartsWidget::widget([
                                    'type' => 'bar', // default area
                                    //'height' => '400', // default 350
                                    'width' => '100%', // default 100%
                                    'chartOptions' => [
                                        'chart' => [
                                            'toolbar' => [
                                                'show' => true,
                                                'autoSelected' => 'zoom',
                                            ],
                                            'zoom' => true,
                                        ],
                                        'xaxis' => [
                                            //'type' => 'datetime',
                                            'categories' => ArrayHelper::getColumn($nacionalidades,'pais'),
                                        ],
                                        'yaxis' => [
                                            'title' => [
                                                'text' => 'Total de Matriculados'
                                            ]
                                        ],
                                        'plotOptions' => [
                                            'bar' => [
                                                'horizontal' => false,
                                                'columnWidth' => '45%',
                                                'distributed' => true,
                                                //'endingShape' => 'rounded'
                                            ],
                                        ],
                                        'dataLabels' => [
                                            'enabled' => true
                                        ],
                                        'stroke' => [
                                            'show' => true,
                                            //'width' => 2,
                                            'colors' => ['transparent']
                                        ],
                                        'legend' => [
                                            'verticalAlign' => 'bottom',
                                            'horizontalAlign' => 'left',
                                        ],
                                    ],
                                    'series' => [
                                                    [
                                                        'name' => 'País',
                                                        'data' => ArrayHelper::getColumn($nacionalidades,'matriculados')
                                                    ],
                                                ],
                                ]);
                            ?>
                        </div>

                        <div id="tab-5" class="tab-pane">
                            <?= \onmotion\apexcharts\ApexchartsWidget::widget([
                                    'type' => 'bar', // default area
                                    //'height' => '100%', // default 350
                                    'width' => '100%', // default 100%
                                    'chartOptions' => [
                                        'chart' => [
                                            'toolbar' => [
                                                'show' => true,
                                                'autoSelected' => 'zoom',
                                            ],
                                            'zoom' => [
                                                'enabled' => true
                                            ],
                                            'title' => [
                                                'text' => 'Estudiantes Aprobados y Reprobados por Grupos'
                                            ],
                                            'stacked' => true,
                                        ],
                                        'colors' => ['#008ffb', '#ff4560'],
                                        'xaxis' => [
                                            //'type' => 'datetime',
                                            'categories' => ArrayHelper::getColumn($aprobadosxgrupo,'grupo'),
                                        ],
                                        'yaxis' => [
                                            'title' => [
                                                'text' => 'Total de Estudiantes'
                                            ]
                                        ],
                                        'plotOptions' => [
                                            'bar' => [
                                                'horizontal' => false,
                                                //'endingShape' => 'rounded'
                                            ],
                                        ],
                                        'dataLabels' => [
                                            'enabled' => true
                                        ],
                                        'stroke' => [
                                            'show' => true,
                                            //'width' => 2,
                                            'colors' => ['transparent']
                                        ],
                                        'legend' => [
                                            'verticalAlign' => 'bottom',
                                            'horizontalAlign' => 'left',
                                        ],
                                    ],
                                    'series' => [
                                                    [
                                                        'name' => 'Aprobados',
                                                        'data' => ArrayHelper::getColumn($aprobadosxgrupo,'aprobados')
                                                    ],
                                                    [
                                                        'name' => 'Reprobados',
                                                        'data' => ArrayHelper::getColumn($aprobadosxgrupo,'reprobados')
                                                    ],
                                                ],
                                ]);
                            ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
  </div>
</div>



                
  

         
