<?php
use backend\assets\AppAsset;
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use backend\models\Tercero;

$this->title = 'Bloqueado';
$this->params['breadcrumbs'] = $this->title;

$tercero = Tercero::find()->where(['identificacion' => $model->username])->one();
?>
       
        <?php $form = ActiveForm::begin([
            'id' => 'login-form', 
            'class' => 'm-t',
            'action' => ['site/login'], 
        ]); ?>
        
            <input id="previous" type="hidden" value="<?= $previous ?>" name="previous">

            <div class="lockscreen-wrapper">
                <div class="avatar">
                    
                    <?php

                        if($model->username != 'admin')
                        {
                            echo Html::img($tercero->foto ? '@web/uploads/thumbnail/sm-'.$tercero->foto : '@web/images/sonic-locked.png', ['class'=>'img-responsive']);  
                        }
                        else
                        {
                            echo Html::img('@web/images/sonic-locked.png', ['class'=>'img-responsive']);
                        }    
                    ?>    
                    
                    <span class="lock">
                        <i class="fa fa-lock fa-lg"></i>

                    </span>
                </div>
                <h3 class="heading">
                    <?  
                        echo Html::activeHiddenInput($model, 'username');
                        echo Html::activeHiddenInput($model, 'rememberMe');
                        
                        echo ($model->username == 'admin') ? 'Administrador Sonic' : $tercero->nombre;
                    ?>
                </h3>
                <h5 class="heading">Debe ingresar su contraseña para acceder a la pantalla de administración.</h5>
                <div class="subscribe-form">
                    <?= $form->field($model, 'password')->passwordInput(['placeholder' => $model->getAttributeLabel('password'), 'class' => 'subscribe-email'])->label(false) ?>
            
                    <?= Html::submitButton('<i class="fa fa-arrow-right"></i>', ['class' => 'subscribe-btn','id' => 'subscribe', 'name' => 'login-button']) ?>

                </div>
                
                <?= Html::a('inicie sesión como un usuario diferente', ['site/login'], ['class' => '', 'alt'=>'Iniciar con otro usuario',]) ?>
                
            </div>

        <?php ActiveForm::end(); ?>

