<?php
use backend\assets\AppAsset;
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use backend\models\Sede;


$this->title = 'Inicia sesión';

$sede = Sede::find()->where(['principal' => 1])->one();

$this->registerCss("
.sede{
  font-size:20px;
  font-weight: 900;
  color : #0085B2;
  margin-bottom:5px;
  

}

.slogan{
  font-size:16px;
  font-weight: 700;
  color : #489DA5;
}
  ");
?>

<script type="text/javascript">
  function showHidePassword() {
    let isPassword = $('#loginform-password').attr('type') === 'password';
    if (isPassword) {
        $('#loginform-password').attr('type', 'text');
        $('#showPasswordBtn').removeClass('fa-eye');
        $('#showPasswordBtn').addClass('fa-eye-slash');
    } else {
        $('#loginform-password').attr('type', 'password');
        $('#showPasswordBtn').removeClass('fa-eye-slash');
        $('#showPasswordBtn').addClass('fa-eye');
    }
}
</script>

    <!-- Main Container start -->
    <div class="dashboard-container">

      <div class="container">

        <!-- Row Start -->
        <div class="row login">
          <div class="col-lg-4 col-md-4 col-md-offset-4">
            <div class="sign-in-container">
             <?php $form = ActiveForm::begin(['options' => ['id' => 'request-password-reset-form', 'role' => 'form', 'class' => 'login-wrapper' ]]); ?>   
                <div class="header">
                  <div class="row gutter">
                    <div class="col-md-12 col-lg-12">
                      <?
                          if($sede->logo == NULL)
                          {
                              echo Html::img('@web/images/login-sonic.png', ['class' => 'img-responsive', 'style' => 'max-height: 220px; margin: 0 auto;']);
                          }
                          else
                          {
                              echo Html::img('@web/images/'.$sede->logo, ['class' => 'img-responsive', 'style' => 'max-height: 220px; margin: 0 auto;']);
                          }  
                      ?>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <center>
                          <h4 class="sede"><?= $sede->sede; ?></h4>
                          <span class="slogan"><?= $sede->slogan; ?></span> 
                        </center>
                        <p align="justify">Por favor complete su usuario. Se enviará un enlace al correo electrónico para restablecerla, sino cuenta con uno configurado deberá acercarce a la institución educativa para reestablecer su contraseña.</p>
                        
                    </div>
                  </div>
                </div>
                <div class="content">
                  <div class="form-group">
                    <?= $form->field($model, 'username', [
                                'addon' => ['prepend' => ['content' => '<i class="fa fa-user"></i>']],
                                'inputOptions' => [
                                    'placeholder' => $model->getAttributeLabel('username'),
                                    'class' => 'form-control',
                                ]])->label(false);
                    ?>
                  </div>
                  
                </div>
                <div class="actions">

                    <?= Html::submitButton('Reestablecer Contraseña', ['class' => 'btn btn-danger', 'name' => 'login-button']) ?>
                    
                    <?= Html::a('Iniciar Sesión', ['site/login'],['class' => 'link']) ?>                              
                  <div class="clearfix"></div>
                </div>
                
              <?php ActiveForm::end() ?> 
              
            </div>
          </div>

        </div>
        <!-- Row End -->

        <div>
          <?= Html::img('@web/images/sonic-logo-blanco.png', ['class' => 'img-responsive', 'style' => 'margin: 0 auto;']); ?>
        </div>
        
      </div>
    </div>
    <!-- Main Container end -->
