<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use kartik\widgets\FileInput;
use dosamigos\tinymce\TinyMce;
use yii\web\JsExpression;


$this->registerJs("
    $('#slide-tipo').change(function(){
        if (this.value == 1)
        {
            $('#imagen').fadeIn(500); 
            $('#video').fadeOut(500); 
        }
        else
        {
            $('#video').fadeIn(500); 
            $('#imagen').fadeOut(500); 
                
        }    
    });
");

?>


<?php $form = ActiveForm::begin([
            //'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>

<div class="documento-form">

    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Archivo</h3>
        </div>

        <div class="panel-body" >

            <?= $form->errorSummary($model); ?>

            <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
        
            <div class="row">

                <div class="col-sm-3">
                    <?= $form->field($model, 'titulo')->textInput(['maxlength' => true, 'placeholder' => 'Titulo']) ?>
                </div>       

                <div class="col-sm-3">     

                    <?= $form->field($model, 'enlace')->textInput(['maxlength' => true, 'placeholder' => 'Enlace']) ?>
                </div>       

                <div class="col-sm-3">     

                    <?= $form->field($model, 'target')->widget(\kartik\widgets\Select2::classname(), [
                        'data' => ['_blank' => 'Nueva Ventana', '_self' => 'Misma Ventana'],
                        'options' => ['placeholder' => Yii::t('app', 'Seleccione Target')],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>       
            
                <div class="col-sm-3">     

                    <?= $form->field($model, 'tipo')->widget(\kartik\widgets\Select2::classname(), [
                        'data' => ['1' => 'Imagen', '2' => 'Video'],
                        'options' => ['placeholder' => Yii::t('app', 'Seleccione el Tipo')],
                        'pluginOptions' => [
                            'allowClear' => false,
                            
                        ],
                    ]); ?>
                </div> 
            </div>

            <div id="imagen" class="row" style="display:none;">
                <div class="col-sm-12">     

                    <?= $form->field($model, 'imagen')->widget(FileInput::classname(), [
                        'options' => ['multiple'=>false],
                        'pluginOptions'=>[
                            //'uploadUrl' => Url::to(['/site/file-upload']),
                            //'allowedFileExtensions'=>['jpg', 'gif', 'png', 'bmp','pdf','doc', 'docx','xls'],
                            'previewFileType' => 'any',
                            'showUpload' => false,
                            'overwriteInitial' => false,
                            'browseClass' => 'btn btn-primary',
                            'uploadClass' => 'btn btn-success',
                            'removeClass' => 'btn btn-danger',
                            'removeIcon' => '<i class="glyphicon glyphicon-trash"></i>',
                            ],
                    ])->label(); ?>
                </div>       
            </div>

            <div id="video" class="row"  style="display:none;">
                <div class="col-sm-12">     
                    <?= $form->field($model, 'video')->textInput(['maxlength' => true, 'placeholder' => 'Video']) ?>
                </div>  
            </div>

            <div class="row">      

                <div class="col-sm-12">     

                    <?= $form->field($model, 'descripcion')->widget(TinyMce::className(), [
                        'options' => ['rows' => 6],
                        'language' => 'es',
                        'clientOptions' => [
                            'plugins' => [
                                "advlist autolink lists link charmap print preview anchor",
                                "searchreplace visualblocks code fullscreen",
                                "insertdatetime media image table contextmenu paste"
                            ],
                            'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
                        ]
                    ])->label();?>
                </div>       
            </div>
                     
            <div class="row">
                <div class="col-sm-3">     
                    <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

                    <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Activo',
                            'offText'=>'Inactivo'
                        ]]) 
                    ?>

                </div> 

            </div>

            <?php ActiveForm::end(); ?>

        </div>
    </div>
</div>

