<?php

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;

//$this->title = 'Asignaturas';
$this->title = Yii::t('app', 'Documentos');

$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";

$this->registerJs($search);

$this->registerCss("

.video-responsive {
position: relative;
padding-bottom: 56.25%; /* 16/9 ratio */
padding-top: 30px; /* IE6 workaround*/
height: 0;
overflow: hidden;
max-width:100px;
margin:auto;
}

.video-responsive iframe,
.video-responsive object,
.video-responsive embed {
position: absolute;
top: 0;
left: 0;
width: 100%;
height: 100%;
}
");

?>

<div class="slide-index">


    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        'titulo',
        [
            'attribute' => 'tipo',
            'label' => Yii::t('app', 'Tipo'),
            'format' => 'RAW',
            'value' => function($model){ 
                if($model->tipo == '1')
                {
                    return '<center><h3><i class="far fa-image text-info"></i></h3></center>';
                }                  
                else
                {
                    return '<center><h3><i class="far fa-video text-danger"></i></h3></center>';
                }
                //return Html::img(Yii::getAlias('@frontend') . '../web/images/slide/'.$model->imagen, ['class' => 'img-responsive']);
            },
            
        ],
        [
            'attribute' => 'enlace',
            'label' => Yii::t('app', 'Enlace'),
            'format' => 'RAW',
            'value' => function($model){ 
                if($model->enlace != '')
                {
                    return '<a href="'.$model->enlace.'" target = "_blank" data-pjax = "0">Ver Enlace</a>';    
                }                  
                else
                {
                    return '';
                }
                //return Html::img(Yii::getAlias('@frontend') . '../web/images/slide/'.$model->imagen, ['class' => 'img-responsive']);
            },
            
        ],
        'descripcion',
        [
            'attribute' => 'imagen',
            'label' => Yii::t('app', 'Media'),
            'format' => 'RAW',
            'value' => function($model){                   
                if($model->tipo == 1)
                {
                   return Html::img('../../images/slide/'.$model->imagen, ['class' => 'img-responsive', 'style' =>'max-width:100px; margin:auto;']); 
                }
                else
                {
                    return '<div class="video-responsive">'.$model->video.'</div>';
                }
                
                //return Html::img(Yii::getAlias('@frontend') . '../web/images/slide/'.$model->imagen, ['class' => 'img-responsive']);
            },
            
        ],
        
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class' => 'yii\grid\ActionColumn',
        ],
    ]; 
    ?>




<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'slide'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?> 

</div>
