<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

$this->title = $model->categoria;
$this->params['breadcrumbs'][] = ['label' => 'Slides', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Ver';

$this->params['actions'][] = ['label' => 'Actualizar', 'url' => 'update', 'id' => $model->id, 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
//$this->params['actions'][] = ['label' => 'PDF', 'url' => 'pdf', 'id' => $model->id, 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Eliminar', 'url' => 'delete', 'id' => $model->id, 'icon' => '<i class="far fa-trash-alt"></i>', 'class' => 'danger'];

?>
<div class="slide-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Slide').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'titulo',
        'tipo',
        'enlace:ntext',
        'target',
        'descripcion',
        'imagen',
        'video',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
</div>
