<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->desarrollos,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'estudiante',
            'label' => Yii::t('app', 'Estudiante'),
            'value' => function($model){
                if ($model->estudiantes)
                {return $model->estudiantes->nombre;}
                else
                {return NULL;}
            },
            
            'visible' => true,
        ],
        [
            'attribute' => 'creado_el',
            'label' => Yii::t('app', 'Entregado'),
            'value' => function($model){                   
                return Yii::$app->formatter->asDatetime($model->creado_el, 'long');
            },
        ],
        [

                'attribute' => 'revisado_por',
                'label' => 'Estado',
                'format' => 'RAW',
                'value' => function($model){
                    
                        if ($model->revisado_por == NULL)
                        {
                            return '<span class="label label-danger">Sin Revisar</span>';
                        }

                        if ($model->revisado_por != NULL)
                        {
                            return '<span class="label label-success">Revisado</span>';
                        }
                },

                'contentOptions'=>['style'=>'width: 120px; text-align:center;'],
        ],
        [
            'attribute' => 'revisado_el',
            'label' => Yii::t('app', 'Fecha de Revisión'),
            'format' => 'RAW',
            'value' => function($model){                   
                return Yii::$app->formatter->asDatetime($model->revisado_el, 'long');
            },
        ],
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'tareadesarrollo'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
