<?php
########################################################
#                                                      #
#               GOOD SOLUTIONS COLOMBIA                #
#            www.gsol.co - contacto@gsol.co            #
#                     GSOL Colombia                    #
#                   N.I.T 900065739-7                  #
########################################################

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\widgets\ActiveForm;
use \yii\helpers\ArrayHelper;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;
use dosamigos\tinymce\TinyMce;
use kartik\daterange\DateRangePicker;
use kartik\widgets\TouchSpin;


use backend\models\Tercero;
use backend\models\Tipotercero;
use backend\models\Carga;
use backend\models\Grupo;
use backend\models\Periodo;
use backend\models\Asignatura;


$this->registerJs("
    $(document).ready(function(){
        $('.i-checks').iCheck({
            checkboxClass: 'icheckbox_square-green',
            radioClass: 'iradio_square-green',
        });
    });
");


?>

<div class="row">
    <div class="col-lg-2">
        <?= $this->render('_panel',['model' => $model]) ?>
    </div>
    
    <div class="col-lg-10">
    
        <div class="mail-box-header">
            <h3>
                <?=  $model->isNewRecord ? Yii::t('app', 'Crear Tarea') : Yii::t('app', 'Editar Tarea'); ?>
            </h3>
        </div>
        <div class="mail-box">
            <div class="mail-body">

                <?php $form = ActiveForm::begin([
                    'validateOnSubmit' => true,
                    'type' => ActiveForm::TYPE_VERTICAL,
                    'options' => ['class' => 'form-horizontal',
                                  'id' => 'formulario',
                                  'enctype'=>'multipart/form-data',
                                ]
                ]); ?>  


                <?= $form->errorSummary($model); ?>

                <div class="row">
                                        
                    <div class="col-sm-3">

                        <?= $form->field($model, 'grupo')->widget(Select2::classname(), [
                            'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::getGrupobyDocente(Yii::$app->session->get('__tercero')), 'id', 'grupo'),
                            //'data' => ArrayHelper::map(Carga::find()->select(['grupo.id', 'grupo.grupo'])->joinWith(['grupos'])->where(['carga.docente' => Yii::$app->session->get('__tercero')])->orderBy('grupo.id')->asArray()->all(), 'id', 'grupo'),
                            //'data' => ArrayHelper::map(Carga::find()->select(['grupo.id', 'grupo.grupo'])->joinWith(['grupos'])->orderBy('grupo.id')->asArray()->all(), 'id', 'grupo'),
                            'options' => ['id'=>'grupo-id', 'placeholder' => 'Seleccione el Grupo',],
                            'pluginOptions' => [
                                'allowClear' => true,
                            ],
                        ]) ?>

                    </div>
                    <div class="col-sm-6">
                        <? 
                            if($model->isNewRecord)
                            {
                                $asignaturas = [];
                            }
                            else
                            {
                                $asignaturas = Carga::find()->select(['asignatura.id', 'asignatura.asignatura'])->joinWith(['asignaturas'])->where(['carga.docente' => Yii::$app->session->get('__tercero')])->orderBy('asignatura.id')->asArray()->all();
                            }
                        ?>
                        <?= $form->field($model, 'asignatura')->widget(DepDrop::classname(), [
                            'data' => ArrayHelper::map($asignaturas, 'id', 'asignatura'),
                            'type'=>DepDrop::TYPE_SELECT2,
                            'options'=>['id'=>'asignatura-id'],
                            'pluginOptions'=>[
                                'placeholder'=>'Seleccione',
                                'multiple' => false,
                                'depends'=>['grupo-id'],
                                'url'=>Url::to(['publica/findasignaturasbygrupo']),
                            ]
                        ]);
                        ?>

                    </div>
                    <div class="col-sm-3">
                        <? 
                            if($model->isNewRecord)
                            {
                                $periodo = new Periodo();
                                $model->periodo = $periodo->actual->id;
                            }    
                        ?>    
                        <?= $form->field($model, 'periodo')->widget(Select2::classname(), [
                            'data' => \yii\helpers\ArrayHelper::map(Periodo::find()->where(['estado' => 1])->orderBy('id')->asArray()->all(), 'id', 'periodo'),
                            'options' => ['placeholder' => 'Seleccione el Periodo'],
                            'pluginOptions' => [
                                'allowClear' => true
                            ],
                        ]); ?>
                    </div>
                </div>

                <div class="row">

                    <div class="col-sm-12">

                        <?= $form->field($model, 'tarea')->textInput(['maxlength' => true, 'placeholder' =>'Tarea']) ?>
                
                    </div>
                </div>
                
                <div class="row">
                                        
                    <div class="col-sm-3">

                        <?= $form->field($model, 'tipo')->widget(\kartik\widgets\Select2::classname(), [
                            'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Tipotarea::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                            'options' => ['placeholder' => 'Seleccione el Tipo'],
                            'pluginOptions' => [
                                'allowClear' => true
                            ],
                        ]) ?>

                    </div>

                    <div class="col-sm-6">
                        <label>Disponible Desde y Hasta</label>    
            
                            <?php
                                $addon = '<span class="input-group-addon">
                                            <i class="glyphicon glyphicon-calendar"></i>
                                        </span>';

                                echo '<div class="input-group drp-container">';

                                if ($model->isNewRecord)
                                {
                                    date_default_timezone_set('America/Bogota');    
                                    $model->disponible_desde = date('Y-m-d H:i:s', strtotime( 'monday this week' ) );
                                    $model->disponible_hasta = date('Y-m-d H:i:s', strtotime( 'friday this week' ) );

                                    $model->rango = $model->disponible_desde." - ".$model->disponible_hasta;
                                }    

                                
                                echo DateRangePicker::widget([
                                    'model'=>$model,
                                    'attribute' => 'rango',
                                    'useWithAddon'=>true,
                                    'autoUpdateOnInit'=>true,
                                    'convertFormat'=>true,
                                    'presetDropdown' => false,
                                    'startAttribute' => 'disponible_desde',
                                    'endAttribute' => 'disponible_hasta',
                                    'pluginOptions'=>[
                                        'timePicker' => true,
                                        'locale'=>[
                                            'format' => 'Y-m-d H:i:s',
                                            'separator'=> ' al ',
                                        ],                                        
                                    ]
                                ]) . $addon;
                                echo '</div>';
                            ?>
                    </div>

                    <div class="col-sm-3">
                        <? $model->oportunidades = $model->isNewRecord ? 1 : $model->oportunidades; ?>

                        <?= $form->field($model, 'oportunidades')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Total de Oportunidades'],]);?>
                    </div>
                </div>


                <div class="row">
                    
                    <div class="col-sm-12">
                
                        <?= $form->field($model, 'descripcion')->widget(TinyMce::className(), [
                            'options' => ['rows' => 15],
                            'language' => 'es',
                            'clientOptions' => [
                                'plugins' => [
                                    "advlist autolink lists link charmap print preview anchor",
                                    "searchreplace visualblocks code fullscreen",
                                    "insertdatetime media image table contextmenu paste"
                                ],
                                'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
                            ]
                        ]) ?>

                    </div>
                </div>

                <div class="row">
                    
                    <div class="col-sm-12">

                        <?= $form->field($model, 'adjunto')->widget(FileInput::classname(), [
                            'options' => ['multiple'=>false],
                            'pluginOptions'=>[
                                //'uploadUrl' => Url::to(['/publica/upload']),
                                'allowedFileExtensions'=>['jpg', 'gif', 'png', 'bmp','pdf','doc', 'docx','xls'],
                                'previewFileType' => 'any',
                                'showUpload' => false,
                                'overwriteInitial' => false,
                                //'uploadAsync' => true,
                                //'enableResumableUpload' => true,
                                //'theme' => 'fas',
                                'deleteUrl' => Url::to(['/publica/delete']),
                                //'browseClass' => 'btn btn-primary',
                                //'uploadClass' => 'btn btn-success',
                                //'removeClass' => 'btn btn-danger',
                                'browseIcon' => '<i class="far fa-folder-open"></i>',
                                'uploadIcon' => '<i class="far fa-upload"></i>',
                                'cancelIcon' => '<i class="far fa-trash-alt"></i>',
                                'removeIcon' => '<i class="far fa-trash-alt"></i>',
                                ],
                        ])->label('Adjuntos:'); ?>
                    
                    </div>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>


    





