<?php

use yii\helpers\Html;
use backend\models\base\Mensajescategorias;
use backend\models\base\Mensajes;
use backend\models\Tipotarea;

?>
<div class="ibox float-e-margins">
    <div class="ibox-content mailbox-content">
        <div class="file-manager">

            <?= Html::a('Nueva Tarea', ['create'], ['class'=>'btn btn-block btn-lg btn-primary']) ?>

            <div class="space-25"></div>
            <br>
            <ul class="folder-list m-b-md" style="padding: 0">
                
                <li>
                    <?
                        $recibidos = Mensajes::find()->where(['remisor' => Yii::$app->session->get('__tercero'), 'visto' => '0'])->count();

                        if ($recibidos != '0')
                            $recibidos = '<span class="label label-warning pull-right">'.$recibidos.'</span>';
                        else
                            $recibidos = '';
                    ?>
                    <?= Html::a('<i class="far fa-inbox"></i> Mis Tareas '.$recibidos, ['index'], []) ?>
                </li>
                <li>
                    <?= Html::a('<i class="far fa-envelope"></i> Recibidos', ['enviados'], []) ?>
                </li>
                <li>
                    <?
                        $importantes = Mensajes::find()->where(['remisor' => Yii::$app->session->get('__tercero'), 'visto' => '0','importante' => '1'])->count();

                        if ($importantes != '0')
                            $importantes = '<span class="label label-primary pull-right">'.$importantes.'</span>';
                        else
                            $importantes = '';
                    ?>
                    <?= Html::a('<i class="far fa-certificate"></i> Importantes '.$importantes, ['importantes'], []) ?>
                </li>
                
                <li>
                    <?
                        $eliminados = Mensajes::find()->where(['remisor' => Yii::$app->session->get('__tercero'),'estado' => '0'])->count();

                        if ($eliminados != '0')
                            $eliminados = '<span class="label label-danger pull-right">'.$eliminados.'</span>';
                        else
                            $eliminados = '';
                    ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i> Eliminados '.$eliminados, ['eliminados'], []) ?>
                </li>
            </ul>
            <br>
            <ul class="category-list" style="padding: 0">
                <?
                    $tipos = Tipotarea::find()->all();

                    foreach ($tipos as $tipo) {
                        echo "<li>";
                        echo Html::a('<i class="fa fa-circle" style="color:'.$tipo->color.';"></i> '.$tipo->tipo, ['index', 'categoria' =>$tipo->id], []);
                        echo "</li>";
                    }
                ?>    
                
            </ul>
            <div class="clearfix"></div>
        </div>
    </div>
</div>
