<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\TareaSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;

$this->title = Yii::t('app', 'Tarea');
$this->params['breadcrumbs'][] = $this->title;
$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="tarea-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a(Yii::t('app', 'Create Tarea'), ['create'], ['class' => 'btn btn-success']) ?>
        <?= Html::a(Yii::t('app', 'Advance Search'), '#', ['class' => 'btn btn-info search-button']) ?>
    </p>
    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        'aid',
        [
                'attribute' => 'docente',
                'label' => Yii::t('app', 'Docente'),
                'value' => function($model){
                    if ($model->docente0)
                    {return $model->docente0->id;}
                    else
                    {return NULL;}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->asArray()->all(), 'id', 'id'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-tarea-search-docente']
            ],
        [
                'attribute' => 'estudiante',
                'label' => Yii::t('app', 'Estudiante'),
                'value' => function($model){                   
                    return $model->estudiante0->id;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->asArray()->all(), 'id', 'id'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-tarea-search-estudiante']
            ],
        [
                'attribute' => 'asignatura',
                'label' => Yii::t('app', 'Asignatura'),
                'value' => function($model){                   
                    return $model->asignatura0->asignatura;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Asignatura::find()->asArray()->all(), 'id', 'asignatura'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Asignatura', 'id' => 'grid-tarea-search-asignatura']
            ],
        [
                'attribute' => 'grupo',
                'label' => Yii::t('app', 'Grupo'),
                'value' => function($model){                   
                    return $model->grupo0->grupo;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->asArray()->all(), 'id', 'grupo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grupo', 'id' => 'grid-tarea-search-grupo']
            ],
        [
                'attribute' => 'periodo',
                'label' => Yii::t('app', 'Periodo'),
                'value' => function($model){                   
                    return $model->periodo0->periodo;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Periodo::find()->asArray()->all(), 'id', 'periodo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Periodo', 'id' => 'grid-tarea-search-periodo']
            ],
        'tarea',
        [
                'attribute' => 'tipo',
                'label' => Yii::t('app', 'Tipo'),
                'value' => function($model){
                    if ($model->tipo0)
                    {return $model->tipo0->id;}
                    else
                    {return NULL;}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\TipoTarea::find()->asArray()->all(), 'id', 'id'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tipo tarea', 'id' => 'grid-tarea-search-tipo']
            ],
        'descripcion:ntext',
        'adjunto:ntext',
        'disponible_desde',
        'disponible_hasta',
        'disponible_desde_2',
        'disponible_hasta_2',
        'desarrollo_1:ntext',
        'adjunto_1:ntext',
        'desarrollo_2:ntext',
        'adjunto_2:ntext',
        'calificacion',
        'observaciones',
        'visto',
        'visto_el',
        'estado',
        [
            'class' => 'yii\grid\ActionColumn',
        ],
    ]; 
    ?>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => $gridColumn,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-tarea']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span>  ' . Html::encode($this->title),
        ],
        'export' => false,
        // your toolbar can include the additional full export menu
        'toolbar' => [
            '{export}',
            ExportMenu::widget([
                'dataProvider' => $dataProvider,
                'columns' => $gridColumn,
                'target' => ExportMenu::TARGET_BLANK,
                'fontAwesome' => true,
                'dropdownOptions' => [
                    'label' => 'Full',
                    'class' => 'btn btn-default',
                    'itemsBefore' => [
                        '<li class="dropdown-header">Export All Data</li>',
                    ],
                ],
                'exportConfig' => [
                    ExportMenu::FORMAT_PDF => false
                ]
            ]) ,
        ],
    ]); ?>

</div>
