<?php
########################################################
#                                                      #
#               GOOD SOLUTIONS COLOMBIA                #
#            www.gsol.co - contacto@gsol.co            #
#                     GSOL Colombia                    #
#                   N.I.T 900065739-7                  #
########################################################

use yii\helpers\Html;
use yii\widgets\ListView;
use yii\widgets\Pjax;
use app\assets\AppAsset;
use yii\helpers\Url;
use kartik\nav\NavX;



$this->title = 'Mensajes Enviados';
$this->params['breadcrumbs'][] = ['label' => 'Mensajes', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Enviados';

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];


$this->registerJs("
        $('.search-button').click(function(){
            $('.search-form').toggle(1000);
            return false;
        });

        $(document).ready(function(){
            $('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });
        });");
?>

        <div class="row">
            <div class="col-lg-2">
                <?= $this->render('_panel',['dataProvider' => $dataProvider]) ?>
            </div>
            
            <div class="col-lg-10">
    
            <div class="mail-box-header">
                <h3>
                    Enviados 
                </h3>
            </div>
                <div class="mail-box">

                    <div class="mail-body">

                        <div class="search-form" style="display:none;">
                            <?=  $this->render('_search_enviados', ['model' => $searchModel]); ?>
                        </div>        

                        <table class="table table-hover table-mail">
                            
                            <?php if($dataProvider->getTotalCount() > 0) { ?> 
                                <thead>
                                    <tr>
                                        <th><i class="far fa-flag"></i></th>
                                        <th>Categoría</th>                                
                                        <th>Para</th>
                                        <th>Asunto</th>
                                        <th><i class="far fa-paperclip fa-lg"></i></th>
                                        <th>Fecha</th>                                
                                    </tr>
                                </thead>
                            <?php } ?> 

                            <tbody>
                                <?= ListView::widget([
                                    'dataProvider' => $dataProvider,   
                                    //'layout' => "{summary}\n{items}\n{pager}",
                                    //'viewParams' => ['periodo' => $periodo],
                                    'itemView' => '_mensajes_enviados',
                                    'itemOptions' => [
                                        'tag' => false,
                                    ],
                                ]) ?>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>
 