<?php


use yii\helpers\Html;
use yii\helpers\Url;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;
use yii\helpers\ArrayHelper;
use yii\db\Expression;

use backend\models\Tercero;
use backend\models\Grado;
use backend\models\Sede;
use backend\models\Jornada;
use backend\models\Metodologia;
use backend\models\Modalidad;
use backend\models\Especialidad;


$this->title = 'Tareas';
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

$search = "$('.search-button').click(function(){
    $('.search-form').toggle(1000);
    return false;
});";
$this->registerJs($search);
?>

<div class="tarea-index">

    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>

    <?php 

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $asignaturas = \backend\models\Carga::find()->select(['asignatura.id as id', 'concat(asignatura.asignatura, " - " , grado.grado) as asignatura'])->joinWith(['asignaturas', 'asignaturas.grados'])->where(['docente' => Yii::$app->session->get('__tercero')])->asArray()->all();
        }
        else
        {
            $asignaturas = \backend\models\Carga::find()->select(['asignatura.id as id', 'asignatura.asignatura as asignatura'])->joinWith(['asignaturas'])->asArray()->all();   
        }

    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        [
            'class' => 'kartik\grid\ExpandRowColumn',
            'width' => '50px',
            'value' => function ($model, $key, $index, $column) {
                return GridView::ROW_COLLAPSED;
            },
            'detail' => function ($model, $key, $index, $column) {
                return Yii::$app->controller->renderPartial('_expand', ['model' => $model]);
            },
            'headerOptions' => ['class' => 'kartik-sheet-style'],
            'expandOneOnly' => true
        ],
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'docente',
            'label' => Yii::t('app', 'Docente'),
            'value' => function($model){
                if ($model->docentes)
                {return $model->docentes->nombre;}
                else
                {return NULL;}
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['estado' => '5'])->andWhere(['tipo_tercero' => '2'])->asArray()->all(), 'id', 'nombre'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-tarea-search-docente'],
            'visible' => Yii::$app->session->get('__tipo') == '2' ? false : true,
        ],
        [
                'attribute' => 'asignatura',
                'label' => Yii::t('app', 'Asignatura'),
                'value' => function($model){                   
                    return $model->asignaturas->asignatura;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map($asignaturas, 'id', 'asignatura'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Asignatura', 'id' => 'grid-tarea-search-asignatura']
            ],
        [
                'attribute' => 'grupo',
                'label' => Yii::t('app', 'Grupo'),
                'value' => function($model){                   
                    return $model->grupos->grupo;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::getGrupobyDocente(Yii::$app->session->get('__tercero')), 'id', 'grupo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grupo', 'id' => 'grid-tarea-search-grupo']
            ],
        [
                'attribute' => 'periodo',
                'label' => Yii::t('app', 'Periodo'),
                'value' => function($model){                   
                    return $model->periodos->periodo;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Periodo::find()->asArray()->all(), 'id', 'periodo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Periodo', 'id' => 'grid-tarea-search-periodo']
            ],
        
        [
                'attribute' => 'tarea',
                'label' => Yii::t('app', 'Tarea'),
        ],
        [
            'attribute' => 'adjunto',
            'label' => Yii::t('app', 'Adjunto'),
            'format' => 'raw',
            'value' => function($model){

                    if($model->adjunto != "")
                    {
                        $adjunto = json_decode(json_encode($model->adjunto),true);

                        //$adjunto["ObjectURL"]


                        $largo = strlen($adjunto["ObjectURL"]) - 46;
                        $archivo = substr($adjunto["ObjectURL"], 46, $largo);
                        $ext = substr($adjunto["ObjectURL"], -4);
                        
                        
                        switch ($ext) {
                            
                            case '.jpg':
                                    $icon = 'far fa-file-image';
                                break;

                            case '.png':
                                    $icon = 'far fa-file-image';
                                break; 

                            case '.gif':
                                    $icon = 'far fa-file-image';
                                break;       

                            case '.pdf':
                                    $icon = 'far fa-file-pdf';
                                break;
                            case '.xls':
                                    $icon = 'far fa-file-excel';
                                break;
                            case 'xlsx':
                                    $icon = 'far fa-file-excel';
                                break;
                            case '.csv':
                                    $icon = 'far fa-file-csv';
                                break;       
                            case 'docx':
                                    $icon = 'far fa-file-word';
                                break;
                            case '.doc':
                                    $icon = 'far fa-file-word';
                                break;
                            case 'pptx':
                                    $icon = 'far fa-file-powerpoint';
                                break;
                            case '.ppt':
                                    $icon = 'far fa-file-powerpoint';
                                break;
                                    
                            default:
                                    $icon = 'far fa-file';
                                break;
                        }
                            
                        return Html::a('<i class="'.$icon.'"></i> Descargar', Url::to($adjunto["ObjectURL"]), ['data-pjax'=>0, 'target' => '_blank', 'class' => 'btn btn-danger', 'title'=> urldecode($archivo)]);

                    }
                    else
                    {
                        return false;
                    }

            }
        ],
        [
                'attribute' => 'tipo',
                'label' => Yii::t('app', 'Tipo'),
                'value' => function($model){
                    if ($model->tipos)
                    {return $model->tipos->tipo;}
                    else
                    {return NULL;}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tipotarea::find()->asArray()->all(), 'id', 'id'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tipo tarea', 'id' => 'grid-tarea-search-tipo'],
                'visible' => false
            ],
        [
                'attribute' => 'descripcion',
                'label' => Yii::t('app', 'Descripción'),
                'visible' => false
        ],
        [
            'attribute' => 'disponible_desde',
            'label' => 'Disponible Desde',
            'filterType' => GridView::FILTER_DATE,
            'filterWidgetOptions' => [
                'language' => 'es',
                'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true,'autoclose' => true],
            ],
            'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-tarea-search-disponible-desde']
           
        ],
        [
            'attribute' => 'disponible_hasta',
            'label' => 'Disponible Hasta',
            'filterType' => GridView::FILTER_DATE,
            'filterWidgetOptions' => [
                'language' => 'es',
                'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true,'autoclose' => true],
            ],
            'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-tarea-search-disponible-desde']
           
        ],
        [
            'attribute' => 'oportunidades',
            'label' => 'Oportunidades',
            'format' => 'raw',
            'value' => function($model){
                            return  '<span class="label label-default">'.$model->oportunidades.'</span>';
                        },
            'visible' => false
        ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class' => 'yii\grid\ActionColumn',
        ],
    ]; 
    ?>


<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'tarea'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>

</div>
