<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;
use kartik\grid\GridView;
use backend\models\Tareadesarrollo;
use kartik\export\ExportMenu;



/* @var $this yii\web\View */
/* @var $model backend\models\Tarea */

$this->title = $model->tarea;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Tarea'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Panel del Docente', 'url' => '../docente/index', 'icon' => '<i class="far fa-tachometer-alt-fastest"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

?>

<div class="panel panel-default">
    <div class="panel-heading">
      <div class="pull-right">
        <?= Html::a(Yii::t('app', 'Actualizar'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary btn-xs']) ?>
        <?= Html::a(Yii::t('app', 'Eliminar'), ['delete', 'id' => $model->id], [
            'class' => 'btn btn-xs btn-danger',
            'data' => [
                'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ])
        ?>
      </div>
      <h4 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> <?= Yii::t('app', 'Tarea') ?></h4>
    </div>

    <div class="panel-body" >

        <div class="row">
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Docente') ?></label>
                <?= $model->docentes->nombre ?>
            </div>
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Grupo') ?></label>
                <?= $model->grupos->grupo ?>
            </div>
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Asignatura') ?></label>
                <?= $model->asignaturas->asignatura ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Disponible Desde') ?></label>
                <?= Yii::$app->formatter->format($model->disponible_desde, 'datetime'); ?>
            </div>
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Disponible Hasta') ?></label>
                <?= Yii::$app->formatter->format($model->disponible_hasta, 'datetime'); ?>
            </div>
            <div class="col-sm-4">
                <label><?= Yii::t('app', 'Finaliza') ?></label>
                <?= Yii::$app->formatter->format($model->disponible_hasta, 'relativeTime'); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <label><?= Yii::t('app', 'Tarea') ?></label>
                <?= Html::decode($model->tarea); ?>    
            </div>
        </div>

        <div class="row p20">
            <div class="col-sm-12">
                    <button data-toggle="collapse" data-target="#demo" class="btn btn-danger"><i class="far fa-eye"></i> <?= Yii::t('app', 'Mostrar Detalles') ?></button>  
            </div>
        </div>

        <div class="row p20">
            <div class="col-sm-12">
                <div id="demo" class="contenido form-group collapse">
                    <?= Html::decode($model->descripcion); ?>  



            <?php 
                if ($model->adjunto != '') 
                {
                    //$adjuntos = explode(',', $model->adjunto); 
                    //$adjuntos_cantidad = count($adjuntos);

                    //echo "2<pre>";
                    //var_dump($adjuntos);
                    //echo "</pre><br><br>";

            ?>

            <div class="mail-attachment"><!-- INICIO ATTACH -->
                
                <h5>
                    <span class="icon-attach_file"></span>  Archivo Adjunto</span>
                </h5>


                <div class="attachment">
                    
                    <?php 
                        //foreach ($adjuntos as $adjunto) { 
                            //$archivo = unserialize($adjunto);

                        $adjunto = json_decode(json_encode($model->adjunto),true);
                            //$archivo = json_decode($model->adjunto,true);

                           
                    ?>
                        

                        <div class="file-box">
                            <div class="file">
                                
                                <a href="<?= $adjunto["ObjectURL"] ?>" target="_blank">
                                    <span class="corner"></span>

                                    <?
                                        $cuenta = strlen('tareas/'.$model->id.'/'.$model->docente.'/') + 46;
                                        $largo = strlen($adjunto["ObjectURL"]) - $cuenta;
                                        $archivo = substr($adjunto["ObjectURL"], $cuenta, $largo);
                                        $ext = substr($adjunto["ObjectURL"], -4);
                                        
                                        
                                            switch ($ext) {
                                                
                                                case '.jpg':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break;

                                                case '.png':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break; 

                                                case '.gif':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break;       

                                                case '.pdf':
                                                        $icon = 'far fa-file-pdf text-danger';
                                                    break;
                                                case '.xls':
                                                        $icon = 'far fa-file-excel text-success';
                                                    break;
                                                case 'xlsx':
                                                        $icon = 'far fa-file-excel text-success';
                                                    break;
                                                case '.csv':
                                                        $icon = 'far fa-file-csv text-success';
                                                    break;       
                                                case 'docx':
                                                        $icon = 'far fa-file-word text-primary';
                                                    break;
                                                case '.doc':
                                                        $icon = 'far fa-file-word text-primary';
                                                    break;
                                                case 'pptx':
                                                        $icon = 'far fa-file-powerpoint text-danger';
                                                    break;
                                                case '.ppt':
                                                        $icon = 'far fa-file-powerpoint text-danger';
                                                    break;
                                                        
                                                default:
                                                        $icon = 'far fa-file';
                                                    break;
                                            }
                                            
                                            echo "<div class='icon'><i class='".$icon."'></i></div>";


                                        //echo "<div class='adjunto'>";
                                        //echo Html::img('https://drive.google.com/thumbnail?id=', ['alt'=>'', 'class'=>'']);
                                        //echo"</div>";
                                    ?>
                                    
                                    <div class="file-name">
                                        
                                        <?php 
                                            echo urldecode($archivo); 
                                        ?> 
                                    </div>
                                </a>
                            </div>

                        </div>
                    <?php

                        //}
                    ?>    
                    
                    <div class="clearfix"></div>
                </div> 

            </div><!-- FIN ATTACH -->

            <?php } ?>
  
                </div>                
            </div>
        </div>
    </div>
</div>




<div class="panel panel-default">
    <div class="panel-heading">
      <h4 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> <?= Yii::t('app', 'Desarrollos de la Tarea') ?></h4>
    </div>

    <div class="panel-body" >
        
            
            <?php


            if($dataProvider->totalCount){
                $gridColumn = [
                    ['class' => 'yii\grid\SerialColumn'],
                    ['attribute' => 'id', 'visible' => false],
                    [
                        'attribute' => '', 
                        'format' => 'raw',
                        'width' => '50px',
                        'value' => function($model){
                            return Html::img($model->estudiantes->foto ? '@web/uploads/thumbnail/sm-'.$model->estudiantes->foto : '@web/images/user.jpg', ['class'=>'img-36 rounded-circle']);
                        },
                        'filter'=>false,
                        'visible' => true
                    ],
                    [
                        'attribute' => 'estudiante',
                        'label' => 'Estudiante',
                        //'width' => '250px',
                        'value' => function($model){
                            return $model->estudiantes->nombreinverso;
                        },
                        'filterType' => GridView::FILTER_SELECT2,
                        'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['estado' => '1', 'tipo_tercero' => '1'])->asArray()->all(), 'id', 'nombre'),
                        'filterWidgetOptions' => [
                            'pluginOptions' => ['allowClear' => true],
                        ],
                        'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-academico-search-estudiante']
                    ],
                    [
                        'attribute' => 'entregables',
                        'label' => 'Entregables',
                        'format' => 'RAW',
                        //'width' => '250px',
                        'value' => function($model){
                            //return var_dump($model);
                            $desarrollos = Tareadesarrollo::find()->where(['tarea' => Yii::$app->request->get('id')])->andWhere(['estudiante' => $model->estudiante])->orderBy(['creado_el' => SORT_ASC])->all();
                            
                            $html = "";
                            $x = 1;
                            foreach ($desarrollos as $desarrollo) {
                                //$html .= "<br>".$desarrollo->desarrollo;
                                
                                if(!$desarrollo->revisado_por)
                                {
                                    $html .= Html::button('<i class="fa fa-eye-slash" aria-hidden="true"></i> Entrega '.$x, ['value' => Url::to(['tareadesarrollo/view', 'id' => $desarrollo->id]), 'id' => 'addbutton', 'title' => Yii::t('app', 'Ver Entrega'), 'class' => 'showModalButton btn btn-warning btn-xs', 'disabled' => false]).'&nbsp;';   
                                }
                                else
                                {
                                    $html .= Html::button('<i class="fa fa-eye" aria-hidden="true"></i> Entrega '.$x, ['value' => Url::to(['tareadesarrollo/view', 'id' => $desarrollo->id]), 'id' => 'addbutton', 'title' => Yii::t('app', 'Ver Entrega'), 'class' => 'showModalButton btn btn-primary btn-xs', 'disabled' => false]).'&nbsp;';   
                                }
                                
                                $x++;
                            }

                            //return $model->estudiantes->nombre;
                            return $html;
                        },
                        'filterType' => GridView::FILTER_SELECT2,
                        'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['estado' => '1', 'tipo_tercero' => '1'])->asArray()->all(), 'id', 'nombre'),
                        'filterWidgetOptions' => [
                            'pluginOptions' => ['allowClear' => true],
                        ],
                        'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-academico-search-estudiante']
                    ], 
                    [
                        'attribute' => 'estado',
                        'label' => 'Estado',
                        'format' => 'RAW',
                        //'width' => '250px',
                        'value' => function($model){
                            //return var_dump($model);
                            $desarrollos = Tareadesarrollo::find()->where(['tarea' => Yii::$app->request->get('id')])->andWhere(['estudiante' => $model->estudiante])->orderBy(['creado_el' => SORT_ASC])->count();
                            
                            
                            if($desarrollos > 0)
                            {
                                 return '<span class="label label-success">Entregado</span>';
                            }
                            else
                            {
                                 return '<span class="label label-danger">Sin Entregar</span>';
                            }
                                
                        },
                        'filterType' => GridView::FILTER_SELECT2,
                        'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['estado' => '1', 'tipo_tercero' => '1'])->asArray()->all(), 'id', 'nombre'),
                        'filterWidgetOptions' => [
                            'pluginOptions' => ['allowClear' => true],
                        ],
                        'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-academico-search-estudiante']
                    ], 
                ];
                
                echo Gridview::widget([
                    'dataProvider' => $dataProvider,
                    //'pjax' => true,
                    //'pjaxSettings' => ['options' => ['id' => '']],
                    //'panel' => false,
                    //'export' => false,
                    'responsive'=>true,
                    'hover'=>true,
                    
                    'export' => false,
                    // your toolbar can include the additional full export menu
                    'toolbar' => [
                        '{export}',
                        ExportMenu::widget([
                            'dataProvider' => $dataProvider,
                            'columns' => $gridColumn,
                            'target' => ExportMenu::TARGET_BLANK,
                            'fontAwesome' => true,
                            'dropdownOptions' => [
                                'label' => 'Full',
                                'class' => 'btn btn-default',
                                'itemsBefore' => [
                                    '<li class="dropdown-header">Export All Data</li>',
                                ],
                            ],
                            'exportConfig' => [
                                //ExportMenu::FORMAT_PDF => false
                            ]
                        ]) ,
                    ],
                    'columns' => $gridColumn,
                ]);
            }
            ?>

    </div>
</div>
    
