
<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use kartik\widgets\FileInput;
use dosamigos\tinymce\TinyMce;


$this->registerCss("
.contenido {
    overflow-y: auto;
    max-height: 60vh;
    padding: 6px 12px;
    background-color: #fff;
    background-image: none;
    border: 1px solid #ccc;
    border-radius: 4px;
    -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
    box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
    -webkit-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
    -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
    -webkit-transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
    transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
    transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
    transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
}
.p20{
    margin-top: 20px !important;
}
");


?>
         <?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>

<?  
    if($total < 0)
    {
        echo '<div class="alert alert-danger" role="alert">'.Yii::t('app', 'Esta tarea no se encuentra disponible, venció <b>').Yii::$app->formatter->format($tarea->disponible_hasta, 'relativeTime').'</b>.</div>';
    }
?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> <?= $tarea->tarea; ?></h3>
    </div>

    <div class="panel-body" >

        <div class="row">
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Docente') ?></label>
                <?= $tarea->docentes->nombre ?>
            </div>
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Grupo') ?></label>
                <?= $tarea->grupos->grupo ?>
            </div>
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Asignatura') ?></label>
                <?= $tarea->asignaturas->asignatura ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Disponible Desde') ?></label>
                <?= Yii::$app->formatter->format($tarea->disponible_desde, 'datetime'); ?>
            </div>
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Disponible Hasta') ?></label>
                <?= Yii::$app->formatter->format($tarea->disponible_hasta, 'datetime'); ?>
            </div>
            <div class="col-sm-4">
                <label><?= Yii::t('app', 'Finaliza') ?></label>
                <?= Yii::$app->formatter->format($tarea->disponible_hasta, 'relativeTime'); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <label><?= Yii::t('app', 'Tarea') ?></label>
                <?= Html::decode($tarea->tarea); ?>    
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <?= $form->errorSummary($model); ?>
            </div>
        </div>
        
        <div class="row p20">
            <div class="col-sm-12">
                <div class="contenido form-group">
                    <?= Html::decode($tarea->descripcion); ?>    
                </div>                
            </div>
        </div>



            <?php 
                if ($tarea->adjunto != '') 
                {
                    //$adjuntos = explode(',', $model->adjunto); 
                    //$adjuntos_cantidad = count($adjuntos);

                    //echo "2<pre>";
                    //var_dump($adjuntos);
                    //echo "</pre><br><br>";

            ?>

            <div class="mail-attachment"><!-- INICIO ATTACH -->
                
                <h5>
                    <span class="icon-attach_file"></span>  Archivo Adjunto</span>
                </h5>


                <div class="attachment">
                    
                    <?php 
                        //foreach ($adjuntos as $adjunto) { 
                            //$archivo = unserialize($adjunto);

                        $adjunto = json_decode(json_encode($tarea->adjunto),true);
                            //$archivo = json_decode($tarea->adjunto,true);

                           
                    ?>
                        

                        <div class="file-box">
                            <div class="file">
                                
                                <a href="<?= $adjunto["ObjectURL"] ?>" target="_blank">
                                    <span class="corner"></span>

                                    <?
                                        $cuenta = strlen('tareas/'.$tarea->id.'/'.$tarea->docente.'/') + 46;
                                        $largo = strlen($adjunto["ObjectURL"]) - $cuenta;
                                        $archivo = substr($adjunto["ObjectURL"], $cuenta, $largo);
                                        $ext = substr($adjunto["ObjectURL"], -4);
                                        
                                        
                                            switch ($ext) {
                                                
                                                case '.jpg':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break;

                                                case '.png':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break; 

                                                case '.gif':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break;       

                                                case '.pdf':
                                                        $icon = 'far fa-file-pdf text-danger';
                                                    break;
                                                case '.xls':
                                                        $icon = 'far fa-file-excel text-success';
                                                    break;
                                                case 'xlsx':
                                                        $icon = 'far fa-file-excel text-success';
                                                    break;
                                                case '.csv':
                                                        $icon = 'far fa-file-csv text-success';
                                                    break;       
                                                case 'docx':
                                                        $icon = 'far fa-file-word text-primary';
                                                    break;
                                                case '.doc':
                                                        $icon = 'far fa-file-word text-primary';
                                                    break;
                                                case 'pptx':
                                                        $icon = 'far fa-file-powerpoint text-danger';
                                                    break;
                                                case '.ppt':
                                                        $icon = 'far fa-file-powerpoint text-danger';
                                                    break;
                                                        
                                                default:
                                                        $icon = 'far fa-file';
                                                    break;
                                            }
                                            
                                            echo "<div class='icon'><i class='".$icon."'></i></div>";


                                        //echo "<div class='adjunto'>";
                                        //echo Html::img('https://drive.google.com/thumbnail?id=', ['alt'=>'', 'class'=>'']);
                                        //echo"</div>";
                                    ?>
                                    
                                    <div class="file-name">
                                        
                                        <?php 
                                            echo urldecode($archivo); 
                                        ?> 
                                    </div>
                                </a>
                            </div>

                        </div>
                    <?php

                        //}
                    ?>    
                    
                    <div class="clearfix"></div>
                </div> 

            </div><!-- FIN ATTACH -->

            <?php } ?>



        

        <div class="row">
            <div class="col-sm-12">
                <?= $form->field($model, 'desarrollo')->widget(TinyMce::className(), [
                    'options' => ['rows' => 15],
                    'language' => 'es',
                    'clientOptions' => [
                        'plugins' => [
                            "advlist autolink lists link charmap print preview anchor",
                            "searchreplace visualblocks code fullscreen",
                            "insertdatetime media image table contextmenu paste"
                        ],
                        'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
                    ]
                ]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <?= $form->field($model, 'adjunto')->widget(FileInput::classname(), [
                    'options' => ['multiple'=>false],
                    'pluginOptions'=>[
                        //'uploadUrl' => Url::to(['/site/file-upload']),
                        'allowedFileExtensions'=>['jpg', 'gif', 'png', 'bmp','pdf','doc', 'docx','xls','xlsx','ppt', 'pptx'],
                        'previewFileType' => 'any',
                        'showUpload' => false,
                        'overwriteInitial' => false,
                        //'browseClass' => 'btn btn-primary',
                        //'uploadClass' => 'btn btn-success',
                        //'removeClass' => 'btn btn-danger',
                        'browseIcon' => '<i class="far fa-folder-open"></i>',
                        'uploadIcon' => '<i class="far fa-upload"></i>',
                        'cancelIcon' => '<i class="far fa-trash-alt"></i>',
                        'removeIcon' => '<i class="far fa-trash-alt"></i>',
                        ],
                ])->label('Adjuntos:'); ?>
            </div>

        </div>
    </div>        
</div>

<? 
    $model->tarea = $model->isNewRecord ? $tarea->id : $model->tarea;
    $form->field($model, 'tarea', ['template' => '{input}'])->textInput(['style' => 'display:none']);
 
?>
    <?php ActiveForm::end(); ?>

