<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model backend\models\TareadesarrolloSearch */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="form-tareadesarrollo-search">

    <?php $form = ActiveForm::begin([
        'action' => ['index'],
        'method' => 'get',
    ]); ?>

    <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

    <?= $form->field($model, 'tarea')->widget(\kartik\widgets\Select2::classname(), [
        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tarea::find()->orderBy('id')->asArray()->all(), 'id', 'tarea'),
        'options' => ['placeholder' => Yii::t('app', 'Choose Tarea')],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]); ?>

    <?= $form->field($model, 'estudiante')->textInput(['placeholder' => 'Estudiante']) ?>

    <?= $form->field($model, 'desarrollo')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'adjunto')->textarea(['rows' => 6]) ?>

    <?php /* echo $form->field($model, 'visto')->textInput(['placeholder' => 'Visto']) */ ?>

    <?php /* echo $form->field($model, 'visto_el')->widget(\kartik\datecontrol\DateControl::classname(), [
        'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
        'saveFormat' => 'php:Y-m-d H:i:s',
        'ajaxConversion' => true,
        'options' => [
            'pluginOptions' => [
                'placeholder' => Yii::t('app', 'Choose Visto El'),
                'autoclose' => true,
            ]
        ],
    ]); */ ?>

    <?php /* echo $form->field($model, 'estado')->textInput(['placeholder' => 'Estado']) */ ?>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Search'), ['class' => 'btn btn-primary']) ?>
        <?= Html::resetButton(Yii::t('app', 'Reset'), ['class' => 'btn btn-default']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
