<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\TareadesarrolloSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use backend\models\Desempeno;

$this->title = Yii::t('app', 'Desarrollos de Tareas');

//$this->params['breadcrumbs'][] = $this->title;
$this->params['breadcrumbs'][] = ['label' => 'Panel del Estudiante', 'url' => ['estudiante/index']];

$this->params['breadcrumbs'][] = ['label' => 'Tareas', 'url' => ['tareas/index']];

$this->params['breadcrumbs'][] = $this->title;


$this->params['actions'][] = ['label' => 'Panel del Estudiante', 'url' => '../estudiante/index', 'icon' => '<i class="far fa-tachometer-alt-fastest"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];


$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);


$this->registerCss("
#box-description{
    
}

#description{
    display: inline-table;
    padding-left: 10px;
    color: #888888;
    font-size:80%;
    font-weight: 400;
}

@media only screen and (max-width: 480px) {
    #box-description{
        
    }

    #description {
        display: block;
        float: none;
        
    }

    .responder{
        display: block;
    }
}

");

?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> <?= Yii::t('app', 'Tarea') ?></h3>
    </div>

    <div class="panel-body" >

        <div class="row">
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Docente') ?></label>
                <?= $tarea->docentes->nombre ?>
            </div>
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Grupo') ?></label>
                <?= $tarea->grupos->grupo ?>
            </div>
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Asignatura') ?></label>
                <?= $tarea->asignaturas->asignatura ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Disponible Desde') ?></label>
                <?= Yii::$app->formatter->format($tarea->disponible_desde, 'datetime'); ?>
            </div>
            <div class="col-sm-4">
                <label class="control-label"><?= Yii::t('app', 'Disponible Hasta') ?></label>
                <?= Yii::$app->formatter->format($tarea->disponible_hasta, 'datetime'); ?>
            </div>
            <div class="col-sm-4">
                <label><?= Yii::t('app', 'Finaliza') ?></label>
                <?= Yii::$app->formatter->format($tarea->disponible_hasta, 'relativeTime'); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <label><?= Yii::t('app', 'Tarea') ?></label>
                <?= Html::decode($tarea->tarea); ?>    
            </div>
        </div>

        <div class="row p20">
            <div class="col-sm-12">
                    <button data-toggle="collapse" data-target="#demo" class="btn btn-danger"><i class="far fa-eye"></i> <?= Yii::t('app', 'Mostrar Detalles') ?></button>  
            </div>
        </div>

        <div class="row p20">
            <div class="col-sm-12">
                <div id="demo" class="contenido form-group collapse">
                    <?= Html::decode($tarea->descripcion); ?>  



            <?php 
                if ($tarea->adjunto != '') 
                {
                    //$adjuntos = explode(',', $model->adjunto); 
                    //$adjuntos_cantidad = count($adjuntos);

                    //echo "2<pre>";
                    //var_dump($adjuntos);
                    //echo "</pre><br><br>";

            ?>

            <div class="mail-attachment"><!-- INICIO ATTACH -->
                
                <h5>
                    <span class="icon-attach_file"></span>  Archivo Adjunto</span>
                </h5>


                <div class="attachment">
                    
                    <?php 
                        //foreach ($adjuntos as $adjunto) { 
                            //$archivo = unserialize($adjunto);

                        $adjunto = json_decode(json_encode($tarea->adjunto),true);
                            //$archivo = json_decode($tarea->adjunto,true);

                           
                    ?>
                        

                        <div class="file-box">
                            <div class="file">
                                
                                <a href="<?= $adjunto["ObjectURL"] ?>" target="_blank">
                                    <span class="corner"></span>

                                    <?
                                        $cuenta = strlen('tareas/'.$tarea->id.'/'.$tarea->docente.'/') + 46;
                                        $largo = strlen($adjunto["ObjectURL"]) - $cuenta;
                                        $archivo = substr($adjunto["ObjectURL"], $cuenta, $largo);
                                        $ext = substr($adjunto["ObjectURL"], -4);
                                        
                                        
                                            switch ($ext) {
                                                
                                                case '.jpg':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break;

                                                case '.png':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break; 

                                                case '.gif':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break;       

                                                case '.pdf':
                                                        $icon = 'far fa-file-pdf text-danger';
                                                    break;
                                                case '.xls':
                                                        $icon = 'far fa-file-excel text-success';
                                                    break;
                                                case 'xlsx':
                                                        $icon = 'far fa-file-excel text-success';
                                                    break;
                                                case '.csv':
                                                        $icon = 'far fa-file-csv text-success';
                                                    break;       
                                                case 'docx':
                                                        $icon = 'far fa-file-word text-primary';
                                                    break;
                                                case '.doc':
                                                        $icon = 'far fa-file-word text-primary';
                                                    break;
                                                case 'pptx':
                                                        $icon = 'far fa-file-powerpoint text-danger';
                                                    break;
                                                case '.ppt':
                                                        $icon = 'far fa-file-powerpoint text-danger';
                                                    break;
                                                        
                                                default:
                                                        $icon = 'far fa-file';
                                                    break;
                                            }
                                            
                                            echo "<div class='icon'><i class='".$icon."'></i></div>";


                                        //echo "<div class='adjunto'>";
                                        //echo Html::img('https://drive.google.com/thumbnail?id=', ['alt'=>'', 'class'=>'']);
                                        //echo"</div>";
                                    ?>
                                    
                                    <div class="file-name">
                                        
                                        <?php 
                                            echo urldecode($archivo); 
                                        ?> 
                                    </div>
                                </a>
                            </div>

                        </div>
                    <?php

                        //}
                    ?>    
                    
                    <div class="clearfix"></div>
                </div> 

            </div><!-- FIN ATTACH -->

            <?php } ?>
  
                </div>                
            </div>
        </div>
    </div>
</div>



<?php 
    $x = 1;
    foreach ($desarrollos as $desarrollo) { 

        $desempeno = new Desempeno();
        $color = $desempeno->color($desarrollo->calificacion, $tarea->grupos->grados->tipo_calificacion);
?>

    <div class="panel-group">
      <div class="panel panel-default">
        <div class="panel-heading">
            <h4 class="panel-title text-primary">
                <a data-toggle="collapse" href="#collapse<?= $x ?>">
                    <i class="fas fa-angle-double-right"></i> 
                    <?= Yii::t('app', 'Entregable de Tarea #').' '.$x ?>
                    <small class="text-success"><?= Yii::$app->formatter->format($desarrollo->creado_el, 'relativeTime'); ?></small>
                </a>
                <div style="float:right;">
                    <span class="label" style="width:50px; background-color:<?= $color ?>; color:#fff"><?= $desarrollo->calificacion ?></span>
                </div>
            </h4>
        </div>


        <div id="collapse<?= $x ?>" class="panel-collapse collapse">
            <div class="panel-body">
                <?= $desarrollo->desarrollo ?>



            <?php 
                if ($desarrollo->adjunto != '') 
                {
                    //$adjuntos = explode(',', $model->adjunto); 
                    //$adjuntos_cantidad = count($adjuntos);

                    //echo "2<pre>";
                    //var_dump($adjuntos);
                    //echo "</pre><br><br>";

            ?>

            <div class="mail-attachment"><!-- INICIO ATTACH -->
                
                <h5>
                    <span class="icon-attach_file"></span>  Archivo Adjunto</span>
                </h5>


                <div class="attachment">
                    
                    <?php 
                        //foreach ($adjuntos as $adjunto) { 
                            //$archivo = unserialize($adjunto);

                        $adjunto = json_decode(json_encode($desarrollo->adjunto),true);
                            //$archivo = json_decode($tarea->adjunto,true);

                           
                    ?>
                        

                        <div class="file-box">
                            <div class="file">
                                
                                <a href="<?= $adjunto["ObjectURL"] ?>" target="_blank">
                                    <span class="corner"></span>

                                    <?
                                        $cuenta = strlen('tareas/'.$tarea->id.'/'.$desarrollo->estudiante.'/') + 46;
                                        $largo = strlen($adjunto["ObjectURL"]) - $cuenta;
                                        $archivo = substr($adjunto["ObjectURL"], $cuenta, $largo);
                                        $ext = substr($adjunto["ObjectURL"], -4);
                                        
                                        
                                            switch ($ext) {
                                                
                                                case '.jpg':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break;

                                                case '.png':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break; 

                                                case '.gif':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break;       

                                                case '.pdf':
                                                        $icon = 'far fa-file-pdf text-danger';
                                                    break;
                                                case '.xls':
                                                        $icon = 'far fa-file-excel text-success';
                                                    break;
                                                case 'xlsx':
                                                        $icon = 'far fa-file-excel text-success';
                                                    break;
                                                case '.csv':
                                                        $icon = 'far fa-file-csv text-success';
                                                    break;       
                                                case 'docx':
                                                        $icon = 'far fa-file-word text-primary';
                                                    break;
                                                case '.doc':
                                                        $icon = 'far fa-file-word text-primary';
                                                    break;
                                                case 'pptx':
                                                        $icon = 'far fa-file-powerpoint text-danger';
                                                    break;
                                                case '.ppt':
                                                        $icon = 'far fa-file-powerpoint text-danger';
                                                    break;
                                                        
                                                default:
                                                        $icon = 'far fa-file';
                                                    break;
                                            }
                                            
                                            echo "<div class='icon'><i class='".$icon."'></i></div>";


                                        //echo "<div class='adjunto'>";
                                        //echo Html::img('https://drive.google.com/thumbnail?id=', ['alt'=>'', 'class'=>'']);
                                        //echo"</div>";
                                    ?>
                                    
                                    <div class="file-name">
                                        
                                        <?php 
                                            echo urldecode($archivo); 
                                        ?> 
                                    </div>
                                </a>
                            </div>

                        </div>
                    <?php

                        //}
                    ?>    
                    
                    <div class="clearfix"></div>
                </div> 

            </div><!-- FIN ATTACH -->

            <?php } ?>


            </div>
            <div class="panel-footer">
                <div id="box-description">
                    
                    <div id="description">
                        <i class="fas fa-calendar-alt text-success"></i> Entregado
                        <?= Yii::$app->formatter->format($desarrollo->creado_el, 'datetime'); ?>
                    </div>
                    
                    <div id="description">
                        <i class="fas fa-user text-primary"></i>
                        <?= $desarrollo->docentes ? $desarrollo->docentes->nombre : 'Sin Revisión' ?>
                    </div>

                    <div id="description">
                        <i class="fas fa-calendar-alt text-danger"></i>
                        <?= Yii::$app->formatter->format($desarrollo->revisado_el, 'datetime'); ?>
                    </div>

                    <div id="description">    
                        <i class="fas fa-clock text-danger"></i>
                        <?= Yii::$app->formatter->format($desarrollo->revisado_el, 'relativeTime'); ?>
                    </div>
                </div>
                
            </div>
        </div>
      </div>
    </div> 

<?php  $x++; } ?>


