<?php
use yii\helpers\Html;
use yii\helpers\Url;
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;
use backend\models\Acudiente;

?>


<script type="text/javascript">
    
    function eliminar_acudiente(id)
    {

      swal({
          title: '¿Estás seguro?',
          text: 'Deseas eliminar el acudiente del sistema?',
          type: 'warning',
          showCancelButton: true,
          confirmButtonClass: 'btn-warning',
          confirmButtonText: 'Si, estoy seguro!',
          cancelButtonText: 'No, Cancelar',
          closeOnConfirm: false,
          closeOnCancel: false
        },
        function(isConfirm) {
          if (isConfirm) 
          {
            $.ajax({
                    type: 'POST',
                    url: '<?= Url::to(["acudiente/delete"]) ?>',
                    data: {id : id},
                    success: function (data) {

                        $('tr[data-key="'+ id +'"]').remove();
                        
                        swal({
                            title: 'Eliminado!',
                            text: 'Se ha eliminado el registro satisfactoriamente.',
                            type: 'success',
                            allowOutsideClick: false,
                            timer: 3000,
                        });

                    }
            });  
          } 
          else 
          {
              swal({
                title: 'Cancelado!',
                text: 'Haz cancelado eliminar el registro.',
                type: 'error',
                timer: 3000})
          }
      });
    }    

</script>

<div class="row" role="tabpanel">
  <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

    <?= Html::button('<i class="fa fa-plus" aria-hidden="true"></i> Agregar Acudientes', ['value' => Url::to(['acudiente/add','tercero' => $model->id]), 'id' => 'addacudiente', 'title' => Yii::t('app', 'Agregar Acudientes'.' '.$model->nombre), 'class' => 'showModalButton btn btn-block btn-primary', 'disabled' => false]); ?>

    <br>
    
    <?php

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->acudientes,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        'identificacion',
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        
        [
                'attribute' => 'parentescos.parentesco',
                'label' => 'Parentesco',
        ],
        /*
        [
                'attribute' => 'generos.genero',
                'label' => 'Genero'
        ],
        [
                'attribute' => 'rhs.rh',
                'label' => 'Rh'
        ],*/
        //'direccion',
        //'fijo',
        'movil',
        //'email:email',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'acudiente',
            'buttons'=>[
                'view'=>function ($url) {
                    return Html::a('', false, ['value' => $url, 'class' => 'glyphicon glyphicon-eye-open showModalButton', 'pjax'=> false, 'title' => 'Información del Acudiente']);
                },

                'update'=>function ($url) {
                    return Html::a('', false, ['value' => $url, 'class' => 'glyphicon glyphicon-pencil showModalButton', 'pjax'=> false, 'title' => 'Información del Acudiente']);
                },

                'delete'=>function ($url, $model) {
                    return Html::a('', false, ['value' => $url, 'class' => 'glyphicon glyphicon-trash', 'data-toggle' => 'tooltip', 'title' => Yii::t('app', 'Eliminar'), 'onClick' => 'eliminar_acudiente('.$model->id.')', 'pjax'=> false,]);
                },

               
            ],
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);

?>
  </div>
</div>
