<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;
use backend\models\Desempeno;


    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->estudianteCalificaciones,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo',
                'group' => true,
        ],
        [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo',
                'group' => true,
        ],
        [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],

        [
                'attribute' => 'definitiva_periodo',
                'label' => 'Definitiva',
                'format' => 'RAW',
                'value' => function($model)
                            {
                                $desempeno = new Desempeno(); 
                                $tipo_calificacion = $model->grupos->grados->tipo_calificacion;

                                $color = ($model->definitiva_periodo =='') ? '#cccccc' :  $desempeno->color($model->definitiva_periodo, $tipo_calificacion);
                                $desempenos = ($model->definitiva_periodo =='') ? 'No Evaluado' : $desempeno->desempeno($model->definitiva_periodo, $tipo_calificacion);    
                                $nota = ($model->definitiva_periodo =='') ? 'NE' : $model->definitiva_periodo;  
                                
                                return '<span class="promedio" data-toggle="tooltip" title="'.$desempenos.'" style="background-color:'.$color.';">'.$nota.'</span>';
                            }
                            
        ],
        
        'nivelacion',
        'indicador',
        'observacion',
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'calificacion'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
