<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\web\JsExpression;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;
use yii2mod\google\maps\markers\GoogleMaps;

use backend\models\Tercero;
use backend\models\Academico;
use backend\models\Matricula;
use backend\models\Tipotercero;
use backend\models\Tipodocumento;
use backend\models\Genero;
use backend\models\Parentesco;
use backend\models\Pais;
use backend\models\Departamento;
use backend\models\Municipio;
use backend\models\Barrio;
use backend\models\Rh;
use backend\models\Religion;
use backend\models\Etnia;
use backend\models\Eps;
use backend\models\Terceroestado;
use backend\models\Resguardo;


\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'Acudiente', 
        'relID' => 'acudiente', 
        'value' => \yii\helpers\Json::encode($model->acudientes),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);

if (Yii::$app->controller->id != 'estudiante')
{
    $this->registerJs("$('#tipo-id').change(function(){
        if (this.value == 1)
        {
            $('#info-estudiante').fadeIn(500); 
            //$('#info-acudiente').fadeIn(500); 
            $('#vigencia_anterior').fadeIn(500); 

        }
        else
        {
            $('#info-estudiante').fadeOut(500);
            //$('#info-acudiente').fadeOut(500); 
            $('#vigencia_anterior').fadeOut(500); 
                
        }    
    });"
    );
}

$this->registerCss("#w0{ height:222px !important;}");


?>

     <?php $form = ActiveForm::begin([
        'validateOnSubmit' => true,
        'enableAjaxValidation' => true,
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                      'enctype'=>'multipart/form-data',
                    ]
    ]); ?>
    
<div class="row">
    <div class = "col-sm-12">
        <?= $form->errorSummary($model); ?>
    </div>
</div>


<div class="row gutter">
  <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
    <div class="thumbnail">
      
       <!-- <div class="progress m-t-xs full progress-small">
            <div style="width: 65%" aria-valuemax="100" aria-valuemin="0" aria-valuenow="65" role="progressbar" class=" progress-bar progress-bar-success">
                <span class="sr-only">35% Complete (success)</span>
            </div>
        </div>
        -->
        <? 
            if (!$model->isNewRecord)
            {    

                echo Html::img($model->foto ? '@web/uploads/thumbnail/sm-'.$model->foto : '@web/images/user.jpg', ['class'=>'foto-perfil img-circle img-responsive']); 

                echo "<div class='clear'></div>";
                
                echo '<h4 class="center-align-text">'.$model->nombre.'</h4>';


                echo "<p class='btn-stack center-align-text'>";

                switch ($model->tipo_tercero) {
                     case '1':
                         $tipo = 'success';
                         break;
                     case '2':
                         $tipo = 'info';
                         break;
                     case '3':
                         $tipo = 'warning';
                         break;        
                     
                     default:
                         $tipo = 'default';
                         break;

                }   
                
                echo "<label class='btn btn-block btn-".$tipo."' data-toggle='tooltip' title='Tipo de Tercero'>".$model->tipoterceros->tipo. "</label>";
            
                if ($model->tipo_tercero == 1)
                {
                    $data = Academico::find()->where(['estudiante' => $model->id])->one();

                    if ($data =='')
                    {
                        echo "<label class='btn btn-block btn-danger'>Sin Grupo</label>";
                    }
                    else    
                    {
                        echo "<label class='btn btn-block btn-info' data-toggle='tooltip' title='Grupo'>Grupo " .$data->grupos->grupo. "</label>";
                    }    
                
                    echo "<label class='btn btn-block btn-warning' data-toggle='tooltip' title='Estado del Tercero'>" .$model->estados->estado. "</label>";

                    echo Html::a('<i class="far fa-file-pdf fa-lg"></i> Hoja de Vida', ['tercero/hojadevida', 'id' => $model->id], ['class' => 'btn btn-block btn-danger', 'data-toggle' => 'tooltip', 'title' => 'Exportar Hoja de Vida', 'target' => "_blank"]);
                }

                echo "</p><hr>";


                echo GoogleMaps::widget([
                    'userLocations' => [
                        [
                            'location' => [
                                'address' => $model->direccion,
                                'country' => 'Colombia',
                                'state' => $model->departamento_residencia =='' ? 'Meta' : $model->departamentoresidencia->nombre,
                                'city' => $model->municipio_residencia =='' ? 'Villavicencio' : $model->municipioresidencia->nombre,
                                
                            ],
                            //'htmlContent' => $model->municipioresidencia->nombre,
                        ],
                    ],
                ]);
            }
            else
            {
                echo Html::img('@web/images/matricula-estudiantil.png', ['class'=>'img-responsive']);
            }    
        ?>

    </div>
  </div>


                  <? 
                    if (Yii::$app->controller->id=='estudiante')
                    {    
                        $display = 'block';
                    }
                    else
                    {
                        if ($model->tipo_tercero == 1)
                        {
                            $display = 'block';
                        }
                        else
                        {
                            $display = 'none';
                        }    
                    }    
                ?>        

            
  <div class="col-lg-9 col-md-8 col-sm-12 col-xs-12">
    <ul class="nav nav-tabs">
        <li class="active"><a data-toggle="tab" href="#tab-1">Personal</a></li>
        <li id="info-estudiante" class="" style="display:<?= $display; ?>;"><a data-toggle="tab" href="#tab-2">Complementaria</a></li>
        <li id="info-acudiente" class="" style="display:<?= $display; ?>;"><a data-toggle="tab" href="#tab-3">Acudientes</a></li>
        <li id="info-foto" class="text-success"><a data-toggle="tab" href="#tab-4">Foto</a></li>
        <li id="info-academico" class="" style="display:<?= $display; ?>;"><a data-toggle="tab" href="#tab-5">Carga Académica</a></li>
        <li id="info-retiro" class="" style="display:<?= $display; ?>;"><a data-toggle="tab" href="#tab-6">Retiro Estudiantil</a></li>
       
    </ul>
    <div class="tab-content">
        <div id="tab-1" class="tab-pane active">

            <div class="row">

                <div class="col-sm-6">

                    <? 
                        if (Yii::$app->controller->id=='estudiante')
                        {    
                            $query = Tipotercero::find()->where(['id' => '1'])->orderBy('id')->asArray()->all();
                            $model->tipo_tercero = '1';
                        }
                        else
                        {
                            $query = Tipotercero::find()->orderBy('id')->asArray()->all();
                        }    
                    ?> 
                    
                    <?= $form->field($model, 'tipo_tercero')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map($query, 'id', 'tipo'),
                        'options' => ['id'=>'tipo-id','autofocus' => 'autofocus'],
                        'hideSearch' => true,
                        'pluginOptions' => [
                            'allowClear' => true,
                            'placeholder' => 'Seleccione el Tipo de Tercero',
                        ],
                    ]) ?>
                </div>       
            </div>

            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'tipo')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Tipodocumento::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => 'Seleccione el Tipo de Documento'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'identificacion')->textInput(['maxlength' => true, 'placeholder' => 'Número de Identificación']) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'departamento_expedido')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Departamento::find()->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                        'options' => ['id'=>'depexp-id',],
                        'pluginOptions' => [
                            'placeholder' => 'Seleccione el Departamento',
                            'allowClear' => true,
                        ],
                    ]) ?>

                </div>
                <div class="col-sm-3">

                    <?= $form->field($model, 'municipio_expedido')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data' => ArrayHelper::map(Municipio::find()->where(['=', 'departamento', $model->departamento_expedido])->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                        'options'=>['id'=>'munexp-id'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione el Municipio',
                            'depends'=>['depexp-id'],
                            'url'=>Url::to(['findmunicipios']),
                        ]
                    ]);
                    ?>  
                </div>

            </div>

            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'primer_nombre')->textInput(['maxlength' => true, 'placeholder' => 'Primer Nombre']) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'segundo_nombre')->textInput(['maxlength' => true, 'placeholder' => 'Segundo Nombre']) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'primer_apellido')->textInput(['maxlength' => true, 'placeholder' => 'Primer Apellido']) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'segundo_apellido')->textInput(['maxlength' => true, 'placeholder' => 'Segundo Apellido']) ?>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'genero')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Genero::find()->orderBy('id')->asArray()->all(), 'id', 'genero'),
                        'options' => ['placeholder' => 'Seleccione el Género'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'fecha_nacimiento')->widget(DatePicker::classname(), [
                        'options' => ['placeholder' => 'Seleccione la Fecha Nacimiento'],
                        'removeButton' => false,
                        'pluginOptions' => [
                            'autoclose' => true,
                            'format' => 'yyyy-mm-dd',
                            'todayHighlight' => true            ]
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'departamento_nacimiento')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Departamento::find()->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                        'options' => ['id'=>'dep-id',],
                        'pluginOptions' => [
                            'placeholder' => 'Seleccione el Departamento',
                            'allowClear' => true,
                        ],
                    ]) ?>

                </div>
                <div class="col-sm-3">

                    <?= $form->field($model, 'municipio_nacimiento')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data' => ArrayHelper::map(Municipio::find()->where(['=', 'departamento', $model->departamento_nacimiento])->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                        'options'=>['id'=>'mun-id'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione el Municipio',
                            'depends'=>['dep-id'],
                            'url'=>Url::to(['findmunicipios']),
                        ]
                    ]);
                    ?>  
                </div>

            </div>

               
            
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'pais')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Pais::find()->where(['estado' =>'1'])->orderBy('codigo')->asArray()->all(), 'codigo', 'pais'),
                        'options' => ['placeholder' => 'Seleccione la Nacionalidad'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'departamento_residencia')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Departamento::find()->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                        'options' => ['id'=>'depres-id',],
                        'pluginOptions' => [
                            'placeholder' => 'Seleccione el Departamento',
                            'allowClear' => true,
                        ],
                    ]) ?>

                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'municipio_residencia')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data' => ArrayHelper::map(Municipio::find()->where(['=', 'departamento', $model->departamento_residencia])->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                        'options'=>['id'=>'munres-id'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione el Municipio',
                            'depends'=>['depres-id'],
                            'url'=>Url::to(['findmunicipios']),
                        ]
                    ]);
                    ?>  
                </div>
                <div class="col-sm-3">    
                    <?= $form->field($model, 'barrio')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data' => ArrayHelper::map(Barrio::find()->where(['departamento' => $model->departamento_residencia])->andWhere(['municipio' => $model->municipio_residencia])->orderBy('id')->asArray()->all(), 'id', 'nombre'),
                        'options'=>['id'=>'barrio-id', 'placeholder'=>'Seleccione el Barrio'],
                        'pluginOptions'=>[
                            'depends'=>['munres-id'],
                            'url'=>Url::to(['findbarrios']),
                        ]
                    ]);
                    ?>
                </div>  
            </div>    
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($model, 'direccion')->textInput(['maxlength' => true, 'placeholder' => 'Direccion']) ?>
                </div>  

                <div class="col-sm-3">    
                    <?= $form->field($model, 'fijo')->textInput(['placeholder' => 'Fijo']) ?>
                </div>    

                <div class="col-sm-3">     
                    <?= $form->field($model, 'movil')->textInput(['placeholder' => 'Movil']) ?>
                </div> 
            </div>    
            <div class="row">
                <div class="col-sm-6">     
                    <?= $form->field($model, 'email')->textInput(['placeholder' => 'Email']) ?>
                </div>        
                   
                <div class="col-sm-3">     
                    
                    <? ($model->isNewRecord) ? $model->activo = '1': '0'; ?>

                    <?= $form->field($model, 'activo')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'size' => 'medium',
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Activo',
                        'offText'=>'Inactivo'
                    ]]) 
                    ?>
                </div>

                <div class="col-sm-3" id="vigencia_anterior" style="display:<?= $display; ?>;">  
                    <? ($model->isNewRecord) ? $model->vigencia_anterior_aprobada = '1': '0'; ?>   

                    <?= $form->field($model, 'vigencia_anterior_aprobada')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'size' => 'medium',
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Aprobado',
                        'offText'=>'Reprobado'
                    ]]) 
                    ?>
                </div>
            </div>
        </div>  <!-- FIN TAB 1  -->


        <div id="tab-2" class="tab-pane">

            <div class="row">

                <div class="col-sm-3">
                    <?= $form->field($model, 'rh')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Rh::find()->orderBy('id')->asArray()->all(), 'id', 'rh'),
                        'options' => ['placeholder' => 'Seleccione el Grupo Sanguineo y RH'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">    
                    <?= $form->field($model, 'religion')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Religion::find()->orderBy('id')->asArray()->all(), 'id', 'religion'),
                        'options' => ['placeholder' => 'Seleccione la Creencia Religiosa'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">    
                    <?= $form->field($model, 'etnia')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Etnia::find()->orderBy('id')->asArray()->all(), 'id', 'etnia'),
                        'options' => ['placeholder' => 'Seleccione la Etnia'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">    
                    <?= $form->field($model, 'eps')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Eps::find()->orderBy('id')->asArray()->all(), 'id', 'eps'),
                        'options' => ['placeholder' => 'Seleccione la EPS'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>

            </div>
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'codigo_sisben')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(\backend\models\base\Tiposisben::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => 'Seleccione el Grupo'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'codigo_familia_accion')->textInput(['maxlength' => true, 'placeholder' => 'Código Familias en Acción']) ?>
                </div>  
                <div class="col-sm-3">
                    <?= $form->field($model, 'estrato')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(\backend\models\base\Estrato::find()->orderBy('id')->asArray()->all(), 'id', 'estrato'),
                        'options' => ['placeholder' => 'Seleccione el Estrato'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'situacion')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(\backend\models\base\Tiposituacion::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => 'Seleccione el Tipo de Situación'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
            </div>
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'cabeza_familia')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione',
                            'allowClear' => true,
                        ]
                    ]);
                    ?>  
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'codigo_desplazado')->textInput(['maxlength' => true, 'placeholder' => 'Código de Desplazado']) ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'departamento_desplazado')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Departamento::find()->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                        'options' => ['id'=>'dep-des-id',],
                        'pluginOptions' => [
                            'placeholder' => 'Seleccione el Departamento',
                            'allowClear' => true,
                        ],
                    ]) ?> 
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'municipio_desplazado')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data' => ArrayHelper::map(Municipio::find()->where(['=', 'departamento', $model->departamento_desplazado])->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                        'options'=>['id'=>'mun-des-id'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione el Municipio',
                            'depends'=>['dep-des-id'],
                            'url'=>Url::to(['tercero/findmunicipios']),
                        ]
                    ]);
                    ?>
                </div> 
                

            </div>
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'subsidio')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'capacidad')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(\backend\models\base\Tipocapacidad::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => 'Seleccione la Capacidad Excepcional'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'medicamentos')->textInput(['maxlength' => true, 'placeholder' => 'Medicamentos']) ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'alergias')->textInput(['maxlength' => true, 'placeholder' => 'Alergias']) ?>
                </div> 


            </div>
            <div class="row">

                <div class="col-sm-3">
                    <?= $form->field($model, 'discapacidad')->textInput(['maxlength' => true, 'placeholder' => 'Discapacidad']) ?>
                </div> 

                <div class="col-sm-3">
                    <?= $form->field($model, 'discapacidad_certificada')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione Discapacidad Certificada'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-6">
                    <?= $form->field($model, 'recurso')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(\backend\models\base\Tiporecurso::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => 'Seleccione el Tipo de Recurso'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
            </div>
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'bienestar')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'heroe')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione Beneficiario Héroes Nacionales'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'fuerza_publica')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione Beneficiario Fuerza Pública'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'sector')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione Sector Privado'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
            </div>
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'departamento_resguardo')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Departamento::find()->orderBy('id')->asArray()->all(), 'id', 'nombre'),
                        'options' => ['id'=>'dep-resg-id'],
                        'pluginOptions' => [
                            'placeholder' => 'Seleccione Departamento',
                            'allowClear' => true,
                        ],
                    ]) ?>
                </div>       
                <div class="col-sm-3">
                    <?= $form->field($model, 'resguardo')->widget(DepDrop::classname(), [
                        'data' => ArrayHelper::map(Resguardo::find()->where(['=', 'departamento', $model->departamento_resguardo])->orderBy('id')->asArray()->all(), 'id', 'resguardo'),
                        'type'=>DepDrop::TYPE_SELECT2,
                        'options'=>['id'=>'resguardo-id'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione el Resguardo',
                            'depends'=>['dep-resg-id'],
                            'url'=>Url::to(['tercero/findresguardos']),
                            'allowClear' => true,
                        ]
                    ]);
                    ?>  
                </div>  

            </div>            
        </div>  <!-- FIN TAB 2 -->


        <div id="tab-3" class="tab-pane">
            <div class="row">
                <div class="col-sm-12">
                    <? $this->render('_formAcudiente', ['row' => ArrayHelper::toArray($model->acudientes)]); ?>            

                    <?// $this->render('_formAcudiente', ['row' => \yii\helpers\ArrayHelper::toArray($model->acudientes)]); ?>            

                    <?  if(!$model->isNewRecord) { ?>


                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Acudientes</h3>
                            </div>

                            <div class="panel-body">
                                <div class="col-sm-12">
                                    <?= $this->render('_dataAcudientes', ['model' => $model]); ?>
                                </div>  
                            </div>
                        </div>

                    <? } ?>

                </div>
                
            </div>
                
        </div>  <!-- FIN TAB 3 --> 

        <div id="tab-4" class="tab-pane">
            <div class="row">
                <div class="col-sm-12">
                    <?= $form->field($model, 'foto')->widget(FileInput::classname(), [
                        'options' => ['accept'=>'image/*'],
                        'pluginOptions'=>[
                            'allowedFileExtensions'=>['jpg', 'jpeg', 'gif', 'png', 'bmp'],
                            'showUpload' => false,
                            'initialPreview' => [
                                $model->foto ? Html::img('@web/uploads/thumbnail/sm-'.$model->foto) : null, // checks the models to display the preview
                            ],
                            'overwriteInitial' => true,
                            //'browseClass' => 'btn btn-primary',
                            //'uploadClass' => 'btn btn-success',
                            //'removeClass' => 'btn btn-danger',
                            //'browseIcon' => '<i class="fa fa-picture-o"></i>',
                            //'removeIcon' => '<i class="fa fa-trash"></i>',
                            ],
                    ]); ?>

                    <?= $form->field($model, 'foto_anterior')->hiddenInput()->label(false); ?>
                </div>
                
            </div>
                
        </div>  <!-- FIN TAB 4 --> 
              
    <?  if(!$model->isNewRecord) { ?>

        <div id="tab-5" class="tab-pane">

            <div class="row">

                <?= $form->field($academico, 'estudiante')->hiddenInput(['value'=>$academico->estudiante])->label(false); ?>
                <div class="col-sm-6">
                    <?= $form->field($academico, 'grupo')->widget(\kartik\widgets\Select2::classname(), [
                        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->orderBy('id')->asArray()->all(), 'id', 'grupo'),
                        'options' => ['placeholder' => 'Seleccione Grupo'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>                    
                </div>
                <div class="col-sm-6">
                    <?= $form->field($academico, 'fecha_matricula')->widget(DatePicker::classname(), [
                        'options' => ['placeholder' => 'Seleccione la Fecha de Matricula'],
                        'removeButton' => false,
                        'pluginOptions' => [
                            'autoclose' => true,
                            'format' => 'yyyy-mm-dd',
                            'todayHighlight' => true            ]
                    ]) ?>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <?= Yii::t('app', '<b>Nota</b> La carga académica pertenece a la información de matrícula de la vigencia actual.') ?>                    
                </div>
            </div>
        </div>  <!-- FIN TAB 5  -->

        <div id="tab-6" class="tab-pane">

            <div class="row">

                <div class="col-sm-6">
                    <?= $form->field($academico, 'fecha_retiro')->widget(DatePicker::classname(), [
                        'options' => ['placeholder' => 'Seleccione la Fecha de Retiro'],
                        'pluginOptions' => [
                            'removeButton' => true,
                            'autoclose' => true,
                            'format' => 'yyyy-mm-dd',
                            'todayHighlight' => true            ]
                    ]) ?>
                </div>
                
                <?
                    if (!$academico->isNewRecord)
                    {
                        if ($academico->estudiantes->estados->retiro == 1)
                        {
                            $academico->motivo = $academico->estudiantes->estado;
                        }
                    }
                ?>        
                <div class="col-sm-6">
                    <?= $form->field($academico, 'motivo')->widget(Select2::classname(), [
                        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Terceroestado::find()->where(['retiro' => '1'])->orderBy('estado')->asArray()->all(), 'id', 'estado'),
                        'options' => ['placeholder' => 'Seleccione el Motivo del Retiro'],
                        'hideSearch' => isset($tercero) ? true : false,
                        'pluginOptions' => [
                            'allowClear' => isset($tercero) ? false : true,
                        ],
                    ]);?>
                </div>
            </div>
        </div>  <!-- FIN TAB 6  -->

 

    <? } ?>

    </div>
    
  </div>
</div>

<!--
    <div class="form-group" id="add-acudiente"></div>

    <div class="form-group" id="add-academico"></div>

    <div class="form-group" id="add-asistencia"></div>

    <div class="form-group" id="add-calificacion"></div>

    <div class="form-group" id="add-grupo"></div>
-->
    <?php ActiveForm::end(); ?>