<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

Pjax::begin();
$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Grupo',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        'grado' => [
            'label' => 'Grado',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->orderBy('grado')->asArray()->all(), 'id', 'grado'),
                'options' => ['placeholder' => 'Choose Grado'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'grupo' => ['type' => TabularForm::INPUT_TEXT],
        'jornada' => [
            'label' => 'Jornada',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Jornada::find()->orderBy('jornada')->asArray()->all(), 'id', 'jornada'),
                'options' => ['placeholder' => 'Choose Jornada'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'sede' => [
            'label' => 'Sede',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Sede::find()->orderBy('sede')->asArray()->all(), 'id', 'sede'),
                'options' => ['placeholder' => 'Choose Sede'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'por_nota' => ['type' => TabularForm::INPUT_TEXT],
        'metodologia' => [
            'label' => 'Metodologia',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Metodologia::find()->orderBy('metodologia')->asArray()->all(), 'id', 'metodologia'),
                'options' => ['placeholder' => 'Choose Metodologia'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'modalidad' => [
            'label' => 'Modalidad',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Modalidad::find()->orderBy('modalidad')->asArray()->all(), 'id', 'modalidad'),
                'options' => ['placeholder' => 'Choose Modalidad'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'especialidad' => [
            'label' => 'Especialidad',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Especialidad::find()->orderBy('especialidad')->asArray()->all(), 'id', 'especialidad'),
                'options' => ['placeholder' => 'Choose Especialidad'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowGrupo(' . $key . '); return false;', 'id' => 'grupo-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . 'Grupo',
            'type' => GridView::TYPE_INFO,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Add Row', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowGrupo()']),
        ]
    ]
]);
Pjax::end();
?>
