<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\web\JsExpression;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;
use yii2mod\google\maps\markers\GoogleMaps;

use frontend\models\Tercero;
use backend\models\Tipotercero;
use backend\models\Tipodocumento;
use backend\models\Genero;
use backend\models\Parentesco;
use backend\models\Pais;
use backend\models\Departamento;
use backend\models\Municipio;
use backend\models\Barrio;
use backend\models\Rh;
use backend\models\Religion;
use backend\models\Etnia;
use backend\models\Eps;
use backend\models\Terceroestado;
use backend\models\Resguardo;
use backend\models\Academico;

$this->title = $model->nombre;

$this->registerJs("$('#tercero-eps').change(function(){
    if (this.value == 2)
    {
        $('#info-sisben').fadeIn(500); 
    }
    else
    {
        $('#info-sisben').fadeOut(500);
    }    
});"
);


$this->registerJs("$('#tercero-situacion').change(function(){
    if (this.value == 3)
    {
        $('#info-codigo_desplazado').fadeIn(500); 
        $('#info-desplazado_departamento').fadeIn(500); 
        $('#info-desplazado_municipio').fadeIn(500); 
    }
    else
    {
        $('#info-codigo_desplazado').fadeOut(500); 
        $('#info-desplazado_departamento').fadeOut(500);
        $('#info-desplazado_municipio').fadeOut(500); 
    }    
});"
);

$this->registerJs("$('#tercero-discapacidad').keydown(function(){
    if (this.value != '')
    {
        $('#info-discapacidad_certificada').fadeIn(500); 
    }
    
    if (this.value == '')
    {
        $('#info-discapacidad_certificada').fadeOut(500);
    }    
});"
);

$this->registerJs("$('#tercero-etnia').change(function(){
    if (this.value == 8)
    {
        $('#info-departamento_resguardo').fadeIn(500); 
        $('#info-resguardo').fadeIn(500); 
    }
    else
    {
        $('#info-departamento_resguardo').fadeOut(500);
        $('#info-resguardo').fadeOut(500);
    }    
});"
);

?>
<style type="text/css">

/* -------------------------------- 

Primary style

-------------------------------- */

*, *::after, *::before {
  box-sizing: border-box;
}


html {
  font-size: 62.5%;
}

body {
  font-size: 1.6rem;
  font-family: "Source Sans Pro", sans-serif;
  color: #2c3f4c;
  background-color: #ffffff;
}


a {
  color: #96c03d;
  text-decoration: none;
}

section {
  /* used just to separate different styles */
  border-bottom: 1px solid #e6e6e6;
  padding: 4em 0;
}
section h2 {
  width: 90%;
  margin: 0 auto 2em;
  color: #2c3f4c;
  font-size: 2rem;
  font-weight: 700;
  text-align: center;
}
@media only screen and (min-width: 1170px) {
  section {
    padding: 6em 0;
  }
  section h2 {
    margin: 0 auto 3em;
  }
}

/* -------------------------------- 

Basic Style

-------------------------------- */
.cd-breadcrumb, .cd-multi-steps {
  width: 90%;
  padding: 0.5em 1em;
  margin: 1em auto;
  background-color: #edeff0;
  border-radius: .25em;
}
.cd-breadcrumb:after, .cd-multi-steps:after {
  content: "";
  display: table;
  clear: both;
}
.cd-breadcrumb li, .cd-multi-steps li {
  display: inline-block;
  float: left;
  margin: 0.5em 0;
}
.cd-breadcrumb li::after, .cd-multi-steps li::after {
  /* this is the separator between items */
  display: inline-block;
  content: '\00bb';
  margin: 0 .6em;
  color: #959fa5;
}
.cd-breadcrumb li:last-of-type::after, .cd-multi-steps li:last-of-type::after {
  /* hide separator after the last item */
  display: none;
}
.cd-breadcrumb li > *, .cd-multi-steps li > * {
  /* single step */
  display: inline-block;
  font-size: 1.4rem;
  color: #2c3f4c;
}
.cd-breadcrumb li.current > *, .cd-multi-steps li.current > * {
  /* selected step */
  color: #96c03d;
}
.no-touch .cd-breadcrumb a:hover, .no-touch .cd-multi-steps a:hover {
  /* steps already visited */
  color: #96c03d;
}
.cd-breadcrumb.custom-separator li::after, .cd-multi-steps.custom-separator li::after {
  /* replace the default arrow separator with a custom icon */
  content: '';
  height: 16px;
  width: 16px;
  background: url(../img/cd-custom-separator.svg) no-repeat center center;
  vertical-align: middle;
}
.cd-breadcrumb.custom-icons li > *::before, .cd-multi-steps.custom-icons li > *::before {
  /* add a custom icon before each item */
  content: '';
  display: inline-block;
  height: 20px;
  width: 20px;
  margin-right: .4em;
  margin-top: -2px;
  background: url(../img/cd-custom-icons-01.svg) no-repeat 0 0;
  vertical-align: middle;
}
.cd-breadcrumb.custom-icons li:not(.current):nth-of-type(2) > *::before, .cd-multi-steps.custom-icons li:not(.current):nth-of-type(2) > *::before {
  /* change custom icon using image sprites */
  background-position: -20px 0;
}
.cd-breadcrumb.custom-icons li:not(.current):nth-of-type(3) > *::before, .cd-multi-steps.custom-icons li:not(.current):nth-of-type(3) > *::before {
  background-position: -40px 0;
}
.cd-breadcrumb.custom-icons li:not(.current):nth-of-type(4) > *::before, .cd-multi-steps.custom-icons li:not(.current):nth-of-type(4) > *::before {
  background-position: -60px 0;
}
.cd-breadcrumb.custom-icons li.current:first-of-type > *::before, .cd-multi-steps.custom-icons li.current:first-of-type > *::before {
  /* change custom icon for the current item */
  background-position: 0 -20px;
}
.cd-breadcrumb.custom-icons li.current:nth-of-type(2) > *::before, .cd-multi-steps.custom-icons li.current:nth-of-type(2) > *::before {
  background-position: -20px -20px;
}
.cd-breadcrumb.custom-icons li.current:nth-of-type(3) > *::before, .cd-multi-steps.custom-icons li.current:nth-of-type(3) > *::before {
  background-position: -40px -20px;
}
.cd-breadcrumb.custom-icons li.current:nth-of-type(4) > *::before, .cd-multi-steps.custom-icons li.current:nth-of-type(4) > *::before {
  background-position: -60px -20px;
}
@media only screen and (min-width: 768px) {
  .cd-breadcrumb, .cd-multi-steps {
    padding: 0 1.2em;
  }
  .cd-breadcrumb li, .cd-multi-steps li {
    margin: 1.2em 0;
  }
  .cd-breadcrumb li::after, .cd-multi-steps li::after {
    margin: 0 1em;
  }
  .cd-breadcrumb li > *, .cd-multi-steps li > * {
    font-size: 1.6rem;
  }
}

/* -------------------------------- 

Triangle breadcrumb

-------------------------------- */
@media only screen and (min-width: 768px) {
  .cd-breadcrumb.triangle {
    /* reset basic style */
    background-color: transparent;
    padding: 0;
  }
  .cd-breadcrumb.triangle li {
    position: relative;
    padding: 0;
    margin: 4px 4px 4px 0;
  }
  .cd-breadcrumb.triangle li:last-of-type {
    margin-right: 0;
  }
  .cd-breadcrumb.triangle li > * {
    position: relative;
    padding: 1em .8em 1em 2.5em;
    color: #2c3f4c;
    background-color: #edeff0;
    /* the border color is used to style its ::after pseudo-element */
    border-color: #edeff0;
  }
  .cd-breadcrumb.triangle li.current > * {
    /* selected step */
    color: #ffffff;
    background-color: #96c03d;
    border-color: #96c03d;
  }
  .cd-breadcrumb.triangle li:first-of-type > * {
    padding-left: 1.6em;
    border-radius: .25em 0 0 .25em;
  }
  .cd-breadcrumb.triangle li:last-of-type > * {
    padding-right: 1.6em;
    border-radius: 0 .25em .25em 0;
  }
  .no-touch .cd-breadcrumb.triangle a:hover {
    /* steps already visited */
    color: #ffffff;
    background-color: #2c3f4c;
    border-color: #2c3f4c;
  }
  .cd-breadcrumb.triangle li::after, .cd-breadcrumb.triangle li > *::after {
    /* 
        li > *::after is the colored triangle after each item
        li::after is the white separator between two items
    */
    content: '';
    position: absolute;
    top: 0;
    left: 100%;
    content: '';
    height: 0;
    width: 0;
    /* 48px is the height of the <a> element */
    border: 24px solid transparent;
    border-right-width: 0;
    border-left-width: 20px;
  }
  .cd-breadcrumb.triangle li::after {
    /* this is the white separator between two items */
    z-index: 1;
    -webkit-transform: translateX(4px);
    -moz-transform: translateX(4px);
    -ms-transform: translateX(4px);
    -o-transform: translateX(4px);
    transform: translateX(4px);
    border-left-color: #ffffff;
    /* reset style */
    margin: 0;
  }
  .cd-breadcrumb.triangle li > *::after {
    /* this is the colored triangle after each element */
    z-index: 2;
    border-left-color: inherit;
  }
  .cd-breadcrumb.triangle li:last-of-type::after, .cd-breadcrumb.triangle li:last-of-type > *::after {
    /* hide the triangle after the last step */
    display: none;
  }
  .cd-breadcrumb.triangle.custom-separator li::after {
    /* reset style */
    background-image: none;
  }
  .cd-breadcrumb.triangle.custom-icons li::after, .cd-breadcrumb.triangle.custom-icons li > *::after {
    /* 50px is the height of the <a> element */
    border-top-width: 25px;
    border-bottom-width: 25px;
  }

  @-moz-document url-prefix() {
    .cd-breadcrumb.triangle li::after,
    .cd-breadcrumb.triangle li > *::after {
      /* fix a bug on Firefix - tooth edge on css triangle */
      border-left-style: dashed;
    }
  }
}
/* -------------------------------- 

Custom icons hover effects - breadcrumb and multi-steps

-------------------------------- */
@media only screen and (min-width: 768px) {
  .no-touch .cd-breadcrumb.triangle.custom-icons li:first-of-type a:hover::before, .cd-breadcrumb.triangle.custom-icons li.current:first-of-type em::before, .no-touch .cd-multi-steps.text-center.custom-icons li:first-of-type a:hover::before, .cd-multi-steps.text-center.custom-icons li.current:first-of-type em::before {
    /* change custom icon using image sprites - hover effect or current item */
    background-position: 0 -40px;
  }
  .no-touch .cd-breadcrumb.triangle.custom-icons li:nth-of-type(2) a:hover::before, .cd-breadcrumb.triangle.custom-icons li.current:nth-of-type(2) em::before, .no-touch .cd-multi-steps.text-center.custom-icons li:nth-of-type(2) a:hover::before, .cd-multi-steps.text-center.custom-icons li.current:nth-of-type(2) em::before {
    background-position: -20px -40px;
  }
  .no-touch .cd-breadcrumb.triangle.custom-icons li:nth-of-type(3) a:hover::before, .cd-breadcrumb.triangle.custom-icons li.current:nth-of-type(3) em::before, .no-touch .cd-multi-steps.text-center.custom-icons li:nth-of-type(3) a:hover::before, .cd-multi-steps.text-center.custom-icons li.current:nth-of-type(3) em::before {
    background-position: -40px -40px;
  }
  .no-touch .cd-breadcrumb.triangle.custom-icons li:nth-of-type(4) a:hover::before, .cd-breadcrumb.triangle.custom-icons li.current:nth-of-type(4) em::before, .no-touch .cd-multi-steps.text-center.custom-icons li:nth-of-type(4) a:hover::before, .cd-multi-steps.text-center.custom-icons li.current:nth-of-type(4) em::before {
    background-position: -60px -40px;
  }
}
/* -------------------------------- 

Multi steps indicator 

-------------------------------- */
@media only screen and (min-width: 768px) {
  .cd-multi-steps {
    /* reset style */
    background-color: transparent;
    padding: 0;
    text-align: center;
  }

  .cd-multi-steps li {
    position: relative;
    float: none;
    margin: 0.4em 40px 0.4em 0;
  }
  .cd-multi-steps li:last-of-type {
    margin-right: 0;
  }
  .cd-multi-steps li::after {
    /* this is the line connecting 2 adjacent items */
    position: absolute;
    content: '';
    height: 4px;
    background: #edeff0;
    /* reset style */
    margin: 0;
  }
  .cd-multi-steps li.visited::after {
    background-color: #96c03d;
  }
  .cd-multi-steps li > *, .cd-multi-steps li.current > * {
    position: relative;
    color: #2c3f4c;
  }

  .cd-multi-steps.custom-separator li::after {
    /* reset style */
    height: 4px;
    background: #edeff0;
  }

  .cd-multi-steps.text-center li::after {
    width: 100%;
    top: 50%;
    left: 100%;
    -webkit-transform: translateY(-50%) translateX(-1px);
    -moz-transform: translateY(-50%) translateX(-1px);
    -ms-transform: translateY(-50%) translateX(-1px);
    -o-transform: translateY(-50%) translateX(-1px);
    transform: translateY(-50%) translateX(-1px);
  }
  .cd-multi-steps.text-center li > * {
    z-index: 1;
    padding: .6em 1em;
    border-radius: .25em;
    background-color: #edeff0;
  }
  .no-touch .cd-multi-steps.text-center a:hover {
    background-color: #2c3f4c;
  }
  .cd-multi-steps.text-center li.current > *, .cd-multi-steps.text-center li.visited > * {
    color: #ffffff;
    background-color: #96c03d;
  }
  .cd-multi-steps.text-center.custom-icons li.visited a::before {
    /* change the custom icon for the visited item - check icon */
    background-position: 0 -60px;
  }

  .cd-multi-steps.text-top li, .cd-multi-steps.text-bottom li {
    width: 120px;
    text-align: center;
  }
  .cd-multi-steps.text-top li::after, .cd-multi-steps.text-bottom li::after {
    /* this is the line connecting 2 adjacent items */
    position: absolute;
    left: 50%;
    /* 40px is the <li> right margin value */
    width: calc(100% + 40px);
  }
  .cd-multi-steps.text-top li > *::before, .cd-multi-steps.text-bottom li > *::before {
    /* this is the spot indicator */
    content: '';
    position: absolute;
    z-index: 1;
    left: 50%;
    right: auto;
    -webkit-transform: translateX(-50%);
    -moz-transform: translateX(-50%);
    -ms-transform: translateX(-50%);
    -o-transform: translateX(-50%);
    transform: translateX(-50%);
    height: 12px;
    width: 12px;
    border-radius: 50%;
    background-color: #edeff0;
  }
  .cd-multi-steps.text-top li.visited > *::before,
  .cd-multi-steps.text-top li.current > *::before, .cd-multi-steps.text-bottom li.visited > *::before,
  .cd-multi-steps.text-bottom li.current > *::before {
    background-color: #96c03d;
  }
  .no-touch .cd-multi-steps.text-top a:hover, .no-touch .cd-multi-steps.text-bottom a:hover {
    color: #96c03d;
  }
  .no-touch .cd-multi-steps.text-top a:hover::before, .no-touch .cd-multi-steps.text-bottom a:hover::before {
    box-shadow: 0 0 0 3px rgba(150, 192, 61, 0.3);
  }

  .cd-multi-steps.text-top li::after {
    /* this is the line connecting 2 adjacent items */
    bottom: 4px;
  }
  .cd-multi-steps.text-top li > * {
    padding-bottom: 20px;
  }
  .cd-multi-steps.text-top li > *::before {
    /* this is the spot indicator */
    bottom: 0;
  }

  .cd-multi-steps.text-bottom li::after {
    /* this is the line connecting 2 adjacent items */
    top: 3px;
  }
  .cd-multi-steps.text-bottom li > * {
    padding-top: 20px;
  }
  .cd-multi-steps.text-bottom li > *::before {
    /* this is the spot indicator */
    top: 0;
  }
}
/* -------------------------------- 

Add a counter to the multi-steps indicator 

-------------------------------- */
.cd-multi-steps.count li {
  counter-increment: steps;
}

.cd-multi-steps.count li > *::before {
  content: counter(steps) " - ";
}

@media only screen and (min-width: 768px) {
  .cd-multi-steps.text-top.count li > *::before,
  .cd-multi-steps.text-bottom.count li > *::before {
    /* this is the spot indicator */
    content: counter(steps);
    height: 26px;
    width: 26px;
    line-height: 26px;
    font-size: 1.4rem;
    color: #ffffff;
  }

  .cd-multi-steps.text-top.count li:not(.current) em::before,
  .cd-multi-steps.text-bottom.count li:not(.current) em::before {
    /* steps not visited yet - counter color */
    color: #2c3f4c;
  }

  .cd-multi-steps.text-top.count li::after {
    bottom: 11px;
  }

  .cd-multi-steps.text-top.count li > * {
    padding-bottom: 34px;
  }

  .cd-multi-steps.text-bottom.count li::after {
    top: 11px;
  }

  .cd-multi-steps.text-bottom.count li > * {
    padding-top: 34px;
  }
}

</style>
     <?php $form = ActiveForm::begin([
        //'validateOnSubmit' => true,
        'enableAjaxValidation' => true,
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                      'enctype'=>'multipart/form-data',
                    ]
    ]); ?>
    

<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

        <nav>
            <ol class="cd-multi-steps text-bottom count">
                <li class="visited"><a href="<?= Url::to(['tercero/step1','id' => Yii::$app->request->get('id')]); ?>">Personal</a></li>
                <li class="current"><a href="<?= Url::to(['tercero/step2','id' => Yii::$app->request->get('id')]); ?>">Complementaria</a></li>
                <li><em>Acudiente</em></li>
                <li><em>Contáctos</em></li>
                <li><em>Foto</em></li>
                <li><em>Matrícula</em></li>
            </ol>
        </nav>
    </div>

     

            
  <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información Complementaria</h3>
        </div>

        <div class="panel-body">
            
            <div class="row">
                <div class = "col-sm-12">
                    <?= $form->errorSummary($model); ?>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'estrato')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(\backend\models\base\Estrato::find()->orderBy('id')->asArray()->all(), 'id', 'estrato'),
                        'options' => ['placeholder' => 'Seleccione el Estrato'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>

                <div class="col-sm-3">
                    <?= $form->field($model, 'rh')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Rh::find()->orderBy('id')->asArray()->all(), 'id', 'rh'),
                        'options' => ['placeholder' => 'Seleccione el Grupo Sanguineo y RH'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">    
                    <?= $form->field($model, 'eps')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Eps::find()->orderBy('id')->asArray()->all(), 'id', 'eps'),
                        'options' => ['placeholder' => 'Seleccione la EPS'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div id="info-sisben" style="display:<?= $model->eps == '2' ? 'block' : 'none' ?>;" class="col-sm-3">
                    <?= $form->field($model, 'codigo_sisben')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(\backend\models\base\Tiposisben::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => 'Seleccione el Grupo'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>

            </div>
            <div class="row">
                
                <div class="col-sm-3">
                    <?= $form->field($model, 'codigo_familia_accion')->textInput(['maxlength' => true, 'placeholder' => 'Código Familias en Acción']) ?>
                </div>  
                <div class="col-sm-3">
                    <?= $form->field($model, 'cabeza_familia')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione',
                            'allowClear' => true,
                        ]
                    ]);
                    ?>  
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'subsidio')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'recurso')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(\backend\models\base\Tiporecurso::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => 'Seleccione el Tipo de Recurso'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
            </div>
            <div class="row">
                
                <div class="col-sm-3">
                    <?= $form->field($model, 'situacion')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(\backend\models\base\Tiposituacion::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => 'Seleccione el Tipo de Situación'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div id="info-codigo_desplazado" style="display:<?= $model->situacion == '3' ? 'block' : 'none' ?>;" class="col-sm-3">
                    <?= $form->field($model, 'codigo_desplazado')->textInput(['maxlength' => true, 'placeholder' => 'Código de Desplazado']) ?>
                </div> 
                <div id="info-desplazado_departamento" style="display:<?= $model->situacion == '3' ? 'block' : 'none' ?>;" class="col-sm-3">
                    <?= $form->field($model, 'departamento_desplazado')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Departamento::find()->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                        'options' => ['id'=>'dep-des-id',],
                        'pluginOptions' => [
                            'placeholder' => 'Seleccione el Departamento',
                            'allowClear' => true,
                        ],
                    ]) ?> 
                </div> 
                <div id="info-desplazado_municipio" style="display:<?= $model->situacion == '3' ? 'block' : 'none' ?>;" class="col-sm-3">
                    <?= $form->field($model, 'municipio_desplazado')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data' => ArrayHelper::map(Municipio::find()->where(['=', 'departamento', $model->departamento_desplazado])->orderBy('nombre')->asArray()->all(), 'id', 'nombre'),
                        'options'=>['id'=>'mun-des-id'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione el Municipio',
                            'depends'=>['dep-des-id'],
                            'url'=>Url::to(['tercero/findmunicipios']),
                        ]
                    ]);
                    ?>
                </div> 
                

            </div>
            <div class="row">
                 
                <div class="col-sm-6">
                    <?= $form->field($model, 'capacidad')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(\backend\models\base\Tipocapacidad::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => 'Seleccione la Capacidad Excepcional'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'discapacidad')->textInput(['maxlength' => true, 'placeholder' => 'Discapacidad']) ?>
                </div> 

                <div id="info-discapacidad_certificada" style="display:<?= $model->discapacidad != '' ? 'block' : 'none' ?>;" class="col-sm-3">
                    <?= $form->field($model, 'discapacidad_certificada')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione Discapacidad Certificada'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                


            </div>
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($model, 'medicamentos')->textInput(['maxlength' => true, 'placeholder' => 'Medicamentos']) ?>
                </div> 
                <div class="col-sm-6">
                    <?= $form->field($model, 'alergias')->textInput(['maxlength' => true, 'placeholder' => 'Alergias']) ?>
                </div>  
            </div>
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($model, 'bienestar')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'heroe')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione Beneficiario Héroes Nacionales'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'fuerza_publica')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione Beneficiario Fuerza Pública'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
                <div class="col-sm-3">
                    <?= $form->field($model, 'sector')->widget(Select2::classname(), [
                        'data' => [1 => 'Si', 0 => 'No'],
                        'options' => ['placeholder' => 'Seleccione Sector Privado'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div> 
            </div>
            <div class="row">
                <div class="col-sm-3">    
                    <?= $form->field($model, 'religion')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Religion::find()->orderBy('id')->asArray()->all(), 'id', 'religion'),
                        'options' => ['placeholder' => 'Seleccione la Creencia Religiosa'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">    
                    <?= $form->field($model, 'etnia')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Etnia::find()->orderBy('id')->asArray()->all(), 'id', 'etnia'),
                        'options' => ['placeholder' => 'Seleccione la Etnia'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div id="info-departamento_resguardo" class="col-sm-3">
                    <?= $form->field($model, 'departamento_resguardo')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Departamento::find()->orderBy('id')->asArray()->all(), 'id', 'nombre'),
                        'options' => ['id'=>'dep-resg-id'],
                        'pluginOptions' => [
                            'placeholder' => 'Seleccione Departamento',
                            'allowClear' => true,
                        ],
                    ]) ?>
                </div>       
                <div id="info-resguardo" class="col-sm-3">
                    <?= $form->field($model, 'resguardo')->widget(DepDrop::classname(), [
                        //'data' => ArrayHelper::map(Resguardo::find()->orderBy('id')->asArray()->all(), 'id', 'resguardo'),
                        'type'=>DepDrop::TYPE_SELECT2,
                        'options'=>['id'=>'resguardo-id'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione el Resguardo',
                            'depends'=>['dep-resg-id'],
                            'url'=>Url::to(['tercero/findresguardos']),
                            'allowClear' => true,
                        ]
                    ]);
                    ?>  
                </div>  

            </div> 

            <?= Html::submitButton('<i class="fa fa-floppy"></i> Guardar & Siguiente', ['class' => 'btn btn-primary btn-block']) ?>
    </div>   








        </div>
    </div>



   
    
  </div>
</div>





    <?php ActiveForm::end(); ?>