<?php

use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;
use kartik\dialog\DialogAsset;

use backend\models\Tercero;
use backend\models\Genero;
use backend\models\Tipotercero;
use backend\models\Grupo;
use backend\models\Parentesco;
use backend\models\Departamento;
use backend\models\Municipio;
use backend\models\Rh;
use backend\models\Religion;
use backend\models\Etnia;
use backend\models\Eps;
use backend\models\Barrio;
use backend\models\Terceroestado;
use backend\models\Academico;
use backend\models\Sede;

use yii\helpers\Url;

$sede = Sede::find()->where(['principal' => '1'])->one();

$this->registerJs('

    $(".crear-usuario2").click(function(){
            
        $("#"+this.id).remove();
        $("#user-"+this.id).html("<img src=\"'.Url::to('@web/images/loading-plugin.gif').'\">");    
            
        $.ajax({
            type: "POST",
            url: "'. Url::to(['add-usuario']).'",
            data: {id : this.id},
            success: function (data) {
                

                $("#user-"+data).html("<span class=\"glyphicon glyphicon-lock text-success\"></span>");  
                
                swal({
                    title: "En Horabuena!",
                    text: "Se ha configurado para ingresar al sistema el usuario y contraseña "+data,
                    type: "success",
                    timer: 1000,
                }); 
                
            }
        });
            
    });


    $(".search-button").click(function(){
        $(".search-form").toggle(1000);
        return false;
    });

');


$this->title = 'Terceros';
$this->params['breadcrumbs'][] = $this->title;


$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

?>


<script type="text/javascript">         

    function usuario(id) 
    {      
        $("#"+id).remove();
        
        $("#user-"+id).html("<img src=\"<?= Url::to('@web/images/loading-plugin.gif') ?>\">");    
          
        $.ajax({
            type: "POST",
            url: "<?= Url::to(['add-usuario']) ?>",
            data: {id : id},
            success: function (data) {
                

                $("#user-"+data).html("<span class=\"glyphicon glyphicon-lock text-success\"></span>");  
                
                swal({
                    title: "En Horabuena!",
                    text: "Se ha configurado para ingresar al sistema el usuario y contraseña "+data,
                    type: "success"
                }); 
                
            }
        });
    }
</script>


    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>


<div class="row blanco">

        <?php 

    $gridColumn = [
        //['class'=>'kartik\grid\SerialColumn', 'order'=>DynaGrid::ORDER_FIX_LEFT],
        [
            'class' => 'kartik\grid\ExpandRowColumn',
            'width' => '50px',
            'value' => function ($model, $key, $index, $column) {
                return GridView::ROW_COLLAPSED;
            },
            'detail' => function ($model, $key, $index, $column) {
                return Yii::$app->controller->renderPartial('_expand', ['model' => $model]);
            },
            'headerOptions' => ['class' => 'kartik-sheet-style'],
            'expandOneOnly' => true
        ],
        [
            'attribute' => '', 
            'format' => 'raw',
            'width' => '50px',
            'value' => function($model){
                return Html::img($model->foto ? '@web/uploads/thumbnail/sm-'.$model->foto : '@web/images/user.jpg', ['class'=>'img-36 rounded-circle']);
            },
            'filter'=>false,
            'visible' => true
        ],
        [
                'attribute' => 'identificacion',
                'label' => 'Identificación',
                'format' => 'RAW',
                'width' => '80px',
                'filterInputOptions' => ['placeholder' => 'Identificación', 'class' => 'form-control', 'id' => 'grid-tercero-search-identificacion'],
                'visible' => true
        ],

        /*
        [
                'attribute' => 'tipo',
                'label' => 'Tipo',
                'value' => function($model){
                    return $model->tipos->tipo;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Tipodocumento::find()->asArray()->all(), 'id', 'tipo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tipo documento', 'id' => 'grid-tercero-search-tipo']
            ],*/
        
        [
                'attribute' => 'primer_nombre',
                'label' => 'Primer Nombre',
                'format' => 'RAW',
                'width' => '120px',
                'filterInputOptions' => ['placeholder' => 'Primer Nombre', 'class' => 'form-control', 'id' => 'grid-tercero-search-primer-nombre']
        ],
        [
                'attribute' => 'segundo_nombre',
                'label' => 'Segundo Nombre',
                'format' => 'RAW',
                'width' => '120px',
                'visible' => true,
                'filterInputOptions' => ['placeholder' => 'Segundo Nombre', 'class' => 'form-control', 'id' => 'grid-tercero-search-segundo-nombre']
        ],
        [
                'attribute' => 'primer_apellido',
                'label' => 'Primer Apellido',
                'format' => 'RAW',
                'width' => '120px',
                'filterInputOptions' => ['placeholder' => 'Primer Apellido', 'class' => 'form-control', 'id' => 'grid-tercero-search-primer-apellido']
        ],
        [
                'attribute' => 'segundo_apellido',
                'label' => 'Segundo Apellido',
                'format' => 'RAW',
                'width' => '120px',
                'visible' => true,
                'filterInputOptions' => ['placeholder' => 'Segundo Apellido', 'class' => 'form-control', 'id' => 'grid-tercero-search-segundo-apellido']
        ],
        [
                'attribute' => 'genero',
                'label' => 'Género',
                'width' => '80px',
                'value' => function($model){
                    return $model->generos->genero;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Genero::find()->asArray()->all(), 'id', 'genero'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Genero', 'id' => 'grid-tercero-search-genero']
        ],
        [
                'attribute' => 'tipo_tercero',
                'label' => 'Tipo',
                'width' => '80px',
                'format' => 'RAW',
                'value' => function($model){
                    if ($model->tipo_tercero==1) $color="success";
                    if ($model->tipo_tercero==2) $color="info";
                    if ($model->tipo_tercero==3) $color="warning";
                    if ($model->tipo_tercero==4) $color="danger";  

                    return '<span class="label label-'.$color.'">'.$model->tipoterceros->tipo.'</span>';
                },
                'contentOptions'=>['style'=>'text-align:center;'],
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Tipotercero::find()->asArray()->all(), 'id', 'tipo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tipo', 'id' => 'grid-tercero-search-tipo_tercero']
        ],     
        [
                'attribute' => 'estado',
                'label' => 'Estado',
                'width' => '80px',
                'format' => 'RAW',
                'value' => function($model){
                    if ($model->tipo_tercero =='1')
                    {
                        $color = "default";
                        if ($model->estado==1) $color="success";
                        if ($model->estado==2) $color="info";
                        if ($model->estado==3) $color="warning";
                        if ($model->estado==4) $color="danger"; 

                        
                        if (($model->estado==5) or ($model->estado==7) or ($model->estado==9)) $color="success";
                        if (($model->estado==6) or ($model->estado==8) or ($model->estado==10)) $color="danger"; 

                        if ($model->estado==9) $color="default"; 

                        $estado = '<span class="label label-'.$color.'">';
                        $estado .= !$model->estado ? 'No Definido' : $model->estados->estado;
                        $estado .='</span>';
                        return $estado;
                    } 
                    else
                    {
                        return '';
                    }   

                    
                },
                'contentOptions'=>['style'=>'width: 120px; text-align:center;'],
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Terceroestado::find()->where(['<=','id',4])->asArray()->all(), 'id', 'estado'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Estado', 'id' => 'grid-tercero-search-estado']
        ],
        [
                'attribute' => 'grupo',
                'format' => 'RAW',
                'value' => function($model){

                            if ($model->grupoid == '0')
                            {
                                return ($model->tipo_tercero==1) ? Html::a('<span class="label label-danger">Sin Grupo</span>',['/academico/create', 'tercero' => $model->id]) : ''; 
                            }
                            else
                            {
                                $data = Grupo::findOne($model->grupoid);
                                return '<span class="label label-primary">'.$data->grupo.'</span>';
                            } 
                            
                                
                },
                'width' => '60px',
                'contentOptions'=>['style'=>'text-align:center;'],

                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Grupo::find()->asArray()->all(), 'id', 'grupo'),
                //'filter' => array_merge(['0' => "Sin Grupo"], ArrayHelper::map(Grupo::find()->asArray()->all(), 'id', 'id'.'-'.'grupo')),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grupo', 'id' => 'grid-academico-search-grupo']
        ],

        /*  
        [
                'attribute' => 'user',
                'label' => '',
                'format' => 'RAW',
                'visible' => false,
                'value' => function($model){
                            return ($model->user==0) ? '<div id ="user-'.$model->identificacion.'" >'.Html::button('<i class="fa fa-key text-danger"></i>', [ 'class' => 'btn btn-link btn-xs crear-usuario', 'id' => $model->identificacion ]).'</div>' : '<center><i class="fa fa-user text-success"></i></center>'; 
                           },
        ],   */ 
        [
                'attribute' => 'parentesco',
                'label' => 'Parentesco',
                'visible' => false,
                'value' => function($model){
                    return $model->parentesco ? $model->parentesco->parentesco : '';
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Parentesco::find()->asArray()->all(), 'id', 'parentesco'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Parentesco', 'id' => 'grid-tercero-search-parentesco']
        ],
        [       'attribute' => 'fecha_nacimiento',
                'visible' => false,
        ],        
        [
                'attribute' => 'departamento_nacimiento',
                'label' => 'Departamento Nacimiento',
                'visible' => false,
                'value' => function($model){
                    return $model->departamento_nacimiento ? $model->departamentos->id : '';
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Departamento::find()->asArray()->all(), 'id', 'id'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Departamento', 'id' => 'grid-tercero-search-departamento_nacimiento']
        ],
        [
                'attribute' => 'municipio_nacimiento',
                'label' => 'Municipio Nacimiento',
                'visible' => false,
                'value' => function($model){
                    return $model->municipio_nacimiento ? $model->municipios->id : '';
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Municipio::find()->asArray()->all(), 'id', 'id'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Municipio', 'id' => 'grid-tercero-search-municipio_nacimiento']
        ],
        [
                'attribute' => 'rh',
                'label' => 'Rh',
                'visible' => false,
                'value' => function($model){
                    return $model->rh ? $model->rhs->rh : '';
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Rh::find()->asArray()->all(), 'id', 'rh'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Rh', 'id' => 'grid-tercero-search-rh']
        ],
        [
                'attribute' => 'religion',
                'label' => 'Religion',
                'visible' => false,
                'value' => function($model){
                            return $model->religion ? $model->religiones->religion : '';
                        },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Religion::find()->asArray()->all(), 'id', 'religion'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Religion', 'id' => 'grid-tercero-search-religion']
        ],
        [
                'attribute' => 'etnia',
                'label' => 'Etnia',
                'visible' => false,
                'value' => function($model){
                    return $model->etnia ? $model->etnias->etnia : '';
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Etnia::find()->asArray()->all(), 'id', 'etnia'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Etnia', 'id' => 'grid-tercero-search-etnia']
        ],
        [
                'attribute' => 'eps',
                'label' => 'Eps',
                'visible' => false,
                'value' => function($model){
                    return $model->eps ? $model->epss->eps : '';
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Eps::find()->asArray()->all(), 'id', 'eps'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Eps', 'id' => 'grid-tercero-search-eps']
        ],
        [
                'attribute' => 'direccion',
                'visible' => false,
        ],
        [
                'attribute' => 'barrio',
                'label' => 'Barrio',
                'visible' => false,
                'value' => function($model){
                    return $model->barrio ? $model->barrios->nombre : '';
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ArrayHelper::map(Barrio::find()->where(['municipio' => $sede->municipio])->asArray()->all(), 'id', 'nombre'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Barrio', 'id' => 'grid-tercero-search-barrio']
        ],
        [       'attribute' => 'fijo',
                'visible' => false,
        ],
        [
                'attribute' => 'movil',
                'visible' => false,
        ],
        [
                'attribute' => 'email',
                'visible' => false,
        ],
        [
                'attribute' => 'foto',
                'visible' => false,
        ],
        [
                'attribute' => 'acudiente',
                'visible' => false,
        ],
        [
                'attribute' => 'eliminado',
                'visible' => false,
        ],
        [
                'attribute' => 'eliminado',
                'label' => 'Eliminado',
                /*'visible' => function($model){

                    $search = Yii::$app->request->get('TerceroSearch');

                    if ($search['eliminado'] == '1')
                    {
                        return true;
                    }
                    elseif (!isset($search['eliminado'])) {
                        return false;
                    }
                    elseif ($search['eliminado'] == '0')
                    {
                        return false;
                    }
                },    */
                'visible' => false,
                'width' => '80px',
                'format' => 'RAW',
                'value' => function($model){
                    
                    $search = Yii::$app->request->get('TerceroSearch');

                    if ($search['eliminado'] == 1)
                    {
                        $tercero = Tercero::findOne($model->eliminado_por);
                        $fecha = Yii::$app->formatter->asDate($model->eliminado_el, 'long');
                        return Html::tag('span', 'Eliminado', ['class'=>'label label-danger', 'data-toggle' => 'tooltip', 'title' => $tercero->nombre.' - '.$fecha]); 
                    }
                    else
                    {
                        return '';
                    }
                    
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => ['0'=>'Sin Eliminar','1'=>'Eliminado'],
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => false],
                ],
                'filterInputOptions' => ['placeholder' => 'Eliminado', 'id' => 'grid-tercero-search-eliminado']
                
        ],
        [
            'class'=>'kartik\grid\ActionColumn',
            'width' => '120px',
            'template' => '{view} {update} {usuario} {hv} {delete}',
            'buttons'=>[
                          'usuario' => function($url, $model){
                            return (!isset($model->usuario)) ? 
                                '<div id ="user-'.$model->identificacion.'" style="clear:both; cursor: pointer; display:inline-block;" >'.Html::a('<span class="glyphicon glyphicon-user text-danger" aria-hidden="true"></span>', false,[ 'title' => 'Crear Usuario', 'class' => 'crear-usuario', 'id' => $model->identificacion, 'onClick' => 'usuario('.$model->identificacion.')' ,'data-pjax' => '0']).'</div>' : 
                                '<div id ="user-'.$model->identificacion.'" style="clear:both; cursor: pointer; display:inline-block;" >'.Html::a('<span class="glyphicon glyphicon-lock text-success" aria-hidden="true"></span>', false,[ 'title' => 'Restaurar Contraseña', 'class' => 'crear-usuario', 'id' => $model->identificacion, 'data-pjax' => '0']).'</div>'; 
                           }, 
                           'hv' => function($url, $model){
                            return ($model->tipo_tercero==1) ? Html::a('<span class="glyphicon glyphicon-download-alt" aria-hidden="true"></span>', ['tercero/hojadevida', 'id' => $model->id],[ 'title' => 'Descargar Hoja de Vida','data-pjax' => '0','target' => '_blank']) :''; 
                           }, 
/*
                           'delete' => function ($url, $model) {
                              return Html::a('<span class="glyphicon glyphicon-plus"></span>', $url,

                                  [  
                                     'title' => Yii::t('yii', 'delete'),
                                     'data-confirm' => "Are you sure you want to delete this item?",
                                     'data-method' => 'post',
                                     'data-pjax' => 0
                                  ]);
                         }
*/
                        ],       
            'dropdown'=>false,
            'order'=>DynaGrid::ORDER_FIX_RIGHT
        ],
        //['class'=>'kartik\grid\CheckboxColumn',  'order'=>DynaGrid::ORDER_FIX_RIGHT],
    ]; 
    ?>

<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'tercero'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>

</div>
