<?php

use yii\helpers\Html;
use yii\bootstrap\Progress;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model backend\models\tercero */

$this->title = 'Crear Usuarios';
$this->params['breadcrumbs'][] = ['label' => 'Terceros', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;


    $total = count($terceros);
    $avanza = 100 / $total;

?>



<div class="row">
    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
    	<?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'position:fixed;']); ?>
    </div>
    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
        <div class="row">
            <div class="col-lg-12 col-md-6 col-sm-6 col-xs-12">
                <p class='titulo'><?= Yii::t('app', '¿Deseas crear los usuarios de los terceros que no lo tienen acceso al sistema?') ?></p>
                <p class='observaciones'><?= Yii::t('app', 'Se procesara la creación de usuarios para <span class="text-danger">{terceros}</span> terceros del sistema.', ['terceros' => count($terceros)]) ?></p>
            </div>
        </div> 
        <div class="row">
            <div id="aplicar" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?= Html::Button('Crear Usuarios', ['class' => 'btn btn-danger btn-block']); ?>
            </div>
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12" style="margin-top: 10px;">
                <?php
                    echo Progress::widget([
                        'percent' => 0,
                        'barOptions' => ['class' => 'progress-bar-info',],
                        'options' => ['id' => 'progBar', 'class' => 'active progress-striped', 'style' => 'display: none;']
                    ]);
                ?>
            </div>
        </div>

        <div class="row" style="margin-top: 10px;">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
	        	<div class="list-group">
	        		<?
	        			$datos = [];
				    	
				    	if(count($terceros) == '0')
				    	{
				    		echo "<center><h4 class='text-success'>".Yii::t('app', 'Todos los terceros tienen usuario creado!')."</h4></center>";
				    	}
				    	else
				    	{
					    	foreach ($terceros as $tercero) 
					    	{
					    		$datos[] = $tercero->identificacion;

		  						echo '<li class="list-group-item list-group-item-action">';
								echo $tercero->nombre;

								if ($tercero->tipo_tercero==1) $color="success";
			                    if ($tercero->tipo_tercero==2) $color="info";
			                    if ($tercero->tipo_tercero==3) $color="warning";
			                    if ($tercero->tipo_tercero==4) $color="danger";  

			                    echo '&nbsp;&nbsp;<span class="label label-'.$color.'">'.$tercero->tipoterceros->tipo.'</span>';
								
								if(isset($tercero->usuario))
								{
									echo '<i class="fas fa-check text-success" style="float:right;"></i>';
								}
								else
								{
									echo '<i class="fas fa-times text-danger" style="float:right;"></i>';
								}

	  							
	  							echo '</li>';
					    	}
					    }
				    ?>
	        	</div>
    		</div>
		</div>        
	</div>
</div>




<?

$out = array_values($datos);
$ids = json_encode($out);

$this->registerJs("

$(document).ready(function() {
    
    $('#aplicar').click(function() {

        var avanza = 0;
        periodo = $('#promedio-periodo').val();


        $('#progBar').slideDown().show();
        $('.progress-bar')[0].style.width = 0;

        //$('#aplicar').html(\"<h4 class='text-success'><i class='fa fa-clock'></i> Estamos trabajando en ello.</h4> \");

        ids = $ids;
        
        $.each(ids, function(indice, valor){    

            $('#'+valor).html(\"<div id='loading-wrapper-e'><div class='object-e' id='first_object_e'></div><div class='object-e' id='second_object_e'></div></div>\");

            $.ajax({
                type: 'POST',
                url: '". Url::to(['ivan'])."',
                //timeout: 60000,

                data: {grupo : valor, periodo : periodo},
                success: function (data) {
                	alert(valor + '-' + periodo);
                    $('#'+valor).html(\"<i class='fas fa-check text-success'></i>\");
                    
                    $('.progress-bar').css(\"width\", parseFloat($('.progress-bar')[0].style.width) + ".$avanza." + \"%\");
                    console.log(parseFloat($('.progress-bar')[0].style.width));
                        
                    if(parseInt($('.progress-bar')[0].style.width) >= 100)
                    {
                        $('.progress-bar').toggleClass(\"progress-bar-info \" + \"progress-bar-success\");    
                    }    
                    
                },
                error: function(request, status, err) {
                    if (status == 'timeout') {
                        //timeout -> reload the page and try again
                        $('#'+valor).html(\"<i class='fas fa-times text-danger'></i>\");
                        console.log('timeout');
                        //window.location.reload();
                    } else {
                        $('#'+valor).html(\"<span class='text-danger'>\"+ err + \"</span>\");
                        //another error occured  
                        //alert('error: ' + request + status + err);
                    }
                }
        
            });

        });
        
    });

});

");

?>
